package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.*;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocMoneyUtil;
import com.tydic.dyc.oc.utils.UocOrderPropertiesUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

@HTServiceImpl
@Slf4j
public class UocMsgSplitOrderServiceImpl implements UocMsgSplitOrderService {
    
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    
    @Autowired
    private IUocOrderModel iUocOrderModel;
    
    @Autowired
    private IUocCommonModel iUocCommonModel;
    
    @Override
    public UocMsgSplitOrderRspBo splitOrder(UocMsgSplitOrderReqBo reqBo) {
        UocMsgSplitOrderRspBo rspBo = UocRu.success(UocMsgSplitOrderRspBo.class);
        //查询销售订单信息
        UocSaleOrderDo uocSaleOrderDo = qrySale(reqBo);
        if(ObjectUtil.isEmpty(uocSaleOrderDo)){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR,"订单拆单通知业务失败：未查询到销售订单信息!");
        }
    
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        taskInstQryBo.setObjId(uocSaleOrderDo.getSaleOrderId());
        taskInstQryBo.setFinishTag(UocDicConstant.FINISH_FLAG.UN_FINISHED);
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        //查询订单任务实例
        List<UocOrderTaskInst> taskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        if(ObjectUtil.isNotEmpty(taskInsts)){
            rspBo.setTaskInstId(taskInsts.get(0).getTaskInstId());
            rspBo.setStepId(taskInsts.get(0).getProcState());
        }
        
        int count = 0;
        UocGetJDSplitOrderBO uocGetJDSplitOrderBO = reqBo.getUocGetJDSplitOrderBO();
        if(ObjectUtil.isEmpty(uocGetJDSplitOrderBO)){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR,"订单拆单通知业务失败：没有拆单消息!");
        }
        List<UocChildSaleOrderBO> childSaleOrderBOList = uocGetJDSplitOrderBO.getCOrder();
        Iterator<UocChildSaleOrderBO> iterator = childSaleOrderBOList.iterator();
    
        while (iterator.hasNext()) {
            UocChildSaleOrderBO uocChildSaleOrderBO =  iterator.next();
            if(!(uocChildSaleOrderBO.getJdOrderState() >= 7)){
//                iterator.remove();
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR,"订单拆单通知业务失败：有子订单没有完成拆单，不予进行操作!");
            }
        }
        List<UocCreateOrderServiceRspSaleOrderBo> saleOrderList = new ArrayList<>();
        for(UocChildSaleOrderBO childSaleOrderRspBO :childSaleOrderBOList){
            UocCreateOrderServiceRspSaleOrderBo serviceRspSaleOrderBo = new UocCreateOrderServiceRspSaleOrderBo();
            UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO = new UocCreateOrdByOrdSplitBO();
            uocCreateOrdByOrdSplitBO.setUocChildSaleOrderBO(childSaleOrderRspBO);
            uocCreateOrdByOrdSplitBO.setOrderId(uocSaleOrderDo.getOrderId());
            uocCreateOrdByOrdSplitBO.setSaleId(uocSaleOrderDo.getSaleOrderId());
            uocCreateOrdByOrdSplitBO.setCount(count);
            
            Long newSaleOrderId = splitCoreOrder(uocCreateOrdByOrdSplitBO);
            serviceRspSaleOrderBo.setSaleOrderId(newSaleOrderId);
            saleOrderList.add(serviceRspSaleOrderBo);
            count ++;
        }
        
        //组装返回参数
        rspBo.setOrderId(uocSaleOrderDo.getOrderId());
        rspBo.setSaleOrderList(saleOrderList);
    
        UocCommonDo uocCommonDo = new UocCommonDo();
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        taskBo.setTaskId(rspBo.getTaskInstId());
        taskBos.add(taskBo);
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(11111L);
        uocCommonDo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        log.info("拆单流转原订单的任务,{}", JSON.toJSONString(uocCommonDo));
        iUocCommonModel.dealTask(uocCommonDo);
    
    
        //处理完拆单消息后更新msgPool中的执行状态为已执行
        UocDMsgPoolQryBo qryBo = new UocDMsgPoolQryBo();
        qryBo.setId(reqBo.getDycUocQryMsgBO().getId());
        qryBo.setRunResult(1);//执行成功
        iUocOrderModel.updateMsgPoolById(qryBo);
        return rspBo;
    }
    
    /*
     * @Author lsl
     * @Description //TODO 查询销售订单信息
     * @Date 16:36 2022/4/12
     * @Param [reqBo]
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     */
    public UocSaleOrderDo qrySale(UocMsgSplitOrderReqBo reqBo){
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(reqBo.getDycUocQryMsgBO().getObjId());
        return iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }
    /*
     * @Author lsl
     * @Description //TODO 拆单核心服务
     * @Date 11:29 2022/4/13
     * @Param [orderId, saleOrderId, childSaleOrderRspBO, count]
     * @return void
     */
    public Long splitCoreOrder(UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO){
    
//        buildSaleAndItemParam(uocCreateOrdByOrdSplitBO);
        //外部子订单信息
        UocChildSaleOrderBO childSaleOrderRspBO = uocCreateOrdByOrdSplitBO.getUocChildSaleOrderBO();
        Long totalFee = 0L;
        Long freight = null;
        Long newSaleOrderId = IdUtil.nextId();
        try {
            //订单总金额（不含运费）
            totalFee = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getOrderPrice());
            //运费
            freight = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getFreight());
            if (freight == null) {
                freight = 0L;
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("通过拆单创建子订单时异常：转换订单费用错误!");
        }
    
        UocSaleOrderQryBo uocSaleOrderBo = new UocSaleOrderQryBo();
        uocSaleOrderBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
        uocSaleOrderBo.setSaleOrderId(uocCreateOrdByOrdSplitBO.getSaleId());
        UocSaleOrderDo saleOrderDo = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderBo);
        //新销售订单id
        saleOrderDo.setSaleOrderId(newSaleOrderId);
        //父销售订单id（原销售订单id）
        saleOrderDo.setUpperOrderId(uocCreateOrdByOrdSplitBO.getSaleId());
//        saleOrderDo.setSaleOrderNo(saleOrderDo.getSaleOrderNo() + "-" +  uocCreateOrdByOrdSplitBO.getCount());
        saleOrderDo.setSaleOrderNoExt(String.valueOf(childSaleOrderRspBO.getJdOrderId()));
        try {
            saleOrderDo.setTotalSaleFee(MoneyUtils.Long2BigDecimal(totalFee));
            saleOrderDo.setTotalPurchaseFee(MoneyUtils.Long2BigDecimal(totalFee));
            saleOrderDo.setTotalTransFee(MoneyUtils.Long2BigDecimal(freight));
        } catch (Exception e) {
            e.printStackTrace();
            log.error("通过拆单创建子订单时异常：转换订单费用错误!");
        }
        //销售单明细表
        List<UocOrderSkuBO> exSkuList = childSaleOrderRspBO.getSku(); //外部单品列表
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(uocCreateOrdByOrdSplitBO.getSaleId());
        List<UocSaleOrderItem> saleItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        for(UocSaleOrderItem saleOrderItem: saleItemList){
            Long newSaleOrderItemId = IdUtil.nextId();
            for (UocOrderSkuBO extSkuBo: exSkuList){
                if(saleOrderItem.getSkuExtSkuId().equals(extSkuBo.getSkuId())){
                    saleOrderItem.setPurchaseCount(new BigDecimal(extSkuBo.getNum()));
                }
            }
            saleOrderItem.setSaleOrderId(newSaleOrderId);
            saleOrderItem.setSaleOrderItemId(newSaleOrderItemId);
        }
        saleOrderDo.setSaleOrderItems(saleItemList);
    
        iUocSaleOrderModel.createSaleOrder(saleOrderDo);
        
        UocOrderQueryIndex uocOrderQueryIndex = new UocOrderQueryIndex();
        uocOrderQueryIndex.setObjId(newSaleOrderId);
        uocOrderQueryIndex.setOrderSystem(UocDicConstant.OBJ_TYPE.SALE.toString());
        uocOrderQueryIndex.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocOrderQueryIndex.setOutObjId(String.valueOf(childSaleOrderRspBO.getJdOrderId()));
        uocOrderQueryIndex.setOrderId(saleOrderDo.getOrderId());
        uocOrderQueryIndex.setId(IdUtil.nextId());
        iUocCommonModel.saveOrderQueryIndex(uocOrderQueryIndex);
        
        return newSaleOrderId;
    }
}
