//package com.tydic.dyc.oc.service.domainservice;
//
//import cn.hutool.core.util.ObjectUtil;
//import com.tydic.dyc.oc.service.domainservice.bo.UocInspOrderTemplateCreateReqBo;
//import com.tydic.dyc.oc.service.domainservice.bo.UocInspOrderTemplateCreateRspBo;
//import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderExportBO;
//import com.tydic.dyc.oc.utils.UocRu;
//import lombok.extern.ohaotian.HTServiceImpl;
//import org.apache.poi.hssf.usermodel.*;
//import org.apache.poi.ss.usermodel.BorderStyle;
//import org.apache.poi.ss.usermodel.HorizontalAlignment;
//import org.apache.poi.ss.usermodel.VerticalAlignment;
//import org.apache.poi.ss.util.CellRangeAddress;
//import org.springframework.beans.factory.annotation.Value;
//
///**
// * 标题:UocInspOrderTemplateCreateServiceImpl
// * 说明:验收单模板下载实现
// * 时间:2022/08/02 17:14
// *
// * @author tkl
// */
//@HTServiceImpl
//public class UocInspOrderTemplateCreateServiceImpl implements UocInspOrderTemplateCreateService {
//    public static final String FILE_TYPE_OSS = "OSS";
//    /**
//     * fastDfs
//     */
//    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
//    private static final String PATH = "uoc";
//
//    @Value("${plugin.file.type}")
//    private String fileType;
//    @Value("${oss.accessUrl:}")
//    private String ossFileUrl;
//    @Value("${fastdfs.httpTrackerHttpPort:}")
//    private String fastdfsHttpTrackerHttpPort;
//    @Value("${fastdfs.trackerServers:}")
//    private String fastdfsTrackerServers;
//    @Value("${fastdfs.downloadUrl}")
//    private String fastdfsDownloadUrl;
//
//    @Override
//    public UocInspOrderTemplateCreateRspBo createInspOrderTemplate(UocInspOrderTemplateCreateReqBo reqBo) {
//        UocInspOrderTemplateCreateRspBo rspBo = UocRu.success(UocInspOrderTemplateCreateRspBo.class);
//        // 创建excel表
//        HSSFWorkbook wb = new HSSFWorkbook();
//        //创建表格
//        HSSFSheet sheet = wb.createSheet("到货验收导入模板");
//        if (ObjectUtil.isNotEmpty(reqBo.getRows())) {
//            //起始索引
//            int index = 0;
//            for (UocShipOrderExportBO row : reqBo.getRows()) {
//                //创建excel模板
//                index = createExcelTemplate(sheet, wb, index, row);
//            }
//        }
//        return rspBo;
//    }
//
//
//    private int createExcelTemplate(HSSFSheet sheet, HSSFWorkbook wb, int index, UocShipOrderExportBO row) {
//        //创建标题行
//        if (index == 0) {
//            createTitleRow(wb, sheet);
//        }
//        //创建第一行
//        index = createFirstRow(sheet, index, row);
//        //创建第二行
//        index = createSecondRow(sheet, index, row);
//        //创建表头行
//        HSSFRow headRow = sheet.createRow(++index);
//        if (ObjectUtil.isNotEmpty(row.getShipOrderItemExportBOList())) {
//            row.getShipOrderItemExportBOList().forEach(each -> {
//
//            });
//        }
//        return index;
//    }
//
//    /**
//     * 创建第一行
//     *
//     * @param sheet
//     * @param index
//     * @return
//     */
//    private int createFirstRow(HSSFSheet sheet, int index, UocShipOrderExportBO row) {
//        //创建第一行
//        HSSFRow row1 = sheet.createRow(++index);
//        //创建第一列
//        HSSFCell cell1 = row1.createCell(0);
//        cell1.setCellValue("发货单编号");
//        // 创建第二列, 合并第一行的2-3列
//        sheet.addMergedRegion(new CellRangeAddress(index, index, 1, 2));
//        HSSFCell cell2 = row1.createCell(1);
//        cell2.setCellValue(row.getDeliveryOrderNo());
//        //创建第三列, 合并第一行的4-5列
//        sheet.addMergedRegion(new CellRangeAddress(index,index,3,4));
//        HSSFCell cell3 = row1.createCell(3);
//        //创建第四列, 合并第一行的6-7列
//        sheet.addMergedRegion(new CellRangeAddress(index,index,5,6));
//        HSSFCell cell4 = row1.createCell(5);
//        return index;
//    }
//
//    /**
//     * 创建第二行
//     *
//     * @param sheet
//     * @param index
//     * @return
//     */
//    private int createSecondRow(HSSFSheet sheet, int index, UocShipOrderExportBO row) {
//        //创建第二行
//        HSSFRow row2 = sheet.createRow(++index);
//        //创建第一列
//        HSSFCell cell1 = row2.createCell(0);
//        cell1.setCellValue("发货单编号");
//        // 合并第一行的2-3列
//        sheet.addMergedRegion(new CellRangeAddress(index, index, 1, 2));
//        HSSFCell cell2 = row2.createCell(1);
//        cell2.setCellValue(row.getDeliveryOrderNo());
//        return index;
//    }
//
//    /**
//     * 创建标题行
//     *
//     * @param wb
//     * @param sheet
//     */
//    private void createTitleRow(HSSFWorkbook wb, HSSFSheet sheet) {
//        //创建标题行
//        HSSFRow titleRow = sheet.createRow(0);
//        // 合并标题行的1-10列
//        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 9));
//        titleRow.setHeightInPoints(140);
//        //设置标题样式
//        HSSFCellStyle titleStyle = wb.createCellStyle();
//        setCellStyle(wb, titleStyle, true);
//        //创建标题列
//        HSSFCell titleCell = titleRow.createCell(0);
//        titleCell.setCellStyle(titleStyle);
//        //设置标题文本
//        String text = "到货验收单";
//        titleCell.setCellValue(new HSSFRichTextString(text));
//    }
//
//    /**
//     * 设置单元格样式
//     *
//     * @param wb
//     * @param bodyStyle
//     */
//    private void setCellStyle(HSSFWorkbook wb, HSSFCellStyle bodyStyle, Boolean isTitle) {
//        // 底端对齐
//        bodyStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
//        // 设置水平方向的对其方式
//        bodyStyle.setAlignment(HorizontalAlignment.LEFT);
//        //设置换行
//        bodyStyle.setWrapText(true);
//        if (!isTitle) {
//            //下边框
//            bodyStyle.setBorderBottom(BorderStyle.THIN);
//            //左边框
//            bodyStyle.setBorderLeft(BorderStyle.THIN);
//            //上边框
//            bodyStyle.setBorderTop(BorderStyle.THIN);
//            //右边框
//            bodyStyle.setBorderRight(BorderStyle.THIN);
//        }
//        //设置字体
//        HSSFFont fontStyle = wb.createFont();
//        fontStyle.setFontName("宋体");
//        fontStyle.setFontHeightInPoints((short) 11);
//        bodyStyle.setFont(fontStyle);
//    }
//}
