package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.service.order.bo.UocGetQueryOutOrderServiceReqBo;
import com.tydic.dyc.oc.service.order.bo.UocGetQueryOutOrderServiceRspBo;
import com.tydic.dyc.oc.service.order.bo.UocQryOutOrderIndexBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Slf4j
@HTServiceImpl
public class UocGetQueryOutOrderServiceImpl implements UocGetQueryOutOrderService{
    
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    
    @Override
    public UocGetQueryOutOrderServiceRspBo qryOrderQueryIndexList(UocGetQueryOutOrderServiceReqBo reqBo) {
        UocGetQueryOutOrderServiceRspBo rspBo = new UocGetQueryOutOrderServiceRspBo();
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        //先校验整单是否可以取消
        List<UocOrderTaskInst> allTasKIns = this.getAllTastIns(reqBo.getOrderId());
        List<String> procStateList = allTasKIns.stream().map(UocOrderTaskInst::getProcState).collect(Collectors.toList());
        if(procStateList.contains("E0006")
                || procStateList.contains("A0009")) {
            rspBo.setRespCode(UocRspConstants.RSP_CODE_FAIL);
            rspBo.setRespDesc("该订单存在不能取消的销售单！");
        }

        UocOrderQueryIndexQryBo queryIndexQryBo = new UocOrderQueryIndexQryBo();
        queryIndexQryBo.setOrderId(reqBo.getOrderId());
        queryIndexQryBo.setObjType(reqBo.getObjType());
        queryIndexQryBo.setObjId(reqBo.getObjId());
        List<UocOrderQueryIndex> uocOrderQueryIndexList = iUocOrderModel.qryOrderQueryIndexList(queryIndexQryBo);
        List<UocQryOutOrderIndexBo> uocQryOutOrderIndexBoList = UocRu.jsl(uocOrderQueryIndexList, UocQryOutOrderIndexBo.class);
    
        for(UocQryOutOrderIndexBo uocOrderQueryIndex: uocQryOutOrderIndexBoList){
            List<String> supNoList = new ArrayList<>();
            UocOrderStakeholderQryBo uocOrderStakeholderQryBo = new UocOrderStakeholderQryBo();
            uocOrderStakeholderQryBo.setOrderId(uocOrderQueryIndex.getOrderId());
            List<UocOrderStakeholderQryBo> uocOrderStakeholderQryBoList = iUocOrderModel.qryStakeholderList(uocOrderStakeholderQryBo);
            supNoList =  uocOrderStakeholderQryBoList.stream().map(e->{
                return e.getSupId();
            }).collect(Collectors.toList());
            
            uocOrderQueryIndex.setSupNoList(supNoList);
        }
        rspBo.setUocOrderQueryIndexList(uocQryOutOrderIndexBoList);

        //先查询当前整单处于什么环节
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setOrderId(reqBo.getOrderId());
        uocOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
        uocOrderTaskInst.setObjId(reqBo.getOrderId());
        uocOrderTaskInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderTaskInst> uocOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
        if (!CollectionUtils.isEmpty(uocOrderTaskInsts)) {
            if (uocOrderTaskInsts.size() != 1) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_PROC_INST_TERMINATE_ERROR, "查询代办任务有多条！");
            }
            if ("W001".equals(uocOrderTaskInsts.get(0).getProcState())) {
                //查询整单详情
                UocOrderDo selectDo = new UocOrderDo();
                selectDo.setOrderId(reqBo.getOrderId());
                UocOrderDo resultDo = iUocOrderModel.qryOrderBy(selectDo);
                if (null == resultDo) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_SYSTEM_EXCEPTION, "该订单不存在！");
                }
                rspBo.setOaAuditFlag(resultDo.getExtField1());
            }
        }
        return rspBo;
    }


    private List<UocOrderTaskInst>  getAllTastIns(Long orderId) {
        UocOrderTaskInstQryBo uocOrderTaskInstQryBo = new UocOrderTaskInstQryBo();
        uocOrderTaskInstQryBo.setOrderId(orderId);
        return iUocOrderModel.qryOrderTaskInstList(uocOrderTaskInstQryBo);
    }
}
