package com.tydic.dyc.oc.service.order;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderCancelAdvanceOrderTask;
import com.tydic.dyc.oc.service.order.bo.UocCancelAdvanceOrderTaskBO;
import com.tydic.dyc.oc.service.order.bo.UocOrderCancelAdvanceOrderTaskUpdateReqBO;
import com.tydic.dyc.oc.service.order.bo.UocOrderCancelAdvanceOrderTaskUpdateRspBO;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

@HTServiceImpl
public class UocOrderCancelAdvanceOrderTaskUpdateServiceImpl implements UocOrderCancelAdvanceOrderTaskUpdateService {

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public UocOrderCancelAdvanceOrderTaskUpdateRspBO updateCancelAdvanceOrderTask(UocOrderCancelAdvanceOrderTaskUpdateReqBO reqBO) {
        //校验入参
        validateParam(reqBO);
        UocOrderCancelAdvanceOrderTaskUpdateRspBO rspBO = UocRu.success(UocOrderCancelAdvanceOrderTaskUpdateRspBO.class);
        Date now = new Date();
        if (ObjectUtil.isNotEmpty(reqBO.getCancelAdvanceOrderTaskUpdateBOList())) {
            reqBO.getCancelAdvanceOrderTaskUpdateBOList().forEach(each -> {
                each.setDealTime(now);
                iUocOrderModel.updateCancelTaskStatus(UocRu.js(each, UocOrderCancelAdvanceOrderTask.class));
            });
        }
        if (ObjectUtil.isNotNull(reqBO.getCancelAdvanceOrderTaskUpdateBO())) {
            UocCancelAdvanceOrderTaskBO bo = reqBO.getCancelAdvanceOrderTaskUpdateBO();
            bo.setDealTime(now);
            iUocOrderModel.updateCancelTaskStatus(UocRu.js(bo, UocOrderCancelAdvanceOrderTask.class));
        }
        return rspBO;
    }

    private void validateParam(UocOrderCancelAdvanceOrderTaskUpdateReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能不为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getCancelAdvanceOrderTaskUpdateBOList()) && ObjectUtil.isNull(reqBO.getCancelAdvanceOrderTaskUpdateBO())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性取消任务列表和取消任务实体不能同时为空");
        }
    }
}
