package com.tydic.dyc.oc.service.shiporder;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.*;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderMap;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.service.shiporder.bo.UocShipOrderArrivaRegistReqBo;
import com.tydic.dyc.oc.service.shiporder.bo.UocShipOrderArrivaRegistRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * 标题:UocShipOrderArrivaRegistServiceImpl
 * 说明:发货单到货登记
 * 时间:2022/2/25 10:17
 * 作者:罗有
 */

@HTServiceImpl
@Slf4j
public class UocShipOrderArrivaRegistServiceImpl implements UocShipOrderArrivaRegistService {

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    /**
     * 到货确认
     */
    private static final Integer OP_FLAG_CONFIRM = 1;
    /**
     * 全部拒单
     */
    private static final String OP_FLAG_YES = "1";
    /**
     * 不是全部拒单
     */
    private static final String OP_FLAG_NO = "0";

    @Override
    public UocShipOrderArrivaRegistRspBo dealShipOrderArrivaRegist(UocShipOrderArrivaRegistReqBo reqBo) {
        //参数校验
        validateArg(reqBo);
        UocShipOrderArrivaRegistRspBo rspBo = UocRu.success(UocShipOrderArrivaRegistRspBo.class);
        Date now = new Date();
        //更新发货单状态
        UocShipOrderDo shipOrderDo = convertShipOrderDo(reqBo, now);
        iUocShipOrderModel.modifyShipOrderMain(shipOrderDo);
        dealMap(reqBo, now);
        //更新销售单状态
        List<UocSaleOrderItem> listSaleOrderItem = getListSaleOrderItem(reqBo);
        List<UocShipOrderItem> allListShipOrderItem = getAllListShipOrderItem(reqBo);
        List<UocShipOrderItem> uocShipOrderItemList = getListShipOrderItem(reqBo);
        if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
            shipOrderDo.setShipOrderState(UocStateConstants.ShipOrder.FH_FH_YSH);
            shipOrderDo.setReceiverTime(now);
            shipOrderDo.setOrderAccessoryBoList(new ArrayList());
            iUocShipOrderModel.arrivaConfirm(shipOrderDo);
        }
        boolean allRefuseFlag = modifySaleOrderState(reqBo, now, listSaleOrderItem, allListShipOrderItem, uocShipOrderItemList);
        rspBo.setAllRefuseFlag(allRefuseFlag);
        rspBo.setOpFlag(allRefuseFlag ? OP_FLAG_YES : OP_FLAG_NO);
        // 5 提交任务
        UocCommonDo uocCommonDo = new UocCommonDo();
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        taskBo.setTaskId(reqBo.getTaskId());
        taskBos.add(taskBo);
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(reqBo.getUserId());
        uocCommonDo.setOrderId(reqBo.getOrderId());
        iUocCommonModel.dealTask(uocCommonDo);
        //如果拒收后流程会走到退款或者退授信件，暂时没有实现，手动把"A0009"完结
        //实现后可注释
        if (allRefuseFlag) finish(reqBo);
        return rspBo;
    }


    private void finish(UocShipOrderArrivaRegistReqBo reqBo) {
        //只针对协议生效，只有协议有A0009
        //查询"A0009"环节
        UocOrderTaskInst qry = new UocOrderTaskInst();
        qry.setOrderId(reqBo.getOrderId());
        qry.setObjId(reqBo.getSaleOrderId());
        qry.setProcState("A0009");
        List<UocOrderTaskInst> uocOrderTaskInsts = iUocCommonModel.qryTaskInst(qry);

        if (!CollectionUtils.isEmpty(uocOrderTaskInsts)) {
            UocCommonDo uocCommonDo = new UocCommonDo();
            List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(uocOrderTaskInsts.get(0).getTaskInstId());
            taskBos.add(taskBo);
            uocCommonDo.setCompleteTaskInfos(taskBos);
            uocCommonDo.setUserId(reqBo.getUserId());
            uocCommonDo.setOrderId(reqBo.getOrderId());
            iUocCommonModel.dealTask(uocCommonDo);
        }
    }

    private UocShipOrderDo convertShipOrderDo(UocShipOrderArrivaRegistReqBo reqBo, Date now) {
        UocShipOrderDo uocShipOrderDo = UocRu.js(reqBo, UocShipOrderDo.class);
        uocShipOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        uocShipOrderDo.setUpdateTime(now);
        uocShipOrderDo.setArriveTime(now);
        uocShipOrderDo.setUpdateOperId(reqBo.getUserId().toString());
//        uocShipOrderDo.setShipOrderState(UocStateConstants.ShipOrder.FH_FH_DQR);
        setAccessory(reqBo, now, uocShipOrderDo);
        return uocShipOrderDo;
    }

    private List<UocSaleOrderItem> getListSaleOrderItem(UocShipOrderArrivaRegistReqBo reqBo) {
        UocSaleOrderItemQryBo qryBo = new UocSaleOrderItemQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qryListSaleOrderItem(qryBo);
        if (CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems()))
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_CONFIRM_REFUSE_ERROR, "获取销售单明细为空");
        return uocSaleOrderDo.getSaleOrderItems();
    }

    private List<UocShipOrderItem> getAllListShipOrderItem(UocShipOrderArrivaRegistReqBo reqBo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocShipOrderDo shipOrderDo = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        if (CollectionUtils.isEmpty(shipOrderDo.getShipOrderItemBoList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_CONFIRM_REFUSE_ERROR, "获取发货明细为空");
        }
        return shipOrderDo.getShipOrderItemBoList();
    }

    private List<UocShipOrderItem> getListShipOrderItem(UocShipOrderArrivaRegistReqBo reqBo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderIdList(reqBo.getShipOrderIdList());
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocShipOrderDo shipOrderDo = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        if (CollectionUtils.isEmpty(shipOrderDo.getShipOrderItemBoList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_CONFIRM_REFUSE_ERROR, "获取发货明细为空");
        }
        return shipOrderDo.getShipOrderItemBoList();
    }

    /**
     * 组装附件参数
     */
    private void setAccessory(UocShipOrderArrivaRegistReqBo reqBo, Date now, UocShipOrderDo uocShipOrderDo) {
        if (!CollectionUtils.isEmpty(reqBo.getOrderAccessoryList())) {
            List<UocOrderAccessory> orderAccessoryBoList = new ArrayList<>();
            reqBo.getOrderAccessoryList().forEach(orderAccessoryAddBo -> {
                UocOrderAccessory uocOrderAccessory = UocRu.js(orderAccessoryAddBo, UocOrderAccessory.class);
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
                uocOrderAccessory.setCreateTime(now);
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.ARRIVAL_REGIST);
                reqBo.getShipOrderIdList().forEach(shipOrderId -> {
                    uocOrderAccessory.setObjId(shipOrderId);
                    orderAccessoryBoList.add(uocOrderAccessory);
                });
            });
            uocShipOrderDo.setOrderAccessoryBoList(orderAccessoryBoList);
        }
    }

    /**
     * 扩展属性处理
     */
    private void dealMap(UocShipOrderArrivaRegistReqBo reqBo, Date now) {
        if (!CollectionUtils.isEmpty(reqBo.getExtDeleteList())) {
            UocShipOrderDo delShipOrderDo = new UocShipOrderDo();
            List<UocShipOrderMap> extParallelBoList = new ArrayList<>();
            reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                UocShipOrderMap uocShipOrderMap = new UocShipOrderMap();
                uocShipOrderMap.setOrderId(reqBo.getOrderId());
//                uocShipOrderMap.setImplOrderId(reqBo.getImplOrderId());
                uocShipOrderMap.setSaleOrderId(reqBo.getSaleOrderId());
                uocShipOrderMap.setShipOrderId(uocBaseExtParallelDeleteBo.getObjId());
                uocShipOrderMap.setFieldCode(uocBaseExtParallelDeleteBo.getFieldCode());
                uocShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                uocShipOrderMap.setUpdateTime(now);
                extParallelBoList.add(uocShipOrderMap);
            });
            delShipOrderDo.setExtParallelBoList(extParallelBoList);
            iUocShipOrderModel.updateInvalid(delShipOrderDo);
        }
        if (!CollectionUtils.isEmpty(reqBo.getExtEditList())) {
            UocShipOrderDo add = new UocShipOrderDo();
            UocShipOrderDo modify = new UocShipOrderDo();
            List<UocShipOrderMap> addList = new ArrayList<>();
            List<UocShipOrderMap> modifyList = new ArrayList<>();
            reqBo.getExtEditList().forEach(uocBaseExtParallelEditBo -> {
                if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelEditBo.getOpFlag())) {
                    UocShipOrderMap addShipOrderMap = new UocShipOrderMap();
                    addShipOrderMap.setShipOrderId(uocBaseExtParallelEditBo.getObjId());
                    addShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                    addShipOrderMap.setFieldName(uocBaseExtParallelEditBo.getFieldName());
                    addShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                    addShipOrderMap.setOrderId(reqBo.getOrderId());
//                    addShipOrderMap.setImplOrderId(reqBo.getImplOrderId());
                    addShipOrderMap.setSaleOrderId(reqBo.getSaleOrderId());
                    addShipOrderMap.setId(IdUtil.nextId());
                    addShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
                    addShipOrderMap.setCreateTime(now);
                    addList.add(addShipOrderMap);
                } else {
                    UocShipOrderMap updateShipOrderMap = new UocShipOrderMap();
                    updateShipOrderMap.setShipOrderId(uocBaseExtParallelEditBo.getObjId());
                    updateShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                    updateShipOrderMap.setOrderId(reqBo.getOrderId());
                    updateShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                    updateShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                    updateShipOrderMap.setUpdateTime(now);
                    modifyList.add(updateShipOrderMap);
                }
            });
            if (!CollectionUtils.isEmpty(addList)) {
                add.setExtParallelBoList(addList);
                iUocShipOrderModel.addShipOrderMap(add);
            }
            if (!CollectionUtils.isEmpty(modifyList)) {
                modify.setExtParallelBoList(modifyList);
                iUocShipOrderModel.updateBatchValue(modify);
            }
        }
    }

    private boolean modifySaleOrderState(UocShipOrderArrivaRegistReqBo reqBo, Date now, List<UocSaleOrderItem> listSaleOrderItem,
                                         List<UocShipOrderItem> allListShipOrderItem, List<UocShipOrderItem> uocShipOrderItemList) {
        boolean refuseAll = false;
        String state = null;

        // 在到货确认/拒收节点会有 采购数量 发货数量 到货数量 拒收数量，不会有 退货数量 售后数量
        // XS_DH_DH   已到货(全部到货) 采购数量 = 到货数量
        // XS_DH_JS   已拒收(全部拒收) 采购数量 = 拒收数量
        // XS_DH_BFDH 部分到货 采购数量 > (到货数量 + 拒收数量) &&  到货数量 > 0 && 拒收数量 > 0

        //1.根据orderId查询出sale_order_item 得到采购的总数量
        BigDecimal purchaseCount = new BigDecimal(0);
        for (UocSaleOrderItem uocSaleOrderItem : listSaleOrderItem)
            purchaseCount = purchaseCount.add(uocSaleOrderItem.getPurchaseCount() == null ? new BigDecimal(0) : uocSaleOrderItem.getPurchaseCount());
        //2.根据orderId查询出所有的ship_item 计算出该orderId对应的已到货数量，已拒收数量
        BigDecimal arrivedCount = new BigDecimal(0);
        BigDecimal refusedCount = new BigDecimal(0);
        for (UocShipOrderItem uocShipOrderItem : allListShipOrderItem) {
            arrivedCount = arrivedCount.add(uocShipOrderItem.getArriveCount() == null ? new BigDecimal(0) : uocShipOrderItem.getArriveCount());
            refusedCount = refusedCount.add(uocShipOrderItem.getRefuseCount() == null ? new BigDecimal(0) : uocShipOrderItem.getRefuseCount());
        }
        log.info("该订单：" + reqBo.getOrderId() + " 已经到货数量为：" + arrivedCount + ";已经拒收数量为：" + refusedCount);
        //3.此次拒收或者到货确认的总数量
        BigDecimal mutiplyCount = new BigDecimal(0);
        for (UocShipOrderItem uocShipOrderItem : uocShipOrderItemList)
            mutiplyCount = mutiplyCount.add(uocShipOrderItem.getSendCount() == null ? new BigDecimal(0) : uocShipOrderItem.getSendCount());
        //4.计算状态
        if (Objects.equals(reqBo.getOpFlag(), OP_FLAG_CONFIRM)) arrivedCount = arrivedCount.add(mutiplyCount);
        else refusedCount = refusedCount.add(mutiplyCount);

        log.info("该订单：" + reqBo.getOrderId() + " 总的采购数量为：" + purchaseCount + ";到货数量为：" + arrivedCount + ";拒收数量为：" + refusedCount + ";本次操作数量：" + mutiplyCount);

        if (purchaseCount.compareTo(arrivedCount) == 0) state = "XS_DH_DH";
        else if (purchaseCount.compareTo(refusedCount) == 0) state = "XS_DH_JS";
        else if (purchaseCount.compareTo(arrivedCount.add(refusedCount)) == 0) state = "XS_DH_BFDH";
        else log.info("当前处于发货中");

        if (!StringUtils.isBlank(state)) {
            log.info("当前发货单状态:" + state);
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setSaleOrderState(state);
            uocSaleOrderDo.setOrderId(reqBo.getOrderId());
            uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
            uocSaleOrderDo.setUpdateTime(now);
            uocSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
            iUocSaleOrderModel.updateSaleStatusAndProCode(uocSaleOrderDo);
        }
        //返回当前订单是否全部拒收
        return state == null ? refuseAll : state.equals("XS_DH_JS");
    }

    private void validateArg(UocShipOrderArrivaRegistReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID不能为空");
        }
        if (CollectionUtils.isEmpty(reqBo.getShipOrderIdList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参发货单ID数组不能为空");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参用户ID为空");
        }
        if (!CollectionUtils.isEmpty(reqBo.getExtDeleteList())) {
            reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性对象ID不能为空");
                }
                if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性编码不能为空");
                }
            });
        }
        if (!CollectionUtils.isEmpty(reqBo.getExtEditList())) {
            reqBo.getExtEditList().forEach(uocBaseExtParallelDeleteBo -> {
                if (null == uocBaseExtParallelDeleteBo.getOpFlag()) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型不能为空");
                }
                if (!UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag()) && !UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型仅支持新增和修改");
                }
                if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，对象ID不能为空");
                    }
                    if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，属性编码不能为空");
                    }
                }
                if (UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，对象ID不能为空");
                    }
                    if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性编码不能为空");
                    }
                    if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldValue())) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性值不能为空");
                    }
                }
            });
        }
    }
}
