/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocDMsgPoolQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocMsgSplitOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocChildSaleOrderBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrdByOrdSplitBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspSaleOrderBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetJDSplitOrderBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgSplitOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocMsgSplitOrderRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrderSkuBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocMoneyUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocMsgSplitOrderService"})
public class UocMsgSplitOrderServiceImpl
implements UocMsgSplitOrderService {
    private static final Logger log = LoggerFactory.getLogger(UocMsgSplitOrderServiceImpl.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    @PostMapping(value={"splitOrder"})
    public UocMsgSplitOrderRspBo splitOrder(@RequestBody UocMsgSplitOrderReqBo reqBo) {
        UocMsgSplitOrderRspBo rspBo = UocRu.success(UocMsgSplitOrderRspBo.class);
        UocSaleOrderDo uocSaleOrderDo = this.qrySale(reqBo);
        if (ObjectUtil.isEmpty((Object)uocSaleOrderDo)) {
            throw new BaseBusinessException("101002", "\u8ba2\u5355\u62c6\u5355\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u672a\u67e5\u8be2\u5230\u9500\u552e\u8ba2\u5355\u4fe1\u606f!");
        }
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        taskInstQryBo.setObjId(uocSaleOrderDo.getSaleOrderId());
        taskInstQryBo.setFinishTag(UocDicConstant.FINISH_FLAG.UN_FINISHED);
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        List<UocOrderTaskInst> taskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        if (ObjectUtil.isNotEmpty(taskInsts)) {
            rspBo.setTaskInstId(taskInsts.get(0).getTaskInstId());
            rspBo.setStepId(taskInsts.get(0).getProcState());
        }
        int count = 0;
        UocGetJDSplitOrderBO uocGetJDSplitOrderBO = reqBo.getUocGetJDSplitOrderBO();
        if (ObjectUtil.isEmpty((Object)uocGetJDSplitOrderBO)) {
            throw new BaseBusinessException("101002", "\u8ba2\u5355\u62c6\u5355\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u6ca1\u6709\u62c6\u5355\u6d88\u606f!");
        }
        List childSaleOrderBOList = uocGetJDSplitOrderBO.getCOrder();
        for (UocChildSaleOrderBO uocChildSaleOrderBO : childSaleOrderBOList) {
            if (uocChildSaleOrderBO.getJdOrderState() >= 7) continue;
            throw new BaseBusinessException("101002", "\u8ba2\u5355\u62c6\u5355\u901a\u77e5\u4e1a\u52a1\u5931\u8d25\uff1a\u6709\u5b50\u8ba2\u5355\u6ca1\u6709\u5b8c\u6210\u62c6\u5355\uff0c\u4e0d\u4e88\u8fdb\u884c\u64cd\u4f5c!");
        }
        ArrayList<UocCreateOrderServiceRspSaleOrderBo> saleOrderList = new ArrayList<UocCreateOrderServiceRspSaleOrderBo>();
        for (UocChildSaleOrderBO childSaleOrderRspBO : childSaleOrderBOList) {
            UocCreateOrderServiceRspSaleOrderBo serviceRspSaleOrderBo = new UocCreateOrderServiceRspSaleOrderBo();
            UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO = new UocCreateOrdByOrdSplitBO();
            uocCreateOrdByOrdSplitBO.setUocChildSaleOrderBO(childSaleOrderRspBO);
            uocCreateOrdByOrdSplitBO.setOrderId(uocSaleOrderDo.getOrderId());
            uocCreateOrdByOrdSplitBO.setSaleId(uocSaleOrderDo.getSaleOrderId());
            uocCreateOrdByOrdSplitBO.setCount(Integer.valueOf(count));
            Long newSaleOrderId = this.splitCoreOrder(uocCreateOrdByOrdSplitBO);
            serviceRspSaleOrderBo.setSaleOrderId(newSaleOrderId);
            saleOrderList.add(serviceRspSaleOrderBo);
            ++count;
        }
        rspBo.setOrderId(uocSaleOrderDo.getOrderId());
        rspBo.setSaleOrderList(saleOrderList);
        UocCommonDo uocCommonDo = new UocCommonDo();
        ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        taskBo.setTaskId(rspBo.getTaskInstId());
        taskBos.add(taskBo);
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(11111L);
        uocCommonDo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        log.info("\u62c6\u5355\u6d41\u8f6c\u539f\u8ba2\u5355\u7684\u4efb\u52a1,{}", (Object)JSON.toJSONString((Object)uocCommonDo));
        this.iUocCommonModel.dealTask(uocCommonDo);
        UocDMsgPoolQryBo qryBo = new UocDMsgPoolQryBo();
        qryBo.setId(reqBo.getDycUocQryMsgBO().getId());
        qryBo.setRunResult(1);
        this.iUocOrderModel.updateMsgPoolById(qryBo);
        return rspBo;
    }

    public UocSaleOrderDo qrySale(UocMsgSplitOrderReqBo reqBo) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(reqBo.getDycUocQryMsgBO().getObjId());
        return this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    public Long splitCoreOrder(UocCreateOrdByOrdSplitBO uocCreateOrdByOrdSplitBO) {
        UocChildSaleOrderBO childSaleOrderRspBO = uocCreateOrdByOrdSplitBO.getUocChildSaleOrderBO();
        Long totalFee = 0L;
        Long freight = null;
        Long newSaleOrderId = IdUtil.nextId();
        try {
            totalFee = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getOrderPrice());
            freight = UocMoneyUtil.bigDecimal2Long(childSaleOrderRspBO.getFreight());
            if (freight == null) {
                freight = 0L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u901a\u8fc7\u62c6\u5355\u521b\u5efa\u5b50\u8ba2\u5355\u65f6\u5f02\u5e38\uff1a\u8f6c\u6362\u8ba2\u5355\u8d39\u7528\u9519\u8bef!");
        }
        UocSaleOrderQryBo uocSaleOrderBo = new UocSaleOrderQryBo();
        uocSaleOrderBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
        uocSaleOrderBo.setSaleOrderId(uocCreateOrdByOrdSplitBO.getSaleId());
        UocSaleOrderDo saleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderBo);
        saleOrderDo.setSaleOrderId(newSaleOrderId);
        saleOrderDo.setUpperOrderId(uocCreateOrdByOrdSplitBO.getSaleId());
        saleOrderDo.setSaleOrderNoExt(String.valueOf(childSaleOrderRspBO.getJdOrderId()));
        try {
            saleOrderDo.setTotalSaleFee(MoneyUtils.Long2BigDecimal((Long)totalFee));
            saleOrderDo.setTotalPurchaseFee(MoneyUtils.Long2BigDecimal((Long)totalFee));
            saleOrderDo.setTotalTransFee(MoneyUtils.Long2BigDecimal((Long)freight));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u901a\u8fc7\u62c6\u5355\u521b\u5efa\u5b50\u8ba2\u5355\u65f6\u5f02\u5e38\uff1a\u8f6c\u6362\u8ba2\u5355\u8d39\u7528\u9519\u8bef!");
        }
        List exSkuList = childSaleOrderRspBO.getSku();
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(uocCreateOrdByOrdSplitBO.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(uocCreateOrdByOrdSplitBO.getSaleId());
        List<UocSaleOrderItem> saleItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        ArrayList<UocSaleOrderItem> newSaleItemList = new ArrayList<UocSaleOrderItem>();
        for (UocSaleOrderItem saleOrderItem : saleItemList) {
            Long newSaleOrderItemId = IdUtil.nextId();
            for (UocOrderSkuBO extSkuBo : exSkuList) {
                if (!saleOrderItem.getSkuExtSkuId().equals(extSkuBo.getSkuId())) continue;
                UocSaleOrderItem newUocSaleOrderItem = (UocSaleOrderItem)JSONObject.parseObject((String)JSON.toJSONString((Object)saleOrderItem), UocSaleOrderItem.class);
                newUocSaleOrderItem.setPurchaseCount(new BigDecimal(extSkuBo.getNum()));
                newUocSaleOrderItem.setSaleOrderId(newSaleOrderId);
                newUocSaleOrderItem.setSaleOrderItemId(newSaleOrderItemId);
                newSaleItemList.add(newUocSaleOrderItem);
            }
        }
        saleOrderDo.setSaleOrderItems(newSaleItemList);
        Integer isJdCz = 0;
        if (ObjectUtil.isNotEmpty((Object)childSaleOrderRspBO.getOrderType()) && childSaleOrderRspBO.getOrderType() == 5) {
            isJdCz = 1;
        }
        saleOrderDo.setJdCz(isJdCz);
        this.iUocSaleOrderModel.createSaleOrder(saleOrderDo);
        UocOrderQueryIndex uocOrderQueryIndex = new UocOrderQueryIndex();
        uocOrderQueryIndex.setObjId(newSaleOrderId);
        uocOrderQueryIndex.setOrderSystem(UocDicConstant.OBJ_TYPE.SALE.toString());
        uocOrderQueryIndex.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocOrderQueryIndex.setOutObjId(String.valueOf(childSaleOrderRspBO.getJdOrderId()));
        uocOrderQueryIndex.setOrderId(saleOrderDo.getOrderId());
        uocOrderQueryIndex.setId(IdUtil.nextId());
        this.iUocCommonModel.saveOrderQueryIndex(uocOrderQueryIndex);
        return newSaleOrderId;
    }
}

