/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalLog;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.service.domainservice.UocApproveCreateService;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveCreateServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveCreateServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocApproveCreateService"})
public class UocApproveCreateServiceImpl
implements UocApproveCreateService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @PostMapping(value={"createApprove"})
    public UocApproveCreateServiceRspBo createApprove(@RequestBody UocApproveCreateServiceReqBo reqBo) {
        this.validateArg(reqBo);
        UocApproveCreateServiceRspBo rspBo = UocRu.success(UocApproveCreateServiceRspBo.class);
        long auditId = IdUtil.nextId();
        UocAuditOrderDo auditDo = UocRu.js(reqBo, UocAuditOrderDo.class);
        auditDo.setAuditOrderId(auditId);
        auditDo.setCreateOperId(reqBo.getUserId().toString());
        auditDo.setCreateOperName(reqBo.getName());
        auditDo.setOrderId(reqBo.getOrderId());
        auditDo.setAuditOrderStatus("2");
        ArrayList<UocApprovalObj> objList = new ArrayList<UocApprovalObj>();
        auditDo.setApprovalObjs(objList);
        UocApprovalObj approvalObj = new UocApprovalObj();
        objList.add(approvalObj);
        approvalObj.setObjId(reqBo.getObjId().toString());
        approvalObj.setId(IdUtil.nextId());
        approvalObj.setAuditOrderId(auditDo.getAuditOrderId());
        approvalObj.setOrderId(reqBo.getOrderId());
        approvalObj.setObjType(reqBo.getObjType());
        approvalObj.setObjBusiType(reqBo.getObjBusiType());
        UocApprovalLog uocApprovalLog = new UocApprovalLog();
        uocApprovalLog.setAuditOrderId(auditId);
        uocApprovalLog.setId(IdUtil.nextId());
        uocApprovalLog.setOperid(reqBo.getUserId().toString());
        uocApprovalLog.setOperName(reqBo.getName());
        uocApprovalLog.setOperDept(reqBo.getOrgId() + "");
        uocApprovalLog.setCreateTime(new Date());
        uocApprovalLog.setObjNum(objList.size());
        uocApprovalLog.setObjType(reqBo.getObjBusiType());
        uocApprovalLog.setAuditResult(UocConstant.AUDIT_TYPE.CREATE);
        auditDo.setApprovalLog(uocApprovalLog);
        this.iUocAuditOrderModel.saveAudit(auditDo);
        rspBo.setAuditOrderId(Long.valueOf(auditId));
        return rspBo;
    }

    private void validateArg(UocApproveCreateServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocApproveCreateServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUserId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u7528\u6237id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getObjId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5bf9\u8c61id\uff0c\u4f8b\u5982\u9500\u552e\u5355id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getObjType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5bf9\u8c61\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getObjBusiType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5bf9\u8c61\u4e1a\u52a1\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

