package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.sun.org.apache.xpath.internal.operations.Bool;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocAfterServiceTypeQryServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocAfterServiceTypeQryServiceRspAfsBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocAfterServiceTypeQryServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/**
 * 标题：类名称:UocAfterServiceTypeQryServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/4/2 11:26
 * 作者 @author 尹栋梁
 */
@HTServiceImpl
@Slf4j
public class UocAfterServiceTypeQryServiceImpl implements UocAfterServiceTypeQryService{
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Override
    public UocAfterServiceTypeQryServiceRspBo qryAfterServiceType(UocAfterServiceTypeQryServiceReqBo reqBo) {
        UocAfterServiceTypeQryServiceRspBo rspBo = UocRu.success(UocAfterServiceTypeQryServiceRspBo.class);
        rspBo.setServerTypes(new ArrayList<>());

        Map<String,String> map = new HashMap<>();

        //查询到货时间
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setShipOrderId(reqBo.getShipOrderId());
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        UocShipOrderDo shipOrderById = iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
        //如果到货时间为空 就判断为今天 即是可以退货的
        log.info("改发货单："+shipOrderById);
        Date arriveTime = shipOrderById.getArriveTime()==null?new Date():shipOrderById.getArriveTime();
        //计算有没有超过七天
        //为true代表超过七天 不支持退货
        boolean returnEffectFlag = (new Date().getTime() - arriveTime.getTime()) / (24 * 60 * 60 * 1000) >= 7;

        //参数校验
        validateArg(reqBo);
        //查询销售单明细信息
        List<UocSaleOrderItem> saleOrderItems = new ArrayList<>();
        List<Long> ordItemList = reqBo.getOrdItemList();
        for (Long saleOrderItemId : ordItemList) {
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setSaleOrderItemId(saleOrderItemId);
            List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
            if (CollectionUtil.isNotEmpty(saleOrderItemList)) {
                saleOrderItems.addAll(saleOrderItemList);
            }
        }
        if (CollectionUtil.isEmpty(saleOrderItems)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询销售单明细对象属性为空");
        }
        ArrayList<Integer> afTypesList = new ArrayList<>();
        //计算售后类型
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            // 如果item过多会有内存浪费，用计数法求交际更好
            ArrayList<Integer> afTypesLists = new ArrayList<>();

            if (ObjectUtil.isNotEmpty(saleOrderItem.getRejectAllowDate())&&!shipOrderById.getShipOrderState().equals(UocStateConstants.ShipOrder.FH_FH_YS)) {
                afTypesLists.add(UocConstant.AFTERORDER_SERVTYPE.RETURN);
                //退货期限不为空，同时超时了，添加标识：return canApply->false
                if (validateTime(arriveTime,saleOrderItem.getRejectAllowDate())) {
                    map.put("return","false");
                    // 记录最大的天数
                    map.put("returnTime", String.valueOf(Math.max(Integer.parseInt(map.getOrDefault("returnTime","0")),saleOrderItem.getRejectAllowDate())));
                }
            }
            if (ObjectUtil.isNotEmpty(saleOrderItem.getExchangeAllowDate())) {
                afTypesLists.add(UocConstant.AFTERORDER_SERVTYPE.CHANGE);
                //换货期限不为空，同时超时了，添加标识：exchange canApply->false
                if (validateTime(arriveTime,saleOrderItem.getExchangeAllowDate())) map.put("exchange","false");
            }
            if (ObjectUtil.isNotEmpty(saleOrderItem.getMaintainAllowDate())) {
                afTypesLists.add(UocConstant.AFTERORDER_SERVTYPE.FIX);
                //维修期限不为空，同时超时了，添加标识：fix canApply->false
                if (validateTime(arriveTime,saleOrderItem.getMaintainAllowDate())) map.put("fix","false");
            }
            if (CollectionUtil.isNotEmpty(afTypesList)) {
                Collection<Integer> intersection = CollectionUtil.intersection(afTypesList, afTypesLists);
                // 清除之前的交集
                afTypesList.clear();
                intersection.forEach(x->{
                    afTypesList.add(x);
                });
            } else {
                afTypesList.addAll(afTypesLists);
            }
        }
        //字典查询封装数据
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocDicConstant.SERVICE_TYPE.P_CODE);
        Map<String, Map<String, String>> dicMap = iUocSysDictionaryModel.getDictionaryMap(pCodes);
        Map<String, String> serviceMaps = dicMap.get(UocDicConstant.SERVICE_TYPE.P_CODE);
        afTypesList.stream().sorted(new Comparator<Integer>() {
            @Override
            public int compare(Integer o1, Integer o2) {
                return o1-o2;
            }
        }).forEach(integer->{
            UocAfterServiceTypeQryServiceRspAfsBo uocAfterServiceTypeQryServiceRspAfsBo = new UocAfterServiceTypeQryServiceRspAfsBo();
            uocAfterServiceTypeQryServiceRspAfsBo.setServerType(integer);
            uocAfterServiceTypeQryServiceRspAfsBo.setServerName(serviceMaps.get(integer.toString()));

            //退货情况
            if (integer.equals(UocDicConstant.SERVICE_TYPE.RETURN_GOODS)) {
                uocAfterServiceTypeQryServiceRspAfsBo.setCanApply(map.getOrDefault("return","").equals("false")?Boolean.FALSE:Boolean.TRUE);
                uocAfterServiceTypeQryServiceRspAfsBo.setServerDesc(uocAfterServiceTypeQryServiceRspAfsBo.getCanApply()?"":"支持"+map.get("returnTime")+"天无理由退货，已超过规定的退货时间");
            }
            //换货情况
            if (integer.equals(UocDicConstant.SERVICE_TYPE.EXCHANGE_GOODS)) {
                uocAfterServiceTypeQryServiceRspAfsBo.setCanApply(map.getOrDefault("exchange","").equals("false")?Boolean.FALSE:Boolean.TRUE);
                uocAfterServiceTypeQryServiceRspAfsBo.setServerDesc(uocAfterServiceTypeQryServiceRspAfsBo.getCanApply()?"":"已超过换货/维修时限");
            }
            //维修情况
            if (integer.equals(UocDicConstant.SERVICE_TYPE.REPAIR)) {
                uocAfterServiceTypeQryServiceRspAfsBo.setCanApply(map.getOrDefault("fix","").equals("false")?Boolean.FALSE:Boolean.TRUE);
                uocAfterServiceTypeQryServiceRspAfsBo.setServerDesc(uocAfterServiceTypeQryServiceRspAfsBo.getCanApply()?"":"已超过换货/维修时限");
            }

            rspBo.getServerTypes().add(uocAfterServiceTypeQryServiceRspAfsBo);
        });
        return rspBo;
    }

    private void validateArg(UocAfterServiceTypeQryServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocAfterServiceTypeQryServiceReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrdItemList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单明细id列表]不能为空");
        }
    }


    /**
     * 判断 当前时间-到货时间 超过时间期限 ; 超过就是true来标识
     */
    private Boolean validateTime(Date arriveTime,Integer timeLimit){
        if ((new Date().getTime() - arriveTime.getTime()) / (24 * 60 * 60 * 1000) >= timeLimit) return true;
        // 默认返回false，标识没有超过
        return false;
    }
}
