/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.shiporder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderMap;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.service.shiporder.UocShipOrderArrivaRegistService;
import com.tydic.dyc.oc.service.shiporder.bo.UocShipOrderArrivaRegistReqBo;
import com.tydic.dyc.oc.service.shiporder.bo.UocShipOrderArrivaRegistRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.shiporder.UocShipOrderArrivaRegistService"})
public class UocShipOrderArrivaRegistServiceImpl
implements UocShipOrderArrivaRegistService {
    private static final Logger log = LoggerFactory.getLogger(UocShipOrderArrivaRegistServiceImpl.class);
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    private static final Integer OP_FLAG_CONFIRM = 1;
    private static final String OP_FLAG_YES = "1";
    private static final String OP_FLAG_NO = "0";

    @PostMapping(value={"dealShipOrderArrivaRegist"})
    public UocShipOrderArrivaRegistRspBo dealShipOrderArrivaRegist(@RequestBody UocShipOrderArrivaRegistReqBo reqBo) {
        this.validateArg(reqBo);
        UocShipOrderArrivaRegistRspBo rspBo = UocRu.success(UocShipOrderArrivaRegistRspBo.class);
        Date now = new Date();
        UocShipOrderDo shipOrderDo = this.convertShipOrderDo(reqBo, now);
        this.iUocShipOrderModel.modifyShipOrderMain(shipOrderDo);
        this.dealMap(reqBo, now);
        List<UocSaleOrderItem> listSaleOrderItem = this.getListSaleOrderItem(reqBo);
        List<UocShipOrderItem> allListShipOrderItem = this.getAllListShipOrderItem(reqBo);
        List<UocShipOrderItem> uocShipOrderItemList = this.getListShipOrderItem(reqBo);
        if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
            shipOrderDo.setShipOrderState("FH_FH_YDH");
            shipOrderDo.setReceiverTime(now);
            shipOrderDo.setOrderAccessoryBoList(new ArrayList<UocOrderAccessory>());
            this.iUocShipOrderModel.arrivaConfirm(shipOrderDo);
        }
        boolean allRefuseFlag = this.modifySaleOrderState(reqBo, now, listSaleOrderItem, allListShipOrderItem, uocShipOrderItemList);
        rspBo.setAllRefuseFlag(Boolean.valueOf(allRefuseFlag));
        rspBo.setOpFlag(allRefuseFlag ? OP_FLAG_YES : OP_FLAG_NO);
        if (ObjectUtil.isNotEmpty((Object)reqBo.getShipOrderTaskBos())) {
            UocCommonDo uocCommonDo = new UocCommonDo();
            uocCommonDo.setCompleteTaskInfos(reqBo.getShipOrderTaskBos().stream().map(o -> {
                UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
                taskBo.setTaskId(o.getTaskId());
                taskBo.setStepId(o.getStepId());
                return taskBo;
            }).collect(Collectors.toList()));
            uocCommonDo.setUserId(reqBo.getUserId());
            uocCommonDo.setOrderId(reqBo.getOrderId());
            this.iUocCommonModel.dealTask(uocCommonDo);
        }
        if (allRefuseFlag) {
            this.finish(reqBo);
        }
        return rspBo;
    }

    private void finish(UocShipOrderArrivaRegistReqBo reqBo) {
        UocOrderTaskInst qry = new UocOrderTaskInst();
        qry.setOrderId(reqBo.getOrderId());
        qry.setObjId(reqBo.getSaleOrderId());
        qry.setProcState("A0009");
        List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocCommonModel.qryTaskInst(qry);
        if (!CollectionUtils.isEmpty(uocOrderTaskInsts)) {
            UocCommonDo uocCommonDo = new UocCommonDo();
            ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(uocOrderTaskInsts.get(0).getTaskInstId());
            taskBos.add(taskBo);
            uocCommonDo.setCompleteTaskInfos(taskBos);
            uocCommonDo.setUserId(reqBo.getUserId());
            uocCommonDo.setOrderId(reqBo.getOrderId());
            this.iUocCommonModel.dealTask(uocCommonDo);
        }
    }

    private UocShipOrderDo convertShipOrderDo(UocShipOrderArrivaRegistReqBo reqBo, Date now) {
        UocShipOrderDo uocShipOrderDo = UocRu.js(reqBo, UocShipOrderDo.class);
        uocShipOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        uocShipOrderDo.setUpdateTime(now);
        uocShipOrderDo.setArriveTime(now);
        uocShipOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        this.setAccessory(reqBo, now, uocShipOrderDo);
        return uocShipOrderDo;
    }

    private List<UocSaleOrderItem> getListSaleOrderItem(UocShipOrderArrivaRegistReqBo reqBo) {
        UocSaleOrderItemQryBo qryBo = new UocSaleOrderItemQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qryListSaleOrderItem(qryBo);
        if (CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException("101003", "\u83b7\u53d6\u9500\u552e\u5355\u660e\u7ec6\u4e3a\u7a7a");
        }
        return uocSaleOrderDo.getSaleOrderItems();
    }

    private List<UocShipOrderItem> getAllListShipOrderItem(UocShipOrderArrivaRegistReqBo reqBo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocShipOrderDo shipOrderDo = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        if (CollectionUtils.isEmpty(shipOrderDo.getShipOrderItemBoList())) {
            throw new BaseBusinessException("101003", "\u83b7\u53d6\u53d1\u8d27\u660e\u7ec6\u4e3a\u7a7a");
        }
        return shipOrderDo.getShipOrderItemBoList();
    }

    private List<UocShipOrderItem> getListShipOrderItem(UocShipOrderArrivaRegistReqBo reqBo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderIdList(reqBo.getShipOrderIdList());
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocShipOrderDo shipOrderDo = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        if (CollectionUtils.isEmpty(shipOrderDo.getShipOrderItemBoList())) {
            throw new BaseBusinessException("101003", "\u83b7\u53d6\u53d1\u8d27\u660e\u7ec6\u4e3a\u7a7a");
        }
        return shipOrderDo.getShipOrderItemBoList();
    }

    private void setAccessory(UocShipOrderArrivaRegistReqBo reqBo, Date now, UocShipOrderDo uocShipOrderDo) {
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrderAccessoryList())) {
            ArrayList<UocOrderAccessory> orderAccessoryBoList = new ArrayList<UocOrderAccessory>();
            reqBo.getOrderAccessoryList().forEach(orderAccessoryAddBo -> {
                UocOrderAccessory uocOrderAccessory = UocRu.js(orderAccessoryAddBo, UocOrderAccessory.class);
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
                uocOrderAccessory.setCreateTime(now);
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setAttachmentType(UocAttachementTypeConstants.ARRIVAL_REGIST);
                reqBo.getShipOrderIdList().forEach(shipOrderId -> {
                    uocOrderAccessory.setObjId((Long)shipOrderId);
                    orderAccessoryBoList.add(uocOrderAccessory);
                });
            });
            uocShipOrderDo.setOrderAccessoryBoList(orderAccessoryBoList);
        }
    }

    private void dealMap(UocShipOrderArrivaRegistReqBo reqBo, Date now) {
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtDeleteList())) {
            UocShipOrderDo delShipOrderDo = new UocShipOrderDo();
            ArrayList<UocShipOrderMap> extParallelBoList = new ArrayList<UocShipOrderMap>();
            reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                UocShipOrderMap uocShipOrderMap = new UocShipOrderMap();
                uocShipOrderMap.setOrderId(reqBo.getOrderId());
                uocShipOrderMap.setSaleOrderId(reqBo.getSaleOrderId());
                uocShipOrderMap.setShipOrderId(uocBaseExtParallelDeleteBo.getObjId());
                uocShipOrderMap.setFieldCode(uocBaseExtParallelDeleteBo.getFieldCode());
                uocShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                uocShipOrderMap.setUpdateTime(now);
                extParallelBoList.add(uocShipOrderMap);
            });
            delShipOrderDo.setExtParallelBoList(extParallelBoList);
            this.iUocShipOrderModel.updateInvalid(delShipOrderDo);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtEditList())) {
            UocShipOrderDo add = new UocShipOrderDo();
            UocShipOrderDo modify = new UocShipOrderDo();
            ArrayList<UocShipOrderMap> addList = new ArrayList<UocShipOrderMap>();
            ArrayList<UocShipOrderMap> modifyList = new ArrayList<UocShipOrderMap>();
            reqBo.getExtEditList().forEach(uocBaseExtParallelEditBo -> {
                if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelEditBo.getOpFlag())) {
                    UocShipOrderMap addShipOrderMap = new UocShipOrderMap();
                    addShipOrderMap.setShipOrderId(uocBaseExtParallelEditBo.getObjId());
                    addShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                    addShipOrderMap.setFieldName(uocBaseExtParallelEditBo.getFieldName());
                    addShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                    addShipOrderMap.setOrderId(reqBo.getOrderId());
                    addShipOrderMap.setSaleOrderId(reqBo.getSaleOrderId());
                    addShipOrderMap.setId(IdUtil.nextId());
                    addShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
                    addShipOrderMap.setCreateTime(now);
                    addList.add(addShipOrderMap);
                } else {
                    UocShipOrderMap updateShipOrderMap = new UocShipOrderMap();
                    updateShipOrderMap.setShipOrderId(uocBaseExtParallelEditBo.getObjId());
                    updateShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                    updateShipOrderMap.setOrderId(reqBo.getOrderId());
                    updateShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                    updateShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                    updateShipOrderMap.setUpdateTime(now);
                    modifyList.add(updateShipOrderMap);
                }
            });
            if (!CollectionUtils.isEmpty(addList)) {
                add.setExtParallelBoList(addList);
                this.iUocShipOrderModel.addShipOrderMap(add);
            }
            if (!CollectionUtils.isEmpty(modifyList)) {
                modify.setExtParallelBoList(modifyList);
                this.iUocShipOrderModel.updateBatchValue(modify);
            }
        }
    }

    private boolean modifySaleOrderState(UocShipOrderArrivaRegistReqBo reqBo, Date now, List<UocSaleOrderItem> listSaleOrderItem, List<UocShipOrderItem> allListShipOrderItem, List<UocShipOrderItem> uocShipOrderItemList) {
        boolean refuseAll = false;
        String state = null;
        BigDecimal purchaseCount = new BigDecimal(0);
        for (UocSaleOrderItem uocSaleOrderItem : listSaleOrderItem) {
            purchaseCount = purchaseCount.add(uocSaleOrderItem.getPurchaseCount() == null ? new BigDecimal(0) : uocSaleOrderItem.getPurchaseCount());
        }
        BigDecimal arrivedCount = new BigDecimal(0);
        BigDecimal refusedCount = new BigDecimal(0);
        for (UocShipOrderItem uocShipOrderItem : allListShipOrderItem) {
            arrivedCount = arrivedCount.add(uocShipOrderItem.getArriveCount() == null ? new BigDecimal(0) : uocShipOrderItem.getArriveCount());
            refusedCount = refusedCount.add(uocShipOrderItem.getRefuseCount() == null ? new BigDecimal(0) : uocShipOrderItem.getRefuseCount());
        }
        log.info("\u8be5\u8ba2\u5355\uff1a" + reqBo.getOrderId() + " \u5df2\u7ecf\u5230\u8d27\u6570\u91cf\u4e3a\uff1a" + arrivedCount + ";\u5df2\u7ecf\u62d2\u6536\u6570\u91cf\u4e3a\uff1a" + refusedCount);
        BigDecimal mutiplyCount = new BigDecimal(0);
        for (UocShipOrderItem uocShipOrderItem : uocShipOrderItemList) {
            mutiplyCount = mutiplyCount.add(uocShipOrderItem.getSendCount() == null ? new BigDecimal(0) : uocShipOrderItem.getSendCount());
        }
        if (Objects.equals(reqBo.getOpFlag(), OP_FLAG_CONFIRM)) {
            arrivedCount = arrivedCount.add(mutiplyCount);
        } else {
            refusedCount = refusedCount.add(mutiplyCount);
        }
        log.info("\u8be5\u8ba2\u5355\uff1a" + reqBo.getOrderId() + " \u603b\u7684\u91c7\u8d2d\u6570\u91cf\u4e3a\uff1a" + purchaseCount + ";\u5230\u8d27\u6570\u91cf\u4e3a\uff1a" + arrivedCount + ";\u62d2\u6536\u6570\u91cf\u4e3a\uff1a" + refusedCount + ";\u672c\u6b21\u64cd\u4f5c\u6570\u91cf\uff1a" + mutiplyCount);
        if (purchaseCount.compareTo(arrivedCount) == 0) {
            state = "XS_DH_DH";
        } else if (purchaseCount.compareTo(refusedCount) == 0) {
            state = "XS_DH_JS";
        } else if (purchaseCount.compareTo(arrivedCount.add(refusedCount)) == 0) {
            state = "XS_DH_BFDH";
        } else {
            log.info("\u5f53\u524d\u5904\u4e8e\u53d1\u8d27\u4e2d");
        }
        if (!StringUtils.isBlank((CharSequence)state)) {
            log.info("\u5f53\u524d\u53d1\u8d27\u5355\u72b6\u6001:" + state);
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setSaleOrderState(state);
            uocSaleOrderDo.setOrderId(reqBo.getOrderId());
            uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
            uocSaleOrderDo.setUpdateTime(now);
            uocSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
            this.iUocSaleOrderModel.updateSaleStatusAndProCode(uocSaleOrderDo);
        }
        return state == null ? refuseAll : state.equals("XS_DH_JS");
    }

    private void validateArg(UocShipOrderArrivaRegistReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getShipOrderIdList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u5355ID\u6570\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u7528\u6237ID\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtDeleteList())) {
            reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                    throw new BaseBusinessException("100001", "\u8981\u5220\u9664\u7684\u6269\u5c55\u5c5e\u6027\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                    throw new BaseBusinessException("100001", "\u8981\u5220\u9664\u7684\u6269\u5c55\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtEditList())) {
            reqBo.getExtEditList().forEach(uocBaseExtParallelDeleteBo -> {
                if (null == uocBaseExtParallelDeleteBo.getOpFlag()) {
                    throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u7f16\u8f91\u64cd\u4f5c\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag()) && !UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u7f16\u8f91\u64cd\u4f5c\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4ec5\u652f\u6301\u65b0\u589e\u548c\u4fee\u6539");
                }
                if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
                if (UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldValue())) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
            });
        }
    }
}

