package com.tydic.dyc.oc.model.chngorder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocObjNoConstants;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.order.sub.UocOrderStateChgLog;
import com.tydic.dyc.oc.repository.UocChngOrderRepository;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.utils.IdUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;

/**
 * 标题:UocChngOrderModelImpl
 * 说明:变更单
 * 时间:2022/3/8 18:10
 * 作者:罗有
 */

@Service
public class UocChngOrderModelImpl implements IUocChngOrderModel {
	@Autowired
	private UocChngOrderRepository uocChngOrderRepository;
	@Autowired
	private UocCommonRepository uocCommonRepository;

	@Override
	public void createChngOrder(UocChngOrderDo uocChngOrderDo) {
		valDo(uocChngOrderDo);
		uocChngOrderRepository.createChngOrder(uocChngOrderDo);
		if (!CollectionUtils.isEmpty(uocChngOrderDo.getOrderAccessoryBoList())) {
			uocCommonRepository.addBatchOrderAccessory(uocChngOrderDo.getOrderAccessoryBoList());
		}
	}

	@Override
	public void modifyBatchChngOrderState(List<UocChngOrderDo> uocChngOrderDoList) {
		if (CollectionUtils.isEmpty(uocChngOrderDoList)) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象为空");
		}
		uocChngOrderDoList.forEach(uocChngOrderDo -> {
			if (null == uocChngOrderDo) {
				throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象为空");
			}
			if (null == uocChngOrderDo.getOrderId()) {
				throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单ID为空");
			}
			if (null == uocChngOrderDo.getChngOrderId()) {
				throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参变更单ID为空");
			}
			if (null == uocChngOrderDo.getChngOrderState()) {
				throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参变更单状态为空");
			}
		});
		uocChngOrderRepository.modifyBatchChngOrderState(uocChngOrderDoList);
	}

	@Override
	public List<UocChngOrderItemObj> getListChngOrderItemObj(UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo) {
		return uocChngOrderRepository.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
	}

	@Override
	public List<UocChngOrderDo> getListChngOrder(UocChngOrderQryBo uocChngOrderQryBo) {
		return uocChngOrderRepository.getListChngOrder(uocChngOrderQryBo);
	}

	@Override
	public UocChngOrderDo getChngOrderNo(UocChngOrderQryBo uocChngOrderQryBo) {
		if (null == uocChngOrderQryBo) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象为空");
		}
		if (null == uocChngOrderQryBo.getOrderSource()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "来源不为空");
		}
		UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
		String code = "";
		if (UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL.equals(uocChngOrderQryBo.getBusiType())) {
			code = UocObjNoConstants.ORDER_CANCEL_NO + "_" + uocChngOrderQryBo.getOrderSource();
		}
		if (UocConstant.BUSI_TYPE.NUM.equals(uocChngOrderQryBo.getBusiType())) {
			code = UocObjNoConstants.ORDER_ABNORMAL_NO + "_" + uocChngOrderQryBo.getOrderSource();
		}
		if (UocConstant.BUSI_TYPE.STATE.equals(uocChngOrderQryBo.getBusiType())) {
			code = UocObjNoConstants.ORDER_ABNORMAL_NO + "_" + uocChngOrderQryBo.getOrderSource();
		}
		String orderNo = uocCommonRepository.getOrderNoSingle(code);
		uocChngOrderDo.setChngOrderNo(orderNo);
		return uocChngOrderDo;
	}

	@Override
	public void updateShipStatusAndProCode(UocChngOrderDo uocChngOrderDo) {
		UocChngOrderQryBo qryBo = new UocChngOrderQryBo();
		qryBo.setOrderId(uocChngOrderDo.getOrderId());
		qryBo.setChngOrderId(uocChngOrderDo.getChngOrderId());
		UocChngOrderDo chngOrderDo = uocChngOrderRepository.getChngOrder(qryBo);
		if (ObjectUtil.isEmpty(chngOrderDo)) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_UPDATE_STATE_ERROR, "该变更单" + uocChngOrderDo.getChngOrderId() + "不存在");
		}

		//记录变更日志
		UocOrderStateChgLog uocOrderStateChgLog = new UocOrderStateChgLog();
		uocOrderStateChgLog.setId(IdUtil.nextId());
		uocOrderStateChgLog.setObjId(uocChngOrderDo.getChngOrderId());
		uocOrderStateChgLog.setOrderId(uocChngOrderDo.getOrderId());
		uocOrderStateChgLog.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
		uocOrderStateChgLog.setOldState(chngOrderDo.getChngOrderState());
		uocOrderStateChgLog.setNewState(uocChngOrderDo.getChngOrderState());
		uocOrderStateChgLog.setChgTime(new Date());
		uocOrderStateChgLog.setOperId(uocChngOrderDo.getUpdateOperId());

		//调用通用repository，创建状态变更日志
		uocCommonRepository.createOrderStateChangeLog(uocOrderStateChgLog);
		//更新状态
		uocChngOrderRepository.updateChngStatusAndProCode(uocChngOrderDo);
	}

	@Override
	public void updateChngOrderMain(UocChngOrderDo uocChngOrderDo) {
		valDo(uocChngOrderDo);
		if (null == uocChngOrderDo.getChngOrderId()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参变更单ID为空");
		}
		uocChngOrderRepository.updateChngOrderMain(uocChngOrderDo);
	}

	@Override
	public UocChngOrderDo getChngOrder(UocChngOrderQryBo uocChngOrderQryBo) {
		return uocChngOrderRepository.getChngOrder(uocChngOrderQryBo);
	}

	@Override
	public List<UocChngOrderObj> getListChngOrderObj(UocChngOrderObjQryBo uocChngOrderObjQryBo) {
		return uocChngOrderRepository.getListChngOrderObj(uocChngOrderObjQryBo);
	}

	@Override
	public void addChngOrderMap(UocChngOrderDo uocChngOrderDo) {
		valDo(uocChngOrderDo);
		uocChngOrderRepository.addChngOrderMap(uocChngOrderDo);
	}

	@Override
	public void updateBatchValue(UocChngOrderDo uocChngOrderDo) {
		valDo(uocChngOrderDo);
		uocChngOrderRepository.updateBatchValue(uocChngOrderDo);
	}

	@Override
	public void updateInvalid(UocChngOrderDo uocChngOrderDo) {
		valDo(uocChngOrderDo);
		uocChngOrderRepository.updateInvalid(uocChngOrderDo);
	}

	private void valDo(UocChngOrderDo uocChngOrderDo) {
		if (null == uocChngOrderDo) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象为空");
		}
		if (null == uocChngOrderDo.getOrderId()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参订单ID为空");
		}
	}

	@Override
	public List<UocChngOrderObj> getListChngOrderObjWithOutItem(UocChngOrderObjQryBo uocChngOrderObjQryBo) {
		return uocChngOrderRepository.getListChngOrderObjWithOutItem(uocChngOrderObjQryBo);
	}

	@Override
	public List<UocChngOrderObj> getChngOrderObjList(UocChngOrderObjQryBo uocChngOrderObjQryBo) {
		return uocChngOrderRepository.getChngOrderObjList(uocChngOrderObjQryBo);
	}
}
