package com.tydic.dyc.oc.model.order.sub;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocOrderCancelAdvanceOrderTask
 * 说明:预订单取消任务领域对象
 * 时间:2022-07-05 17:06
 * 作者:tkl
 **/
@Data
public class UocOrderCancelAdvanceOrderTask implements Serializable {
    private static final long serialVersionUID = 7100281837640077230L;

    /**
     * id
     */
    private Long id;
    /**
     * 供应商id
     */
    private String supplierId;
    /**
     * 订单id
     */
    private Long orderId;
    /**
     * 销售单id
     */
    private Long saleOrderId;
    /**
     * 销售单编码
     */
    private String saleOrderNo;
    /**
     * 外部单号
     */
    private String outObjId;
    /**
     * 状态：
     * 1：待处理
     * 2：处理成功
     * 3：处理失败
     */
    private Integer status;
    /**
     * 状态：
     * 1：待处理
     * 2：处理成功
     * 3：处理失败
     */
    private List<Integer> statusList;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 处理时间
     */
    private Date dealTime;
    /**
     * 排序
     */
    private String orderBy;
}
