package com.tydic.dyc.oc.repository;

import com.tydic.dyc.oc.model.order.sub.UocOrderCancelAdvanceOrderTask;

import java.util.List;

/**
 * 标题:UocOrderCancelAdvanceOrderTaskRepository
 * 说明:预订单取消任务表
 * 时间:2022/7/05 17:54
 * 作者:tkl
 */

public interface UocOrderCancelAdvanceOrderTaskRepository {

    /**
     * 创建预订单取消任务单
     *
     * @param advanceOrderTask
     */
    void createCancelAdvanceOrderTask(UocOrderCancelAdvanceOrderTask advanceOrderTask);

    /**
     * 批量创建预订单取消任务单
     *
     * @param advanceOrderTaskList
     */
    void batchCreateCancelAdvanceOrderTask(List<UocOrderCancelAdvanceOrderTask> advanceOrderTaskList);

    /**
     * 修改预订单取消任务单信息
     *
     * @param advanceOrderTask
     */
    void updateCancelAdvanceOrderTask(UocOrderCancelAdvanceOrderTask advanceOrderTask);

    /**
     * 更新预订单取消任务单状态
     *
     * @param advanceOrderTask
     */
    void updateCancelTaskStatus(UocOrderCancelAdvanceOrderTask advanceOrderTask);

    /**
     * 查询预订单取消任务列表
     *
     * @param advanceOrderTask
     * @return
     */
    List<UocOrderCancelAdvanceOrderTask> getCancelAdvanceOrderTaskList(UocOrderCancelAdvanceOrderTask advanceOrderTask);

}
