package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocElasticsearchUtil;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocAuditOrder;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEsSyncReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEsSyncRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocEsSyncServiceImpl
 * 说明:es同步
 * 时间:2022/3/9 16:52
 * 作者:罗有
 */

@Slf4j
@HTServiceImpl
public class UocEsSyncServiceImpl implements UocEsSyncService {

    @Autowired
    private UocEsSyncManager uocEsSyncManager;

//    @Autowired
//    private IUocImplOrderModel iUocImplOrderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;

    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @Autowired
    private UocElasticsearchUtil uocElasticsearchUtil;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public UocEsSyncRspBo sync(UocEsSyncReqBo reqBo) {
        val(reqBo);
        if (!reqBo.getAll()) {
            UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(reqBo, UocEsSyncManagerSaveDataReqBo.class);
            uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            return UocRu.success(UocEsSyncRspBo.class);
        }
        if (uocIndexConfig.getSaleOrderIndex().equals(reqBo.getIndexName())) {
            delIdx(uocIndexConfig.getSaleOrderIndex());
            syncSale();
        }
        if (uocIndexConfig.getOrderIndex().equals(reqBo.getIndexName())) {
            delIdx(uocIndexConfig.getOrderIndex());
            syncOrder();
        }
//        if (uocIndexConfig.getImplOrderIndex().equals(reqBo.getIndexName())) {
//            delIdx(uocIndexConfig.getImplOrderIndex());
//            syncImpl();
//        }
        if (uocIndexConfig.getShipOrderIndex().equals(reqBo.getIndexName())) {
            delIdx(uocIndexConfig.getShipOrderIndex());
            syncShip();
        }
        if (uocIndexConfig.getInspOrderIndex().equals(reqBo.getIndexName())) {
            delIdx(uocIndexConfig.getInspOrderIndex());
            syncInsp();
        }
        if (uocIndexConfig.getChngOrderIndex().equals(reqBo.getIndexName())) {
            delIdx(uocIndexConfig.getChngOrderIndex());
            syncChng();
        }
        if (uocIndexConfig.getTodoIndex().equals(reqBo.getIndexName())) {
            delIdx(uocIndexConfig.getTodoIndex());
            syncTodo();
        }
        if (uocIndexConfig.getAfOrderIndex().equals(reqBo.getIndexName())) {
            delIdx(uocIndexConfig.getAfOrderIndex());
            syncAfOrder();
        }
        if (uocIndexConfig.getApprovalOrderIndex().equals(reqBo.getIndexName())) {
            delIdx(uocIndexConfig.getApprovalOrderIndex());
            syncApprovalOrder();
        }
        if (uocIndexConfig.getTransactionIndex().equals(reqBo.getIndexName())) {
            delIdx(uocIndexConfig.getTransactionIndex());
            syncTransactionOrder(reqBo);
        }
        return UocRu.success(UocEsSyncRspBo.class);
    }

    private void syncOrder() {
        List<UocOrderDo> listOrder = getListOrder();
        if (!CollectionUtils.isEmpty(listOrder)) {
            listOrder.forEach(uocOrderDo -> {
                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(uocOrderDo, UocEsSyncManagerSaveDataReqBo.class);
                uocEsSyncManagerSaveDataReqBo.setObjId(uocOrderDo.getOrderId());
                uocEsSyncManagerSaveDataReqBo.setIndexName(uocIndexConfig.getOrderIndex());
                try {
                    uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
                } catch (Exception e) {
                    log.error("syncOrder->fail->{}", JSON.toJSONString(uocOrderDo));
                }
            });
        }
    }

    private List<UocOrderDo> getListOrder() {
        UocOrderDo uocOrderDo = new UocOrderDo();
        return iUocOrderModel.qryOrderList(uocOrderDo);

    }

    private void syncApprovalOrder() {
        List<UocAuditOrder> listOrder = getListAuditOrder();
        if (!CollectionUtils.isEmpty(listOrder)) {
            listOrder.forEach(uocAuditOrder -> {
                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(uocAuditOrder, UocEsSyncManagerSaveDataReqBo.class);
                uocEsSyncManagerSaveDataReqBo.setObjId(uocAuditOrder.getAuditOrderId());
                uocEsSyncManagerSaveDataReqBo.setIndexName(uocIndexConfig.getApprovalOrderIndex());
                uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            });
        }
    }

    private void syncTransactionOrder(UocEsSyncReqBo reqBo) {
        //参数校验
        valTransaction(reqBo);
        List listOrder = new ArrayList<>();
        if (UocDicConstant.OBJ_TYPE.SALE.equals(reqBo.getObjType())) {
            listOrder = getListSaleOrder();
        } else if (UocDicConstant.OBJ_TYPE.INSPECTION.equals(reqBo.getObjType())) {
            listOrder = getListInspOrder();
        }
        if (!CollectionUtils.isEmpty(listOrder)) {
            listOrder.forEach(each -> {
                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(each, UocEsSyncManagerSaveDataReqBo.class);
                uocEsSyncManagerSaveDataReqBo.setObjId(each instanceof UocSaleOrderDo ? ((UocSaleOrderDo) each).getSaleOrderId() : ((UocInspOrderDo) each).getInspOrderId());
                uocEsSyncManagerSaveDataReqBo.setObjType(reqBo.getObjType());
                uocEsSyncManagerSaveDataReqBo.setJsonObj(reqBo.getJsonObj());
                uocEsSyncManagerSaveDataReqBo.setIndexName(uocIndexConfig.getTransactionIndex());
                uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            });
        }
    }

    private void valTransaction(UocEsSyncReqBo reqBo) {
        if (null == reqBo.getJsonObj()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参业务外参数为空");
        }
        if (null == reqBo.getObjType()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象类型为空");
        }
    }

    private List<UocAuditOrder> getListAuditOrder() {
        return iUocAuditOrderModel.qryAuditOrderList(new UocAuditOrderQryBo());
    }

    /**
     * 删除索引
     */
    private void delIdx(String idx) {
        try {
            uocElasticsearchUtil.deleteIndex(idx);
        } catch (Exception e) {
            String eCause = JSON.toJSONString(e.getCause());
            log.error(eCause);
            if (eCause.contains(UocIndexConfig.INDEX_EXCEPTION)) {
                log.info("索引不存在");
            }
        }
    }

    private void val(UocEsSyncReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if (!reqBo.getAll()) {
            if (null == reqBo.getObjId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象ID为空");
            }
            if (null == reqBo.getOrderId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID为空");
            }
            if (StringUtils.isBlank(reqBo.getIndexName())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参索引名为空");
            }
        }
    }

    private void syncSale() {
        List<UocSaleOrderDo> listOrder = getListSaleOrder();
        if (!CollectionUtils.isEmpty(listOrder)) {
            listOrder.forEach(uocSaleOrderDo -> {
                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(uocSaleOrderDo, UocEsSyncManagerSaveDataReqBo.class);
                uocEsSyncManagerSaveDataReqBo.setObjId(uocSaleOrderDo.getSaleOrderId());
                uocEsSyncManagerSaveDataReqBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
                uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            });
        }
    }

//    private void syncImpl() {
//        List<UocImplOrderDo> listOrder = getListImplOrder();
//        if (!CollectionUtils.isEmpty(listOrder)) {
//            listOrder.forEach(uocImplOrderDo -> {
//                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(uocImplOrderDo, UocEsSyncManagerSaveDataReqBo.class);
//                uocEsSyncManagerSaveDataReqBo.setIndexName(uocIndexConfig.getImplOrderIndex());
//                uocEsSyncManagerSaveDataReqBo.setObjId(uocImplOrderDo.getImplOrderId());
//                uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
//            });
//        }
//    }

    private void syncShip() {
        List<UocShipOrderDo> listOrder = getListShipOrder();
        if (!CollectionUtils.isEmpty(listOrder)) {
            listOrder.forEach(uocShipOrderDo -> {
                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(uocShipOrderDo, UocEsSyncManagerSaveDataReqBo.class);
                uocEsSyncManagerSaveDataReqBo.setIndexName(uocIndexConfig.getShipOrderIndex());
                uocEsSyncManagerSaveDataReqBo.setObjId(uocShipOrderDo.getShipOrderId());
                uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            });
        }
    }

    private void syncInsp() {
        List<UocInspOrderDo> listOrder = getListInspOrder();
        if (!CollectionUtils.isEmpty(listOrder)) {
            listOrder.forEach(uocInspOrderDo -> {
                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(uocInspOrderDo, UocEsSyncManagerSaveDataReqBo.class);
                uocEsSyncManagerSaveDataReqBo.setIndexName(uocIndexConfig.getInspOrderIndex());
                uocEsSyncManagerSaveDataReqBo.setObjId(uocInspOrderDo.getInspOrderId());
                uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            });
        }
    }

    private void syncChng() {
        List<UocChngOrderDo> listOrder = getListChngOrder();
        if (!CollectionUtils.isEmpty(listOrder)) {
            listOrder.forEach(uocChngOrderDo -> {
                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = UocRu.js(uocChngOrderDo, UocEsSyncManagerSaveDataReqBo.class);
                uocEsSyncManagerSaveDataReqBo.setIndexName(uocIndexConfig.getChngOrderIndex());
                uocEsSyncManagerSaveDataReqBo.setObjId(uocChngOrderDo.getChngOrderId());
                uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            });
        }
    }

    private void syncTodo() {
        List<UocOrderTaskInst> listOrder = getListTaskInst();
        if (!CollectionUtils.isEmpty(listOrder)) {
            listOrder.forEach(uocOrderTaskInst -> {
                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
                uocEsSyncManagerSaveDataReqBo.setIndexName(uocIndexConfig.getTodoIndex());
                uocEsSyncManagerSaveDataReqBo.setObjId(uocOrderTaskInst.getId());
                uocEsSyncManagerSaveDataReqBo.setOrderId(uocOrderTaskInst.getOrderId());
                uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            });
        }
    }

    private void syncAfOrder() {
        List<UocAfOrder> listAfOrder = getListAfOrder();
        if (ObjectUtil.isNotEmpty(listAfOrder)) {
            listAfOrder.forEach(each -> {
                UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
                uocEsSyncManagerSaveDataReqBo.setIndexName(uocIndexConfig.getAfOrderIndex());
                uocEsSyncManagerSaveDataReqBo.setObjId(each.getAfOrderId());
                uocEsSyncManagerSaveDataReqBo.setOrderId(each.getOrderId());
                uocEsSyncManager.saveData(uocEsSyncManagerSaveDataReqBo);
            });
        }
    }

    private List<UocSaleOrderDo> getListSaleOrder() {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        return iUocSaleOrderModel.qrySaleOrderList(uocSaleOrderDo);
    }

    private List<UocAfOrder> getListAfOrder() {
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        return iUocAfOrderModel.getAfOrderList(uocAfOrderQryBo);
    }

//    private List<UocImplOrderDo> getListImplOrder() {
//        UocImplOrderQryBo uocImplOrderQryBo = new UocImplOrderQryBo();
//        return iUocImplOrderModel.getListImplOrder(uocImplOrderQryBo);
//    }

    private List<UocShipOrderDo> getListShipOrder() {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        return iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
    }

    private List<UocInspOrderDo> getListInspOrder() {
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        return iUocInspOrderModel.getListInspOrder(uocInspOrderQryBo);
    }

    private List<UocChngOrderDo> getListChngOrder() {
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        return iUocChngOrderModel.getListChngOrder(uocChngOrderQryBo);
    }

    private List<UocOrderTaskInst> getListTaskInst() {
        UocOrderTaskInstQryBo uocOrderTaskInstQryBo = new UocOrderTaskInstQryBo();
        uocOrderTaskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        return iUocOrderModel.qryOrderTaskInstList(uocOrderTaskInstQryBo);
    }
}
