package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocDMsgPoolQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderItemQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderItem;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.common.bo.UocProRspConstants;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocOrderPropertiesUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/*
 * @Author lsl
 * @Description //TODO 电商订单消息处理，用于生成发货单
 * @Date 16:30 2022/4/12
 * @Param
 * @return
 */
@Slf4j
@HTServiceImpl
public class UocMsgCreateShipServiceImpl implements UocMsgCreateShipService {
    
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    
    @Autowired
    private IUocOrderModel iUocOrderModel;
    
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Autowired
    private IUocCommonModel iUocCommonModel;
    
    @Override
    public UocMsgCreateShipRspBo createShip(UocMsgCreateShipReqBo reqBo) {
        UocMsgCreateShipRspBo rspBo = new UocMsgCreateShipRspBo();
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc("发货单、发货单明细创建成功");

        //默认是第一次发货
        rspBo.setFirstDeliverFlag(true);
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getDycUocQryMsgBO().getObjId());
        List<UocShipOrderDo> shipOrderDoList = iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        //如果查询到发货信息，则说明不是第一次发货
        if(ObjectUtil.isNotEmpty(shipOrderDoList)){
            rspBo.setFirstDeliverFlag(false);
        }

        //查询销售订单信息
        UocSaleOrderDo uocSaleOrderDo = qrySale(reqBo);
        if(null == uocSaleOrderDo){
            rspBo.setRespCode(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR);
            rspBo.setRespDesc("订单发货通知业务失败：未查询到销售订单信息!");
            return rspBo;
        }

        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        taskInstQryBo.setObjId(uocSaleOrderDo.getSaleOrderId());
        taskInstQryBo.setFinishTag(UocDicConstant.FINISH_FLAG.UN_FINISHED);
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        //查询订单任务实例
        List<UocOrderTaskInst> taskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        if(ObjectUtil.isNotEmpty(taskInsts)){
            rspBo.setTaskInstId(taskInsts.get(0).getTaskInstId());
            rspBo.setStepId(taskInsts.get(0).getProcState());
        }
        //查询销售订单明细信息
        List<UocSaleOrderItemQryBo> orderItemQryBoList = new ArrayList<>();
        log.info("JD_SUPPLIER:{}",UocOrderPropertiesUtil.getProperty("SUPPLIER_JD_ID"));
        log.info("SUNING_SUPPLIER:{}",UocOrderPropertiesUtil.getProperty("SUPPLIER_SUNING_ID"));
        log.info("消息supNo:{}",String.valueOf(reqBo.getDycUocQryMsgBO().getSupNo()));
        //非京东苏宁单
        if(!UocOrderPropertiesUtil.getProperty("SUPPLIER_JD_ID").equals(String.valueOf(reqBo.getDycUocQryMsgBO().getSupNo()))
                && !UocOrderPropertiesUtil.getProperty("SUPPLIER_SUNING_ID").equals(String.valueOf(reqBo.getDycUocQryMsgBO().getSupNo()))){
            //查询电商订单信息中的商品信息
            List<UocOrderSkuBO> extOrderSaleItemRspBOList = null;
            if (reqBo.getExtOrderInfoBO().getSaleOrderRspBO() != null) {
                extOrderSaleItemRspBOList = reqBo.getExtOrderInfoBO().getSaleOrderRspBO().getSku();
            }
            if (reqBo.getExtOrderInfoBO().getParentSaleOrderRspBO() != null) {
                extOrderSaleItemRspBOList = reqBo.getExtOrderInfoBO().getParentSaleOrderRspBO().getSku();
            }
            //定义商品ID和发货数量对应关系Map
            Map<String, BigDecimal> skuSendNumMap = new HashMap<>();
            
            Map<Long, UocSaleOrderItemQryBo> map = new HashMap<>();
            
            for(UocDeliveryItemsBO deliveryItemsBO: reqBo.getDeliveryInfoBO().getDeliveryItems()){
                List<UocOrderItem> uocOrdGoodsQryBos = getOrdGoodsByExtSkuId(uocSaleOrderDo, deliveryItemsBO);
        
                for(UocOrderItem uocOrdGoodsQryBo:uocOrdGoodsQryBos){
                    if (uocOrdGoodsQryBo.getSkuExtSkuId().equals(deliveryItemsBO.getSkuId())) {
                        skuSendNumMap.put(uocOrdGoodsQryBo.getSkuId(), new BigDecimal(deliveryItemsBO.getNum()));
                
                        List<UocSaleOrderItemQryBo> ordItemRspBOS = null;
                        try {
                            ordItemRspBOS = qryOrdItem(uocSaleOrderDo, uocOrdGoodsQryBo.getSkuId());
                        } catch (Exception e) {
                            rspBo.setRespCode(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR);
                            rspBo.setRespDesc("订单发货通知业务失败：未查询到销售订单明细信息!");
                            return rspBo;
                        }
                        if (extOrderSaleItemRspBOList != null) {
                            for (UocOrderSkuBO extOrderSaleItemRspBO : extOrderSaleItemRspBOList) {
                                for (UocSaleOrderItemQryBo saleOrderItemQryBo : ordItemRspBOS) {//商城的销售单明细信息
                                    if (extOrderSaleItemRspBO.getSkuId().equals(deliveryItemsBO.getSkuId())) {
//                            if (extOrderSaleItemRspBO.getNakedPrice() != null) {
//                                ordItemRspBO.setNakedPrice(extOrderSaleItemRspBO.getNakedPrice().longValue());
//                            }
                                        if (extOrderSaleItemRspBO.getTaxPrice() != null) {
                                            saleOrderItemQryBo.setTaxPrice(extOrderSaleItemRspBO.getTaxPrice().toString());
                                        }
                                        if (extOrderSaleItemRspBO.getTax() != null) {
                                            saleOrderItemQryBo.setTax(String.valueOf(extOrderSaleItemRspBO.getTax()));
                                        }
                                
                                        //判断是否已全部发货,防止重复发货
                                        if (saleOrderItemQryBo.getPurchaseCount().compareTo(saleOrderItemQryBo.getSendCount()) > 0) {
                                            map.putIfAbsent(saleOrderItemQryBo.getSaleOrderItemId(), saleOrderItemQryBo);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
        
            }
            if (map.size() > 0) {
                for (Long id : map.keySet()) {
                    orderItemQryBoList.add(map.get(id));
                }
            }
            //只有当有发货的明细时才执行发货
            if (!orderItemQryBoList.isEmpty()) {
                //构建发货单入参
                Long shipOrderId = null;
                try {
                    UocShipOrderQryBo shipOrderQryBo =  buildShipAndItemData(uocSaleOrderDo, orderItemQryBoList, reqBo.getDeliveryInfoBO(), skuSendNumMap);
                    shipOrderId = ceateCoreShip(uocSaleOrderDo,shipOrderQryBo);
                } catch (Exception e) {
                    log.error("创建发货单异常：",e);
                    //处理完发货消息后更新msgPool中的执行状态为执行失败
                    UocDMsgPoolQryBo qryBo = new UocDMsgPoolQryBo();
                    qryBo.setMsgId(reqBo.getDycUocQryMsgBO().getMsgId());
            
                    UocDMsgPoolQryBo  msgPoolQryBo = iUocOrderModel.getModelByMsgId(qryBo);
                    msgPoolQryBo.setFailureCount(qryBo.getFailureCount() + 1);
                    msgPoolQryBo.setRunResult(0);//执行失败
                    msgPoolQryBo.setMsgId(reqBo.getDycUocQryMsgBO().getMsgId());
                    iUocOrderModel.updateMsgPoolById(qryBo);
                    rspBo.setRespCode(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR);
                    rspBo.setRespDesc("订单发货通知业务失败：创建发货单失败!" + e.getMessage());
                    return rspBo;
                }
                rspBo.setShipOrderId(shipOrderId);
            }else{
                rspBo.setRespCode(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR);
                rspBo.setRespDesc("已经全部发货，无需发货");
                return rspBo;
            }
        }else{
            log.info("京东订单发货开始");
            //京东苏宁单
            if(ObjectUtil.isNotEmpty(shipOrderDoList)){
                rspBo.setRespCode(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR);
                rspBo.setRespDesc("订单明细已全部发货完毕，已不能再进行发货操作");
                return rspBo;
            }
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setOrderId(uocSaleOrderDo.getOrderId());
            uocSaleOrderItemQryBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
    
            List<UocSaleOrderItem> uocOrderItemQryBoList = new ArrayList<>();
            try {
                uocOrderItemQryBoList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
            } catch (Exception e) {
                rspBo.setRespCode(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR);
                rspBo.setRespDesc("订单发货通知业务失败：未查询到销售订单明细信息!");
                return rspBo;
            }
            //判断是不是厂直订单:1是厂直；0:非厂直
            Integer jdCz = 0;
            if(ObjectUtil.isNotEmpty(reqBo.getOrderType()) && reqBo.getOrderType() == 5){
                jdCz = 1;
            }
            uocSaleOrderDo.setJdCz(jdCz);
            orderItemQryBoList = UocRu.jsl(uocOrderItemQryBoList,UocSaleOrderItemQryBo.class);
            
            Long shipOrderId = null;
    
            UocDeliveryInfoBO deliveryInfoBO = new UocDeliveryInfoBO();
            deliveryInfoBO.setOrderId(String.valueOf(reqBo.getDycUocQryMsgBO().getOrderId()));
            deliveryInfoBO.setPackageId(reqBo.getDycUocQryMsgBO().getOutOrderId());
            UocShipOrderQryBo shipOrderQryBo =  buildShipAndItemData(uocSaleOrderDo, orderItemQryBoList, deliveryInfoBO, new HashMap<>());
            shipOrderId = ceateCoreShip(uocSaleOrderDo,shipOrderQryBo);
            rspBo.setShipOrderId(shipOrderId);
        }
        //处理完发货消息后更新msgPool中的执行状态为已执行
        UocDMsgPoolQryBo qryBo = new UocDMsgPoolQryBo();
        qryBo.setId(reqBo.getDycUocQryMsgBO().getId());
        qryBo.setRunResult(1);//执行成功
        iUocOrderModel.updateMsgPoolById(qryBo);

        UocOrderQueryIndex uocOrderQueryIndex = new UocOrderQueryIndex();
        uocOrderQueryIndex.setObjId(rspBo.getShipOrderId());
        uocOrderQueryIndex.setOrderSystem(UocDicConstant.OBJ_TYPE.SHIP.toString());
        uocOrderQueryIndex.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        if(!UocOrderPropertiesUtil.getProperty("SUPPLIER_JD_ID").equals(String.valueOf(reqBo.getDycUocQryMsgBO().getSupNo()))
                && !UocOrderPropertiesUtil.getProperty("SUPPLIER_SUNING_ID").equals(String.valueOf(reqBo.getDycUocQryMsgBO().getSupNo()))){
            uocOrderQueryIndex.setOutObjId(reqBo.getDycUocQryMsgBO().getPackageid());
        }else{
            uocOrderQueryIndex.setOutObjId(reqBo.getDycUocQryMsgBO().getOutOrderId());
        }
        uocOrderQueryIndex.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        uocOrderQueryIndex.setId(IdUtil.nextId());
        iUocCommonModel.saveOrderQueryIndex(uocOrderQueryIndex);

        rspBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());//返回销售单id
        rspBo.setOrderSource(uocSaleOrderDo.getOrderSource());//返回订单来源
        rspBo.setOrderId(uocSaleOrderDo.getOrderId());

        // 如果是第一次发货提交任务
        if (rspBo.getFirstDeliverFlag()) {
            UocCommonDo uocCommonDo = new UocCommonDo();
            List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(rspBo.getTaskInstId());
            taskBos.add(taskBo);
            uocCommonDo.setCompleteTaskInfos(taskBos);
            uocCommonDo.setUserId(11111L);
            uocCommonDo.setOrderId(reqBo.getOrderId());
            iUocCommonModel.dealTask(uocCommonDo);
        }
        boolean finish = checkSaleOrderIsFinish(reqBo.getOrderId(),uocSaleOrderDo.getSaleOrderId());
        rspBo.setFinish(finish);
        return rspBo;
    }
    public UocShipOrderQryBo buildShipAndItemData(UocSaleOrderDo uocSaleOrderDo, List<UocSaleOrderItemQryBo> orderItemQryBoList, UocDeliveryInfoBO qryPackageRsp,Map<String, BigDecimal> skuSendNumMap){
        UocShipOrderQryBo uocCoreOrderShipReqBO = new UocShipOrderQryBo();
    
        uocCoreOrderShipReqBO.setShipOrderNo(genShipCode(uocSaleOrderDo));

        uocCoreOrderShipReqBO.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
        uocCoreOrderShipReqBO.setOrderId(uocSaleOrderDo.getOrderId());
    
        uocCoreOrderShipReqBO.setShipOrderId(IdUtil.nextId());
    
        uocCoreOrderShipReqBO.setShipOrderState(UocStateConstants.ShipOrder.FH_FH_FH);
        //已发货
//        uocCoreOrderShipReqBO.setShipStatus(UocConstant.SHIP_ORDER_STATUS.DELIVERED);
        //不包含附件
        uocCoreOrderShipReqBO.setIsEnclosure(0);
//        uocCoreOrderShipReqBO.setCreateOperId(createOperId);
        uocCoreOrderShipReqBO.setCreateTime(new Date());
        if (StringUtils.isBlank(qryPackageRsp.getPackageId())) {
            uocCoreOrderShipReqBO.setShipOrderNoExt(qryPackageRsp.getOrderId());//外部发货单id
        } else {
            uocCoreOrderShipReqBO.setShipOrderNoExt(qryPackageRsp.getPackageId());
        }
        uocCoreOrderShipReqBO.setShipCompanyName(qryPackageRsp.getDeliveryName());//物流公司名称
        uocCoreOrderShipReqBO.setShipCompanyId(qryPackageRsp.getDeliveryCode());//物流公司编码
        uocCoreOrderShipReqBO.setShipTime(DateUtils.strToDateLong(qryPackageRsp.getDeliverytime()));
        uocCoreOrderShipReqBO.setShipRemark("外部电商发货");
        List<UocShipOrderItemQryBo> shipItemList = new ArrayList<>();
        for (UocSaleOrderItemQryBo saleOrderItemQryBo : orderItemQryBoList) {
            Long saleOrderItemId = saleOrderItemQryBo.getSaleOrderItemId();
            UocShipOrderItemQryBo uocCoreShipItemReqBO = new UocShipOrderItemQryBo();
            uocCoreShipItemReqBO.setShipOrderId(uocCoreOrderShipReqBO.getShipOrderId());
            uocCoreShipItemReqBO.setSaleOrderId(saleOrderItemQryBo.getSaleOrderId());
            uocCoreShipItemReqBO.setShipOrderItemId(IdUtil.nextId());
            uocCoreShipItemReqBO.setSaleOrderItemId(saleOrderItemId);
            uocCoreShipItemReqBO.setOrderId(saleOrderItemQryBo.getOrderId());
            uocCoreShipItemReqBO.setUnitName(saleOrderItemQryBo.getUnitName());
            if (skuSendNumMap.get(saleOrderItemQryBo.getSkuId()) != null) {
                if (saleOrderItemQryBo.getPurchaseCount().compareTo(skuSendNumMap.get(saleOrderItemQryBo.getSkuId())) < 0) {
                    uocCoreShipItemReqBO.setSendCount(saleOrderItemQryBo.getPurchaseCount());
                    skuSendNumMap.put(saleOrderItemQryBo.getSkuId(), skuSendNumMap.get(saleOrderItemQryBo.getSkuId()).subtract(saleOrderItemQryBo.getPurchaseCount()));
                } else {
                    uocCoreShipItemReqBO.setSendCount(skuSendNumMap.get(saleOrderItemQryBo.getSkuId()));
                }
            } else {
                uocCoreShipItemReqBO.setSendCount(saleOrderItemQryBo.getPurchaseCount());
            }
            uocCoreShipItemReqBO.setArriveCount(BigDecimal.ZERO);
            uocCoreShipItemReqBO.setRefuseCount(BigDecimal.ZERO);
            uocCoreShipItemReqBO.setReturnCount(BigDecimal.ZERO);
            uocCoreShipItemReqBO.setInspCount(BigDecimal.ZERO);
            uocCoreShipItemReqBO.setCreateTime(new Date());
            uocCoreShipItemReqBO.setRemark("外部电商发货");
            uocCoreShipItemReqBO.setShipItemState(UocStateConstants.ShipOrder.FH_FH_FH);
            
            shipItemList.add(uocCoreShipItemReqBO);
        }
        uocCoreOrderShipReqBO.setShipOrderItemBoList(shipItemList);
        return uocCoreOrderShipReqBO;
    }
    
    /*
     * @Author lsl
     * @Description //TODO 查询销售订单信息
     * @Date 16:36 2022/4/12
     * @Param [reqBo]
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     */
    public UocSaleOrderDo qrySale(UocMsgCreateShipReqBo reqBo){
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getDycUocQryMsgBO().getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(reqBo.getDycUocQryMsgBO().getObjId());
        return iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }
    private boolean checkSaleOrderIsFinish(Long orderId,Long saleOrderId) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(orderId);
        uocSaleOrderItemQryBo.setSaleOrderId(saleOrderId);
        UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.getCollectCountImplOrderItem(uocSaleOrderItemQryBo);
        if (org.springframework.util.CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_CONFIRM_REFUSE_ERROR, "查询数量汇总为空");
        }
        UocSaleOrderItem uocSaleOrderItem = uocSaleOrderDo.getSaleOrderItems().get(0);
        if (null == uocSaleOrderItem) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_CONFIRM_REFUSE_ERROR, "查询数量汇总为空");
        }
        //采购数量 = 发货数量 + 退货数量 则发货完成
        if (uocSaleOrderItem.getPurchaseCount().compareTo(uocSaleOrderItem.getSendCount().add(uocSaleOrderItem.getReturnCount())) == 0) {
            return true;
        }
        return false;
    }

    /**
     * 根据外部SKUID查询内部SKUID信息
     *
     * @param
     * @param deliveryItemsBO 外部商品信息
     * @return OrdGoodsPO
     */
    private List<UocOrderItem> getOrdGoodsByExtSkuId(UocSaleOrderDo uocSaleOrderDo, UocDeliveryItemsBO deliveryItemsBO) {
        try {
            UocOrderItemQryBo uocOrderItemQryBo = new UocOrderItemQryBo();
            uocOrderItemQryBo.setOrderId(uocSaleOrderDo.getOrderId());
            
            List<UocOrderItem> uocOrdGoodsQryBos = iUocOrderModel.qryOrderItemList(uocOrderItemQryBo);
            if (uocOrdGoodsQryBos == null) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "订单发货通知业务失败：没有查询到内部商品信息");
            }
            return uocOrdGoodsQryBos;
        } catch (Exception e) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "订单发货通知业务失败：没有查询到内部商品信息");
        }
    }

    /*
     * @Author lsl
     * @Description //TODO 查询销售订单明细信息
     * @Date 17:43 2022/4/12
     * @Param [ordSalePO, skuId]
     * @return java.util.List<OrdItemPO>
     */
    private List<UocSaleOrderItemQryBo> qryOrdItem(UocSaleOrderDo uocSaleOrderDo, String skuId) {
        try {
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setSkuId(skuId);
            uocSaleOrderItemQryBo.setOrderId(uocSaleOrderDo.getOrderId());
            uocSaleOrderItemQryBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
            List<UocSaleOrderItem> uocOrderItemQryBoList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
            if (CollectionUtils.isEmpty(uocOrderItemQryBoList)) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "订单发货通知业务失败：未查询到销售订单明细信息");
            }
            List<UocSaleOrderItemQryBo> rspBO = new ArrayList<>();
            rspBO = uocOrderItemQryBoList.stream().map(e->{
                UocSaleOrderItemQryBo uocOrderItemQryBo1 = JSONObject.parseObject(JSON.toJSONString(e),UocSaleOrderItemQryBo.class);
                return uocOrderItemQryBo1;
            }).collect(Collectors.toList());
            
            return rspBO;
        } catch (Exception e) {
            log.error("订单发货通知业务失败：查询销售订单明细时数据库异常!", e);
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "订单发货通知业务失败：查询销售订单明细时数据库异常!");
        }
    }
    
    /*
     * @Author lsl
     * @Description //TODO 创建发货单
     * @Date 19:39 2022/4/12
     * @Param [uocShipOrderQryBo]
     * @return java.lang.Long
     */
    public Long ceateCoreShip(UocSaleOrderDo uocSaleOrderDo,UocShipOrderQryBo uocShipOrderQryBo){
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
//        BeanUtils.copyProperties(uocShipOrderQryBo,uocShipOrderDo);
        uocShipOrderDo = JSONObject.parseObject(JSON.toJSONString(uocShipOrderQryBo),UocShipOrderDo.class);
//        uocShipOrderDo.setShipOrderId(IdUtil.nextId());//发货单ID
        judeCount(uocShipOrderQryBo.getShipOrderItemBoList());
        //创建发货单和发货单明细
        iUocShipOrderModel.createShipOrder(uocShipOrderDo);
        List<UocSaleOrderItem> saleOrderItems = new ArrayList<>();
        UocSaleOrderDo convertSaleOrderDo = new UocSaleOrderDo();
        
        convertSaleOrderDo.setSaleOrderId(uocShipOrderQryBo.getSaleOrderId());
        convertSaleOrderDo.setOrderId(uocShipOrderQryBo.getOrderId());
        //修改销售订单发货明细数量
        for(UocShipOrderItemQryBo item :uocShipOrderQryBo.getShipOrderItemBoList() ){
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setSaleOrderItemId(item.getSaleOrderItemId());
            uocSaleOrderItem.setSendCount(item.getSendCount());
            saleOrderItems.add(uocSaleOrderItem);
            
        }
        convertSaleOrderDo.setSaleOrderItems(saleOrderItems);
        
        iUocSaleOrderModel.modifyBatchItemSendCount(convertSaleOrderDo);
        if(uocSaleOrderDo.getJdCz() == 0){
            convertSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_FH_FHZ);
        }else {
            convertSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_FH_FHZ_JDCZ);
        }
        //更新销售单状态为发货中
        iUocSaleOrderModel.modifySaleOrderMain(convertSaleOrderDo);
        return uocShipOrderDo.getShipOrderId();
    }
    /*
     * @Author lsl
     * @Description //TODO 当发货数量为空时，设置默认值0
     * @Date 19:20 2022/4/12
     * @Param [shipItemList]
     * @return void
     */
    public void judeCount(List<UocShipOrderItemQryBo> shipItemList){
        for(UocShipOrderItemQryBo item : shipItemList){
            if(null == item.getSendCount()){
                item.setSendCount(new BigDecimal(0));
            }
            if (null == item.getArriveCount()) {
                item.setArriveCount(new BigDecimal(0));
            }
            if (null == item.getRefuseCount()) {
                item.setRefuseCount(new BigDecimal(0));
            }
            if (null == item.getReturnCount()) {
                item.setReturnCount(new BigDecimal(0));
            }
            if (null == item.getInspCount()) {
                item.setInspCount(new BigDecimal(0));
            }
        }
    }
    
    /*
     * @Author lsl
     * @Description //TODO 生成发货单编码
     * @Date 10:52 2022/4/20
     * @Param [uocSaleOrderDo]
     * @return java.lang.String
     */
    public String genShipCode(UocSaleOrderDo uocSaleOrderDo){
        UocShipOrderDo shipOrderDo = new UocShipOrderDo();
        shipOrderDo.setOrderSource(uocSaleOrderDo.getOrderSource());
        shipOrderDo = iUocShipOrderModel.getShipOrderNo(shipOrderDo);
        return shipOrderDo.getShipOrderNo();
    }
}
