package com.tydic.dyc.oc.service.order;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.service.order.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;


/**
 * 标题:UocQryOrderProcessInstanceListServiceImpl
 * 说明:
 * 时间:2022/2/25 10:29
 * 作者:田坤林
 */
@HTServiceImpl
public class UocQryOrderProcessInstanceListServiceImpl implements UocQryOrderProcessInstanceListService {

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public UocQryOrderProcessInstanceListServiceRspBo qryOrderProcessInstanceList(UocQryOrderProcessInstanceListServiceReqBo reqBo) {
        validateParam(reqBo);
        UocQryOrderProcessInstanceListServiceRspBo rspBo = UocRu.success(UocQryOrderProcessInstanceListServiceRspBo.class);
        List<UocOrderProcInst> uocOrderProcInsts = iUocOrderModel.qryOrderProcInstList(UocRu.js(reqBo, UocOrderProcInstQryBo.class));
        rspBo.setDataList(UocRu.jsl(uocOrderProcInsts, UocGetOrderTheProcessInstanceServiceRspProcInsBo.class));
        return rspBo;
    }

    private void validateParam(UocQryOrderProcessInstanceListServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参不能为空");
        }
    }
}


