/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.oc.service.domainservice.UocInspOrderTemplateCreateService;
import com.tydic.dyc.oc.service.domainservice.bo.UocInspOrderTemplateCreateReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocInspOrderTemplateCreateRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderExportBO;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Arrays;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocInspOrderTemplateCreateService"})
public class UocInspOrderTemplateCreateServiceImpl
implements UocInspOrderTemplateCreateService {
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    private static final String PATH = "uoc";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.accessUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    @PostMapping(value={"createInspOrderTemplate"})
    public UocInspOrderTemplateCreateRspBo createInspOrderTemplate(@RequestBody UocInspOrderTemplateCreateReqBo reqBo) {
        UocInspOrderTemplateCreateRspBo rspBo = UocRu.success(UocInspOrderTemplateCreateRspBo.class);
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet sheet = wb.createSheet("\u5230\u8d27\u9a8c\u6536\u5bfc\u5165\u6a21\u677f");
        int index = 0;
        if (ObjectUtil.isNotEmpty((Object)reqBo.getRows())) {
            for (UocShipOrderExportBO row : reqBo.getRows()) {
                index = this.createExcelTemplate(sheet, wb, index, row);
            }
        } else {
            this.createExcelTemplate(sheet, wb, index, null);
        }
        return rspBo;
    }

    private int createExcelTemplate(HSSFSheet sheet, HSSFWorkbook wb, int index, UocShipOrderExportBO row) {
        if (index == 0) {
            this.createTitleRow(wb, sheet);
        }
        index = this.createFirstRow(sheet, index, row);
        index = this.createSecondRow(sheet, index, row);
        index = this.createHeadRow(sheet, index, row);
        return index;
    }

    private int createHeadRow(HSSFSheet sheet, int index, UocShipOrderExportBO row) {
        HSSFRow headRow = sheet.createRow(++index);
        List<String> headCells = Arrays.asList("\u5e8f\u53f7", "\u5546\u54c1\u540d\u79f0", "\u7269\u6599\u7f16\u7801", "\u7269\u6599\u5206\u7c7b", "\u89c4\u683c", "\u578b\u53f7", "\u91c7\u8d2d\u6570\u91cf", "\u8ba1\u91cf\u5355\u4f4d", "\u5230\u8d27\u6570\u91cf", "\u9a8c\u6536\u6570\u91cf");
        for (int i = 0; i < headCells.size(); ++i) {
            HSSFCell headCell = headRow.createCell(i);
            headCell.setCellValue(headCells.get(i));
            if (!ObjectUtil.isNotEmpty((Object)row.getShipOrderItemExportBOList())) continue;
            row.getShipOrderItemExportBOList().forEach(each -> {});
        }
        return index;
    }

    private int createFirstRow(HSSFSheet sheet, int index, UocShipOrderExportBO row) {
        HSSFRow row1 = sheet.createRow(++index);
        HSSFCell cell1 = row1.createCell(0);
        cell1.setCellValue("\u53d1\u8d27\u5355\u7f16\u53f7");
        sheet.addMergedRegion(new CellRangeAddress(index, index, 1, 2));
        HSSFCell cell2 = row1.createCell(1);
        cell2.setCellValue(null != row ? row.getDeliveryOrderNo() : "");
        sheet.addMergedRegion(new CellRangeAddress(index, index, 3, 4));
        HSSFCell cell3 = row1.createCell(3);
        cell3.setCellValue("\u5916\u90e8\u53d1\u8d27\u5355\u7f16\u53f7");
        sheet.addMergedRegion(new CellRangeAddress(index, index, 5, 6));
        HSSFCell cell4 = row1.createCell(5);
        cell4.setCellValue(row.getOutDeliveryOrderNo());
        HSSFCell cell5 = row1.createCell(7);
        cell5.setCellValue("\u4e0b\u5355\u65f6\u95f4");
        sheet.addMergedRegion(new CellRangeAddress(index, index, 8, 9));
        HSSFCell cell6 = row1.createCell(8);
        cell6.setCellValue(row.getOrderCreateTime());
        return index;
    }

    private int createSecondRow(HSSFSheet sheet, int index, UocShipOrderExportBO row) {
        HSSFRow row2 = sheet.createRow(++index);
        HSSFCell cell1 = row2.createCell(0);
        cell1.setCellValue("\u9a8c\u6536\u5355\u4f4d");
        sheet.addMergedRegion(new CellRangeAddress(index, index, 1, 4));
        HSSFCell cell2 = row2.createCell(1);
        cell2.setCellValue(row.getOrderCreateOperName());
        HSSFCell cell3 = row2.createCell(5);
        cell3.setCellValue("\u4f9b\u5e94\u5546");
        sheet.addMergedRegion(new CellRangeAddress(index, index, 6, 9));
        HSSFCell cell4 = row2.createCell(6);
        cell4.setCellValue(row.getSupName());
        return index;
    }

    private void createTitleRow(HSSFWorkbook wb, HSSFSheet sheet) {
        HSSFRow titleRow = sheet.createRow(0);
        sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, 9));
        titleRow.setHeightInPoints(140.0f);
        HSSFCellStyle titleStyle = wb.createCellStyle();
        this.setCellStyle(wb, titleStyle, true);
        HSSFCell titleCell = titleRow.createCell(0);
        titleCell.setCellStyle(titleStyle);
        String text = "\u5230\u8d27\u9a8c\u6536\u5355";
        titleCell.setCellValue((RichTextString)new HSSFRichTextString(text));
    }

    private void setCellStyle(HSSFWorkbook wb, HSSFCellStyle bodyStyle, Boolean isTitle) {
        bodyStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
        bodyStyle.setAlignment(HorizontalAlignment.LEFT);
        bodyStyle.setWrapText(true);
        if (!isTitle.booleanValue()) {
            bodyStyle.setBorderBottom(BorderStyle.THIN);
            bodyStyle.setBorderLeft(BorderStyle.THIN);
            bodyStyle.setBorderTop(BorderStyle.THIN);
            bodyStyle.setBorderRight(BorderStyle.THIN);
        }
        HSSFFont fontStyle = wb.createFont();
        fontStyle.setFontName("\u5b8b\u4f53");
        fontStyle.setFontHeightInPoints((short)11);
        bodyStyle.setFont(fontStyle);
    }
}

