/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.UocAfterServiceTypeQryService;
import com.tydic.dyc.oc.service.saleorder.bo.UocAfterServiceTypeQryServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocAfterServiceTypeQryServiceRspAfsBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocAfterServiceTypeQryServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.saleorder.UocAfterServiceTypeQryService"})
public class UocAfterServiceTypeQryServiceImpl
implements UocAfterServiceTypeQryService {
    private static final Logger log = LoggerFactory.getLogger(UocAfterServiceTypeQryServiceImpl.class);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @PostMapping(value={"qryAfterServiceType"})
    public UocAfterServiceTypeQryServiceRspBo qryAfterServiceType(@RequestBody UocAfterServiceTypeQryServiceReqBo reqBo) {
        UocAfterServiceTypeQryServiceRspBo rspBo = UocRu.success(UocAfterServiceTypeQryServiceRspBo.class);
        rspBo.setServerTypes(new ArrayList());
        HashMap<String, String> map = new HashMap<String, String>();
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setShipOrderId(reqBo.getShipOrderId());
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        UocShipOrderDo shipOrderById = this.iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
        log.info("\u6539\u53d1\u8d27\u5355\uff1a" + shipOrderById);
        Date arriveTime = shipOrderById.getArriveTime() == null ? new Date() : shipOrderById.getArriveTime();
        boolean returnEffectFlag = (new Date().getTime() - arriveTime.getTime()) / 86400000L >= 7L;
        this.validateArg(reqBo);
        ArrayList<UocSaleOrderItem> saleOrderItems = new ArrayList<UocSaleOrderItem>();
        List ordItemList = reqBo.getOrdItemList();
        for (Object saleOrderItemId : ordItemList) {
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setSaleOrderItemId((Long)saleOrderItemId);
            List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
            if (!CollectionUtil.isNotEmpty(saleOrderItemList)) continue;
            saleOrderItems.addAll(saleOrderItemList);
        }
        if (CollectionUtil.isEmpty(saleOrderItems)) {
            throw new BaseBusinessException("100001", "\u67e5\u8be2\u9500\u552e\u5355\u660e\u7ec6\u5bf9\u8c61\u5c5e\u6027\u4e3a\u7a7a");
        }
        ArrayList afTypesList = new ArrayList();
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            ArrayList<Integer> afTypesLists = new ArrayList<Integer>();
            if (ObjectUtil.isNotEmpty((Object)saleOrderItem.getRejectAllowDate()) && !shipOrderById.getShipOrderState().equals("FH_FH_YS")) {
                afTypesLists.add(UocConstant.AFTERORDER_SERVTYPE.RETURN);
                if (this.validateTime(arriveTime, saleOrderItem.getRejectAllowDate()).booleanValue()) {
                    map.put("return", "false");
                    map.put("returnTime", String.valueOf(Math.max(Integer.parseInt(map.getOrDefault("returnTime", "0")), saleOrderItem.getRejectAllowDate())));
                }
            }
            if (ObjectUtil.isNotEmpty((Object)saleOrderItem.getExchangeAllowDate())) {
                afTypesLists.add(UocConstant.AFTERORDER_SERVTYPE.CHANGE);
                if (this.validateTime(arriveTime, saleOrderItem.getExchangeAllowDate()).booleanValue()) {
                    map.put("exchange", "false");
                }
            }
            if (ObjectUtil.isNotEmpty((Object)saleOrderItem.getMaintainAllowDate())) {
                afTypesLists.add(UocConstant.AFTERORDER_SERVTYPE.FIX);
                if (this.validateTime(arriveTime, saleOrderItem.getMaintainAllowDate()).booleanValue()) {
                    map.put("fix", "false");
                }
            }
            if (CollectionUtil.isNotEmpty(afTypesList)) {
                Collection intersection = CollectionUtil.intersection(afTypesList, afTypesLists);
                afTypesList.clear();
                intersection.forEach(x -> afTypesList.add(x));
                continue;
            }
            afTypesList.addAll(afTypesLists);
        }
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("UOC_ORD_SERVICE_TYPE");
        Map<String, Map<String, String>> dicMap = this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
        Map<String, String> serviceMaps = dicMap.get("UOC_ORD_SERVICE_TYPE");
        afTypesList.stream().sorted(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o1 - o2;
            }
        }).forEach(integer -> {
            UocAfterServiceTypeQryServiceRspAfsBo uocAfterServiceTypeQryServiceRspAfsBo = new UocAfterServiceTypeQryServiceRspAfsBo();
            uocAfterServiceTypeQryServiceRspAfsBo.setServerType(integer);
            uocAfterServiceTypeQryServiceRspAfsBo.setServerName((String)serviceMaps.get(integer.toString()));
            if (integer.equals(UocDicConstant.SERVICE_TYPE.RETURN_GOODS)) {
                uocAfterServiceTypeQryServiceRspAfsBo.setCanApply(map.getOrDefault("return", "").equals("false") ? Boolean.FALSE : Boolean.TRUE);
                uocAfterServiceTypeQryServiceRspAfsBo.setServerDesc(uocAfterServiceTypeQryServiceRspAfsBo.getCanApply() != false ? "" : "\u652f\u6301" + (String)map.get("returnTime") + "\u5929\u65e0\u7406\u7531\u9000\u8d27\uff0c\u5df2\u8d85\u8fc7\u89c4\u5b9a\u7684\u9000\u8d27\u65f6\u95f4");
            }
            if (integer.equals(UocDicConstant.SERVICE_TYPE.EXCHANGE_GOODS)) {
                uocAfterServiceTypeQryServiceRspAfsBo.setCanApply(map.getOrDefault("exchange", "").equals("false") ? Boolean.FALSE : Boolean.TRUE);
                uocAfterServiceTypeQryServiceRspAfsBo.setServerDesc(uocAfterServiceTypeQryServiceRspAfsBo.getCanApply() != false ? "" : "\u5df2\u8d85\u8fc7\u6362\u8d27/\u7ef4\u4fee\u65f6\u9650");
            }
            if (integer.equals(UocDicConstant.SERVICE_TYPE.REPAIR)) {
                uocAfterServiceTypeQryServiceRspAfsBo.setCanApply(map.getOrDefault("fix", "").equals("false") ? Boolean.FALSE : Boolean.TRUE);
                uocAfterServiceTypeQryServiceRspAfsBo.setServerDesc(uocAfterServiceTypeQryServiceRspAfsBo.getCanApply() != false ? "" : "\u5df2\u8d85\u8fc7\u6362\u8d27/\u7ef4\u4fee\u65f6\u9650");
            }
            rspBo.getServerTypes().add(uocAfterServiceTypeQryServiceRspAfsBo);
        });
        return rspBo;
    }

    private void validateArg(UocAfterServiceTypeQryServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocAfterServiceTypeQryServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrdItemList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355\u660e\u7ec6id\u5217\u8868]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Boolean validateTime(Date arriveTime, Integer timeLimit) {
        if ((new Date().getTime() - arriveTime.getTime()) / 86400000L >= (long)timeLimit.intValue()) {
            return true;
        }
        return false;
    }
}

