package com.tydic.dyc.oc.components.event.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocEventConstant;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * 标题:EventConsumerShipCreate
 * 说明:发货单创建后解释
 * 时间:2022/3/10 20:10
 * 作者:罗有
 */
@Component
@Slf4j

public class EventConsumerShipCreate implements EventConsumer {

    @Autowired
    private UocIndexConfig uocIndexConfig;
    
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerShipCreate->{}", JSON.toJSONString(map));

        List<IUocEsSyncQryEventReqBo> retList = new ArrayList<>();
        Long orderId = UocRu.parseLong(map.get("orderId"));
//        Long saleOrderId = UocRu.parseLong(map.get("saleOrderId"));
//        Long shipOrderId = UocRu.parseLong(map.get("shipOrderId"));
    
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(orderId);
        List<UocShipOrderDo> shipOrderDoList = iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        
        for (UocShipOrderDo shipOrderDo: shipOrderDoList){
            orderId = shipOrderDo.getOrderId();
            Long saleOrderId = shipOrderDo.getSaleOrderId();
            Long shipOrderId = shipOrderDo.getShipOrderId();


//        Long implOrderId = UocRu.parseLong(map.get("implOrderId"));
            List<IUocEsSyncQryReqBo> saleList = new ArrayList<>();
            IUocEsSyncQryReqBo sale = new IUocEsSyncQryReqBo();
            sale.setOrderId(orderId);
            sale.setObjId(saleOrderId);
            saleList.add(sale);
            IUocEsSyncQryEventReqBo saleEventReqBo = new IUocEsSyncQryEventReqBo();
            saleEventReqBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
            saleEventReqBo.setDataList(saleList);
            retList.add(saleEventReqBo);

//        List<IUocEsSyncQryReqBo> implList = new ArrayList<>();
//        IUocEsSyncQryReqBo impl = new IUocEsSyncQryReqBo();
//        impl.setOrderId(orderId);
//        impl.setObjId(implOrderId);
//        implList.add(impl);
//        IUocEsSyncQryEventReqBo implEventReqBo = new IUocEsSyncQryEventReqBo();
//        implEventReqBo.setIndexName(uocIndexConfig.getImplOrderIndex());
//        implEventReqBo.setDataList(implList);
//        retList.add(implEventReqBo);
    
            List<IUocEsSyncQryReqBo> shipList = new ArrayList<>();
            IUocEsSyncQryReqBo ship = new IUocEsSyncQryReqBo();
            ship.setOrderId(orderId);
            ship.setObjId(shipOrderId);
            shipList.add(ship);
            IUocEsSyncQryEventReqBo shipEventReqBo = new IUocEsSyncQryEventReqBo();
            shipEventReqBo.setIndexName(uocIndexConfig.getShipOrderIndex());
            shipEventReqBo.setDataList(shipList);
            retList.add(shipEventReqBo);
        }
        
        return retList;
    }

    @Override
    public String getEvent() {
        return UocEventConstant.UOC_SHIP_ORDER_SYNC;
    }
}


