package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.service.domainservice.bo.UocAdjustPriceOrderCreateReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAdjustPriceOrderCreateRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocAdjustPriceOrderCreateServiceImpl
 * 说明:TODO
 * 时间:2022/4/6 15:54
 * 作者:代愿愿
 */
@HTServiceImpl
public class UocAdjustPriceOrderCreateServiceImpl implements UocAdjustPriceOrderCreateService {
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;

    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Autowired
    IUocSaleOrderModel iUocSaleOrderModel;

    public static final String FIELD_CODE = "SKIP_ADJUST_PRICE_MEN";

    @Override
    public UocAdjustPriceOrderCreateRspBo createAdjustPriceOrder(UocAdjustPriceOrderCreateReqBo reqBo) {

        UocAdjustPriceOrderCreateRspBo uocAdjustPriceOrderCreateRspBo = UocRu.success(UocAdjustPriceOrderCreateRspBo.class);
        if(reqBo.getAdjustFlag()==1){
            // 入参校验
            validateArg(reqBo);
            // 创建变更单
            UocChngOrderDo uocChngOrderDo = convertChngOrderDo(reqBo,new Date());
            iUocChngOrderModel.createChngOrder(uocChngOrderDo);
            uocAdjustPriceOrderCreateRspBo.setChngOrderId(uocChngOrderDo.getChngOrderId());
        }else {
            //跳过调价人和跳过时间记录
            UocSaleOrderDo add = new UocSaleOrderDo();
            add.setOrderId(reqBo.getOrderId());
            UocSaleOrderMap uocSaleOrderMap = new UocSaleOrderMap();
            uocSaleOrderMap.setOrderId(reqBo.getOrderId());
            uocSaleOrderMap.setSaleOrderId(reqBo.getSaleOrderId());
            uocSaleOrderMap.setId(IdUtil.nextId());
            uocSaleOrderMap.setRemark("订单跳过调价");
            uocSaleOrderMap.setCreateOperId(String.valueOf(reqBo.getUserId()));
            uocSaleOrderMap.setFieldCode(FIELD_CODE);
            uocSaleOrderMap.setFieldName("跳过调价人");
            uocSaleOrderMap.setFieldValue(reqBo.getUsername());
            uocSaleOrderMap.setCreateTime(new Date());
            add.setSaleOrderMapList(Collections.singletonList(uocSaleOrderMap));
            iUocSaleOrderModel.addSaleOrderMap(add);

            //临时返回
            uocAdjustPriceOrderCreateRspBo.setChngOrderId(1L);
        }

        // 提交任务
        UocCommonDo uocCommonDo = new UocCommonDo();
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        taskBo.setTaskId(reqBo.getTaskId());
        taskBo.setStepId(reqBo.getStepId());
        taskBos.add(taskBo);
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(reqBo.getUserId());
        uocCommonDo.setOrderId(reqBo.getOrderId());
        iUocCommonModel.dealTask(uocCommonDo);
        return uocAdjustPriceOrderCreateRspBo;
    }
    /**
     * 参数转换
     */
    private UocChngOrderDo convertChngOrderDo(UocAdjustPriceOrderCreateReqBo reqBo,Date newDate) {
        // 设置变更单信息
        UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
        uocChngOrderDo.setOrderId(reqBo.getOrderId());
        uocChngOrderDo.setChngOrderId(IdUtil.nextId());
        uocChngOrderDo.setCreateOperId(reqBo.getUserId().toString());
        uocChngOrderDo.setCreateOperName(reqBo.getName());
        uocChngOrderDo.setCreateOperMobile(reqBo.getCellphone());
        uocChngOrderDo.setCreateTime(newDate);
        uocChngOrderDo.setRemark(reqBo.getRemark());
        uocChngOrderDo.setBusiType(UocConstant.BUSI_TYPE.PRICE_CHG);
        uocChngOrderDo.setTenantId(reqBo.getTenantId());
        // 设置变更对象信息
        List<UocChngOrderObj> uocChngOrderObjList = new ArrayList<>();
        UocChngOrderObj uocChngOrderObj = new UocChngOrderObj();
        uocChngOrderObj.setOrderId(reqBo.getOrderId());
        uocChngOrderObj.setChngOrderObjId(IdUtil.nextId());
        uocChngOrderObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
        uocChngOrderObj.setChngType(UocConstant.BUSI_TYPE.PRICE_CHG);
        uocChngOrderObj.setSaleOrderId(reqBo.getSaleOrderId());
        uocChngOrderObj.setCreateTime(newDate);
        uocChngOrderObj.setCreateOperId(reqBo.getUserId().toString());
        uocChngOrderObjList.add(uocChngOrderObj);
        // 设置变更对象明细
        List<UocChngOrderItemObj> uocChngOrderItemObjList = new ArrayList<>();
        reqBo.getSaleItemList().forEach(itemBo -> {
            if(itemBo.getAdjustPrice()!=null){
                UocChngOrderItemObj uocChngOrderItemObj = new UocChngOrderItemObj();
                uocChngOrderItemObj.setOrderId(reqBo.getOrderId());
                uocChngOrderItemObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
                uocChngOrderItemObj.setChngOrderObjId(uocChngOrderObj.getChngOrderObjId());
                uocChngOrderItemObj.setId(IdUtil.nextId());
                uocChngOrderItemObj.setOrderItemId(itemBo.getOrderItemId());
                uocChngOrderItemObj.setSaleOrderItemId(itemBo.getSaleOrderItemId());
                uocChngOrderItemObj.setChngType(UocConstant.BUSI_TYPE.PRICE_CHG);
                uocChngOrderItemObj.setChngFee(itemBo.getAdjustPrice());
                uocChngOrderItemObj.setCreateOperId(reqBo.getUserId().toString());
                uocChngOrderItemObj.setCreateTime(newDate);
                uocChngOrderItemObjList.add(uocChngOrderItemObj);
            }
            if(itemBo.getAdjustPurchasePrice()!=null){
                UocChngOrderItemObj uocChngOrderItemObj = new UocChngOrderItemObj();
                uocChngOrderItemObj.setOrderId(reqBo.getOrderId());
                uocChngOrderItemObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
                uocChngOrderItemObj.setChngOrderObjId(uocChngOrderObj.getChngOrderObjId());
                uocChngOrderItemObj.setId(IdUtil.nextId());
                uocChngOrderItemObj.setOrderItemId(itemBo.getOrderItemId());
                uocChngOrderItemObj.setSaleOrderItemId(itemBo.getSaleOrderItemId());
                uocChngOrderItemObj.setChngType(UocStateConstants.ChngOrder.CHNG_TYPE.PURCHASE_PRICE_CHNG);
                uocChngOrderItemObj.setChngFee(itemBo.getAdjustPurchasePrice());
                uocChngOrderItemObj.setCreateOperId(reqBo.getUserId().toString());
                uocChngOrderItemObj.setCreateTime(newDate);
                uocChngOrderItemObjList.add(uocChngOrderItemObj);
            }

        });
        uocChngOrderObj.setUocChngOrderItemObjList(uocChngOrderItemObjList);
        uocChngOrderDo.setUocChngOrderObjList(uocChngOrderObjList);
        // 设置附件信息
        if (!CollectionUtils.isEmpty(reqBo.getOrderAccessoryBoList())) {
            List<UocOrderAccessory> orderAccessoryBoList = UocRu.jsl(reqBo.getOrderAccessoryBoList(), UocOrderAccessory.class);
            orderAccessoryBoList.forEach(uocOrderAccessory -> {
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setCreateTime(newDate);
                uocOrderAccessory.setObjId(uocChngOrderDo.getChngOrderId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
                uocOrderAccessory.setAttachmentType(UocDicConstant.OBJ_TYPE.CHNG);
            });
            uocChngOrderDo.setOrderAccessoryBoList(orderAccessoryBoList);
        }
        // 设置扩展信息
        if(!CollectionUtils.isEmpty(reqBo.getExtParallelBoList())){
            List<UocChngOrderMap> uocChngOrderMapList = UocRu.jsl(reqBo.getExtParallelBoList(), UocChngOrderMap.class);
            uocChngOrderMapList.forEach(uocChngOrderMap -> {
                uocChngOrderMap.setOrderId(reqBo.getOrderId());
                uocChngOrderMap.setChngOrderId(uocChngOrderDo.getChngOrderId());
                uocChngOrderMap.setId(IdUtil.nextId());
                uocChngOrderMap.setCreateOperId(reqBo.getUserId().toString());
                uocChngOrderMap.setCreateTime(newDate);
            });
            uocChngOrderDo.setUocChngOrderMapList(uocChngOrderMapList);
        }
        return uocChngOrderDo;
    }
    /**
     * 入参校验
     */
    private void validateArg(UocAdjustPriceOrderCreateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID为空");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID为空");
        }
        if (null == reqBo.getTaskId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参任务ID为空");
        }
        if(CollectionUtils.isEmpty(reqBo.getSaleItemList())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参调价信息为空");
        }
        reqBo.getSaleItemList().forEach(uocAdjustPriceOrderCreateReqItemBo -> {
            if(uocAdjustPriceOrderCreateReqItemBo.getOrderItemId()==null){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单明细ID为空");
            }
            if(uocAdjustPriceOrderCreateReqItemBo.getSaleOrderItemId()==null){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售明细ID为空");
            }
            if(uocAdjustPriceOrderCreateReqItemBo.getAdjustPrice()==null){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参调价后金额为空");
            }
        });
    }
}
