package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.config.UocInitConfig;
import com.tydic.dyc.oc.constants.UocAttachementTypeConstants;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderRefuseReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderRefuseRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocSaleOrderRefuseServiceImpl
 * 说明:销售单接单/拒单
 * 时间:2022/2/25 10:33
 * 作者:罗有
 */

@HTServiceImpl
public class UocSaleOrderRefuseServiceImpl implements UocSaleOrderRefuseService {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Autowired
    private UocInitConfig uocInitConfig;

    private static final Integer OP_FLAG_CONFIRM = 1;
    private static final Integer OP_FLAG_REFUSE = 0;

    @Override
    public UocSaleOrderRefuseRspBo dealSaleOrderRefuse(UocSaleOrderRefuseReqBo reqBo) {
        //参数校验
        validateArg(reqBo);
        Date now = new Date();
        UocSaleOrderDo convertSaleOrderDo = convertSaleOrderDo(reqBo, now);
        if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
            //更新销售单明细接单日期
            updateSaleOrderItems(convertSaleOrderDo, now);
        }
        //更新销售单主体
        iUocSaleOrderModel.modifySaleOrderMain(convertSaleOrderDo);
        //保存附件
        if (ObjectUtil.isNotEmpty(reqBo.getOrderAccessoryBoList())) {
            iUocOrderModel.createOrderAccessory(convertSaleOrderAccessory(reqBo, now));
        }
        //处理扩展
        dealMap(reqBo, now);
        // 提交任务
        commitTask(reqBo);
        return UocRu.success(UocSaleOrderRefuseRspBo.class);
    }

    private void updateSaleOrderItems(UocSaleOrderDo convertSaleOrderDo, Date now) {
        UocSaleOrderItemQryBo itemQryBo = new UocSaleOrderItemQryBo();
        itemQryBo.setOrderId(convertSaleOrderDo.getOrderId());
        itemQryBo.setSaleOrderId(convertSaleOrderDo.getSaleOrderId());
        UocSaleOrderDo listSaleOrderItem = iUocSaleOrderModel.getListSaleOrderItem(itemQryBo);
        if (ObjectUtil.isNotEmpty(listSaleOrderItem.getSaleOrderItems())) {
            listSaleOrderItem.getSaleOrderItems().forEach(each -> {
                each.setArrivalTime(DateUtils.dateToStr(now, "yyyy-MM-dd HH:mm:ss"));
            });
            convertSaleOrderDo.setSaleOrderItems(listSaleOrderItem.getSaleOrderItems());
            iUocSaleOrderModel.modifyBatchItemArrivalTime(convertSaleOrderDo);
        }
    }

    private void commitTask(UocSaleOrderRefuseReqBo reqBo) {
        UocCommonDo uocCommonDo = new UocCommonDo();
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        taskBo.setTaskId(reqBo.getTaskId());
        taskBos.add(taskBo);
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(reqBo.getUserId());
        uocCommonDo.setOrderId(reqBo.getOrderId());
        iUocCommonModel.dealTask(uocCommonDo);
    }

    private List<UocOrderAccessory> convertSaleOrderAccessory(UocSaleOrderRefuseReqBo reqBo, Date now) {
        List<UocOrderAccessory> uocOrderAccessoryList = UocRu.jsl(reqBo.getOrderAccessoryBoList(), UocOrderAccessory.class);
        uocOrderAccessoryList.forEach(each -> {
            each.setId(IdUtil.nextId());
            each.setObjId(reqBo.getSaleOrderId());
            each.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            each.setAttachmentType(UocAttachementTypeConstants.SALE_ORDER_REJECT);
            each.setOrderId(reqBo.getOrderId());
            each.setCreateTime(now);
            each.setCreateOperId(reqBo.getUserId().toString());
        });
        return uocOrderAccessoryList;
    }

    private UocSaleOrderDo convertSaleOrderDo(UocSaleOrderRefuseReqBo reqBo, Date now) {
        UocSaleOrderDo uocSaleOrderDo = UocRu.js(reqBo, UocSaleOrderDo.class);
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
//        uocSaleOrderDo.setProcState(reqBo.getTacheCode());
//        uocSaleOrderDo.setSaleOrderState(uocInitConfig.getStateByTachecode(reqBo.getTacheCode()));
        if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            uocSaleOrderDo.setRejectReason(reqBo.getRejectReason());
            uocSaleOrderDo.setRejectTime(ObjectUtil.isNotEmpty(reqBo.getRejectTime()) ? reqBo.getRejectTime() : now);
            uocSaleOrderDo.setRejectOperName(reqBo.getUsername());
            uocSaleOrderDo.setRejectOperId(String.valueOf(reqBo.getUserId()));
        }
        return uocSaleOrderDo;
    }

    /**
     * 扩展属性处理
     */
    private void dealMap(UocSaleOrderRefuseReqBo reqBo, Date now) {
        if (!CollectionUtils.isEmpty(reqBo.getExtDeleteList())) {
            UocSaleOrderDo delSaleOrderDo = new UocSaleOrderDo();
            List<UocSaleOrderMap> extParallelBoList = new ArrayList<>();
            reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                UocSaleOrderMap uocSaleOrderMap = new UocSaleOrderMap();
                uocSaleOrderMap.setOrderId(reqBo.getOrderId());
                uocSaleOrderMap.setSaleOrderId(uocBaseExtParallelDeleteBo.getObjId());
                uocSaleOrderMap.setFieldCode(uocBaseExtParallelDeleteBo.getFieldCode());
                uocSaleOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                uocSaleOrderMap.setUpdateTime(now);
                extParallelBoList.add(uocSaleOrderMap);
            });
            delSaleOrderDo.setSaleOrderMapList(extParallelBoList);
            iUocSaleOrderModel.updateInvalid(delSaleOrderDo);
        }
        if (!CollectionUtils.isEmpty(reqBo.getExtEditList())) {
            UocSaleOrderDo add = new UocSaleOrderDo();
            UocSaleOrderDo modify = new UocSaleOrderDo();
            List<UocSaleOrderMap> addList = new ArrayList<>();
            List<UocSaleOrderMap> modifyList = new ArrayList<>();
            reqBo.getExtEditList().forEach(uocBaseExtParallelEditBo -> {
                if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelEditBo.getOpFlag())) {
                    UocSaleOrderMap addShipOrderMap = new UocSaleOrderMap();
                    addShipOrderMap.setSaleOrderId(uocBaseExtParallelEditBo.getObjId());
                    addShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                    addShipOrderMap.setFieldName(uocBaseExtParallelEditBo.getFieldName());
                    addShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                    addShipOrderMap.setOrderId(reqBo.getOrderId());
                    addShipOrderMap.setId(IdUtil.nextId());
                    addShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
                    addShipOrderMap.setCreateTime(now);
                    addList.add(addShipOrderMap);
                } else {
                    UocSaleOrderMap updateShipOrderMap = new UocSaleOrderMap();
                    updateShipOrderMap.setSaleOrderId(uocBaseExtParallelEditBo.getObjId());
                    updateShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                    updateShipOrderMap.setOrderId(reqBo.getOrderId());
                    updateShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                    updateShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                    updateShipOrderMap.setUpdateTime(now);
                    modifyList.add(updateShipOrderMap);
                }
            });
            if (!CollectionUtils.isEmpty(addList)) {
                add.setSaleOrderMapList(addList);
                iUocSaleOrderModel.addSaleOrderMap(add);
            }
            if (!CollectionUtils.isEmpty(modifyList)) {
                modify.setSaleOrderMapList(modifyList);
                iUocSaleOrderModel.updateBatchValue(modify);
            }
        }
    }

    private void validateArg(UocSaleOrderRefuseReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == reqBo.getOpFlag()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参操作类型不能为空");
        }
        if (!OP_FLAG_REFUSE.equals(reqBo.getOpFlag()) && !OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "操作只能是接单或拒单");
        }

        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID不能为空");
        }

//        if (ObjectUtil.isEmpty(reqBo.getTacheCode())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[环节编码]不能为空");
//        }

        if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag()) && StringUtils.isBlank(reqBo.getRejectReason())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "拒单时，拒单原因不能为空");
        }

        if (!CollectionUtils.isEmpty(reqBo.getExtDeleteList())) {
            reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性对象ID不能为空");
                }
                if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性编码不能为空");
                }
            });
        }
        if (!CollectionUtils.isEmpty(reqBo.getExtEditList())) {
            reqBo.getExtEditList().forEach(uocBaseExtParallelDeleteBo -> {
                if (null == uocBaseExtParallelDeleteBo.getOpFlag()) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型不能为空");
                }
                if (!UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag()) && !UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型仅支持新增和修改");
                }
                if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，对象ID不能为空");
                    }
                    if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，属性编码不能为空");
                    }
                }
                if (UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，对象ID不能为空");
                    }
                    if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性编码不能为空");
                    }
                    if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldValue())) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性值不能为空");
                    }
                }
            });
        }
    }
}
