/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocDMsgPoolQryBo;
import com.tydic.dyc.oc.service.domainservice.UocQryMsgService;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryMsgReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryMsgRspBo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocQryMsgService"})
public class UocQryMsgServiceImpl
implements UocQryMsgService {
    private static final Logger log = LoggerFactory.getLogger(UocQryMsgServiceImpl.class);
    public static final Integer MAX_FAILURE_COUNT = 5;
    private static final Integer QRY_EXCEPT_VOTE_MSGS = 1;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private Environment environment;

    @PostMapping(value={"qryMsg"})
    public BasePageRspBo<UocQryMsgRspBo> qryMsg(@RequestBody UocQryMsgReqBo reqBo) {
        log.info("\u5b9a\u65f6\u4efb\u52a1\u5904\u7406\u6d88\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBo));
        BasePageRspBo rspBo = new BasePageRspBo();
        this.validataArg(reqBo);
        List<Object> uocQryMsgRspBoList = new ArrayList();
        if (QRY_EXCEPT_VOTE_MSGS.equals(reqBo.getQryType())) {
            List<UocDMsgPoolQryBo> uocDMsgPoolQryBoList;
            UocDMsgPoolQryBo uocDMsgPoolQryBo = new UocDMsgPoolQryBo();
            uocDMsgPoolQryBo.setRunResultList(reqBo.getRunResult());
            uocDMsgPoolQryBo.setFailureCount(5);
            uocDMsgPoolQryBo.setSupNo(reqBo.getSupNo());
            if (reqBo.getMsgId() != null) {
                uocDMsgPoolQryBo.setId(reqBo.getMsgId());
            }
            if (ObjectUtil.isNotEmpty(uocDMsgPoolQryBoList = this.iUocOrderModel.getListByRunResultAndFailureCount(uocDMsgPoolQryBo))) {
                uocQryMsgRspBoList = uocDMsgPoolQryBoList.stream().map(e -> {
                    UocQryMsgRspBo uocQryMsgRspBo = (UocQryMsgRspBo)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UocQryMsgRspBo.class);
                    return uocQryMsgRspBo;
                }).collect(Collectors.toList());
            }
            rspBo.setRecordsTotal(uocDMsgPoolQryBoList.size());
            rspBo.setRows(uocQryMsgRspBoList);
        } else {
            List<UocDMsgPoolQryBo> uocDMsgPoolQryBoList;
            ArrayList<Integer> objTypeList = new ArrayList<Integer>();
            objTypeList.add(3);
            UocDMsgPoolQryBo uocDMsgPoolQryBo = new UocDMsgPoolQryBo();
            uocDMsgPoolQryBo.setRunResultList(reqBo.getRunResult());
            uocDMsgPoolQryBo.setObjTypeList(objTypeList);
            uocDMsgPoolQryBo.setSupNo(reqBo.getSupNo());
            if (reqBo.getMsgId() != null) {
                uocDMsgPoolQryBo.setId(reqBo.getMsgId());
            }
            if (ObjectUtil.isNotEmpty(uocDMsgPoolQryBoList = this.iUocOrderModel.getVoteMsgList(uocDMsgPoolQryBo))) {
                uocQryMsgRspBoList = uocDMsgPoolQryBoList.stream().map(e -> {
                    UocQryMsgRspBo uocQryMsgRspBo = (UocQryMsgRspBo)JSONObject.parseObject((String)JSON.toJSONString((Object)e), UocQryMsgRspBo.class);
                    return uocQryMsgRspBo;
                }).collect(Collectors.toList());
            }
            rspBo.setRecordsTotal(uocDMsgPoolQryBoList.size());
            rspBo.setRows(uocQryMsgRspBoList);
        }
        return rspBo;
    }

    public void validataArg(UocQryMsgReqBo reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getRunResult())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u6267\u884c\u72b6\u6001[runResult]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

