/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.service.order.UocGetQueryOutOrderService;
import com.tydic.dyc.oc.service.order.bo.UocGetQueryOutOrderServiceReqBo;
import com.tydic.dyc.oc.service.order.bo.UocGetQueryOutOrderServiceRspBo;
import com.tydic.dyc.oc.service.order.bo.UocQryOutOrderIndexBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.order.UocGetQueryOutOrderService"})
public class UocGetQueryOutOrderServiceImpl
implements UocGetQueryOutOrderService {
    private static final Logger log = LoggerFactory.getLogger(UocGetQueryOutOrderServiceImpl.class);
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @PostMapping(value={"qryOrderQueryIndexList"})
    public UocGetQueryOutOrderServiceRspBo qryOrderQueryIndexList(@RequestBody UocGetQueryOutOrderServiceReqBo reqBo) {
        UocGetQueryOutOrderServiceRspBo rspBo = new UocGetQueryOutOrderServiceRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        List<UocOrderTaskInst> allTasKIns = this.getAllTastIns(reqBo.getOrderId());
        List procStateList = allTasKIns.stream().map(UocOrderTaskInst::getProcState).collect(Collectors.toList());
        if (procStateList.contains("E0006") || procStateList.contains("A0009")) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u8be5\u8ba2\u5355\u5b58\u5728\u4e0d\u80fd\u53d6\u6d88\u7684\u9500\u552e\u5355\uff01");
        }
        UocOrderQueryIndexQryBo queryIndexQryBo = new UocOrderQueryIndexQryBo();
        queryIndexQryBo.setOrderId(reqBo.getOrderId());
        queryIndexQryBo.setObjType(reqBo.getObjType());
        queryIndexQryBo.setObjId(reqBo.getObjId());
        List<UocOrderQueryIndex> uocOrderQueryIndexList = this.iUocOrderModel.qryOrderQueryIndexList(queryIndexQryBo);
        List<UocQryOutOrderIndexBo> uocQryOutOrderIndexBoList = UocRu.jsl(uocOrderQueryIndexList, UocQryOutOrderIndexBo.class);
        for (UocQryOutOrderIndexBo uocOrderQueryIndex : uocQryOutOrderIndexBoList) {
            List<Object> supNoList = new ArrayList();
            UocOrderStakeholderQryBo uocOrderStakeholderQryBo = new UocOrderStakeholderQryBo();
            uocOrderStakeholderQryBo.setOrderId(uocOrderQueryIndex.getOrderId());
            List<UocOrderStakeholderQryBo> uocOrderStakeholderQryBoList = this.iUocOrderModel.qryStakeholderList(uocOrderStakeholderQryBo);
            supNoList = uocOrderStakeholderQryBoList.stream().map(e -> e.getSupId()).collect(Collectors.toList());
            uocOrderQueryIndex.setSupNoList(supNoList);
        }
        rspBo.setUocOrderQueryIndexList(uocQryOutOrderIndexBoList);
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setOrderId(reqBo.getOrderId());
        uocOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
        uocOrderTaskInst.setObjId(reqBo.getOrderId());
        uocOrderTaskInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
        if (!CollectionUtils.isEmpty(uocOrderTaskInsts)) {
            if (uocOrderTaskInsts.size() != 1) {
                throw new BaseBusinessException("101016", "\u67e5\u8be2\u4ee3\u529e\u4efb\u52a1\u6709\u591a\u6761\uff01");
            }
            if ("W001".equals(uocOrderTaskInsts.get(0).getProcState())) {
                UocOrderDo selectDo = new UocOrderDo();
                selectDo.setOrderId(reqBo.getOrderId());
                UocOrderDo resultDo = this.iUocOrderModel.qryOrderBy(selectDo);
                if (null == resultDo) {
                    throw new BaseBusinessException("100100", "\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
                }
                rspBo.setOaAuditFlag(resultDo.getExtField1());
            }
        }
        return rspBo;
    }

    private List<UocOrderTaskInst> getAllTastIns(Long orderId) {
        UocOrderTaskInstQryBo uocOrderTaskInstQryBo = new UocOrderTaskInstQryBo();
        uocOrderTaskInstQryBo.setOrderId(orderId);
        return this.iUocOrderModel.qryOrderTaskInstList(uocOrderTaskInstQryBo);
    }
}

