/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.event.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventConsumerShipCreate
implements EventConsumer {
    private static final Logger log = LoggerFactory.getLogger(EventConsumerShipCreate.class);
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerShipCreate->{}", (Object)JSON.toJSONString(map));
        ArrayList<IUocEsSyncQryEventReqBo> retList = new ArrayList<IUocEsSyncQryEventReqBo>();
        Long orderId = UocRu.parseLong(map.get("orderId"));
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(orderId);
        List<UocShipOrderDo> shipOrderDoList = this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        for (UocShipOrderDo shipOrderDo : shipOrderDoList) {
            orderId = shipOrderDo.getOrderId();
            Long saleOrderId = shipOrderDo.getSaleOrderId();
            Long shipOrderId = shipOrderDo.getShipOrderId();
            ArrayList<IUocEsSyncQryReqBo> saleList = new ArrayList<IUocEsSyncQryReqBo>();
            IUocEsSyncQryReqBo sale = new IUocEsSyncQryReqBo();
            sale.setOrderId(orderId);
            sale.setObjId(saleOrderId);
            saleList.add(sale);
            IUocEsSyncQryEventReqBo saleEventReqBo = new IUocEsSyncQryEventReqBo();
            saleEventReqBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
            saleEventReqBo.setDataList(saleList);
            retList.add(saleEventReqBo);
            ArrayList<IUocEsSyncQryReqBo> shipList = new ArrayList<IUocEsSyncQryReqBo>();
            IUocEsSyncQryReqBo ship = new IUocEsSyncQryReqBo();
            ship.setOrderId(orderId);
            ship.setObjId(shipOrderId);
            shipList.add(ship);
            IUocEsSyncQryEventReqBo shipEventReqBo = new IUocEsSyncQryEventReqBo();
            shipEventReqBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
            shipEventReqBo.setDataList(shipList);
            retList.add(shipEventReqBo);
        }
        return retList;
    }

    @Override
    public String getEvent() {
        return "UOCE_CREATE_SHIP";
    }
}

