/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.model.shiporder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.sub.UocOrderStateChgLog;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.repository.UocShipOrderRepository;
import com.tydic.dyc.oc.utils.IdUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocShipOrderModelImpl
implements IUocShipOrderModel {
    @Autowired
    private UocShipOrderRepository uocShipOrderRepository;
    @Autowired
    private UocCommonRepository uocCommonRepository;

    @Override
    public void createShipOrder(UocShipOrderDo uocShipOrderDo) {
        this.valDo(uocShipOrderDo);
        this.uocShipOrderRepository.createShipOrder(uocShipOrderDo);
        this.uocCommonRepository.addBatchOrderAccessory(uocShipOrderDo.getOrderAccessoryBoList());
    }

    @Override
    public void arrivaConfirm(UocShipOrderDo uocShipOrderDo) {
        this.valDo(uocShipOrderDo);
        if (null == uocShipOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(StringUtils.isBlank((CharSequence)uocShipOrderDo.getReceiverUser()) && StringUtils.isBlank((CharSequence)uocShipOrderDo.getReceiverRemark()) && StringUtils.isBlank((CharSequence)uocShipOrderDo.getReceiverContact()) && null == uocShipOrderDo.getReceiverTime())) {
            this.uocShipOrderRepository.modifyBatchShipOrderArrivaRefuse(uocShipOrderDo);
        }
        this.uocShipOrderRepository.modifyArrivaShipOrderItem(uocShipOrderDo);
        this.uocCommonRepository.addBatchOrderAccessory(uocShipOrderDo.getOrderAccessoryBoList());
    }

    @Override
    public void arrivaRefuse(UocShipOrderDo uocShipOrderDo) {
        this.valDo(uocShipOrderDo);
        if (null == uocShipOrderDo.getSaleOrderId()) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(StringUtils.isBlank((CharSequence)uocShipOrderDo.getReceiverUser()) && StringUtils.isBlank((CharSequence)uocShipOrderDo.getReceiverRemark()) && StringUtils.isBlank((CharSequence)uocShipOrderDo.getReceiverContact()) && null == uocShipOrderDo.getReceiverTime())) {
            this.uocShipOrderRepository.modifyBatchShipOrderArrivaRefuse(uocShipOrderDo);
        }
        this.uocShipOrderRepository.modifyRefuseShipOrderItem(uocShipOrderDo);
        this.uocCommonRepository.addBatchOrderAccessory(uocShipOrderDo.getOrderAccessoryBoList());
    }

    @Override
    public UocShipOrderDo getListShipOrderItem(UocShipOrderItemQryBo uocShipOrderItemQryBo) {
        if (null == uocShipOrderItemQryBo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocShipOrderRepository.getListShipOrderItem(uocShipOrderItemQryBo);
    }

    @Override
    public void modifyShipOrderMain(UocShipOrderDo uocShipOrderDo) {
        this.valDo(uocShipOrderDo);
        this.uocShipOrderRepository.modifyShipOrderMain(uocShipOrderDo);
        this.uocCommonRepository.addBatchOrderAccessory(uocShipOrderDo.getOrderAccessoryBoList());
    }

    @Override
    public void modifyShipOrderItemInspCount(UocShipOrderDo uocShipOrderDo) {
        this.valDo(uocShipOrderDo);
        if (CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
            throw new BaseBusinessException("102001", "\u53d1\u8d27\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        uocShipOrderDo.getShipOrderItemBoList().forEach(uocShipOrderItem -> {
            if (null == uocShipOrderItem.getShipOrderItemId()) {
                throw new BaseBusinessException("102001", "\u53d1\u8d27\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == uocShipOrderItem.getInspCount()) {
                throw new BaseBusinessException("102001", "\u53d1\u8d27\u660e\u7ec6\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        this.uocShipOrderRepository.modifyBatchShipOrderItemInspCount(uocShipOrderDo);
    }

    @Override
    public UocShipOrderDo getShipOrderById(UocShipOrderQryBo uocShipOrderQryBo) {
        if (null == uocShipOrderQryBo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocShipOrderQryBo.getOrderId()) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocShipOrderRepository.getShipOrderById(uocShipOrderQryBo);
    }

    @Override
    public List<UocShipOrderDo> getListShipOrder(UocShipOrderQryBo uocShipOrderQryBo) {
        if (null == uocShipOrderQryBo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocShipOrderQryBo.getOrderId()) {
            return new ArrayList<UocShipOrderDo>();
        }
        return this.uocShipOrderRepository.getListShipOrder(uocShipOrderQryBo);
    }

    @Override
    public UocShipOrderDo getShipOrderNo(UocShipOrderDo uocShipOrderDo) {
        if (null == uocShipOrderDo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocShipOrderDo.getOrderSource()) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String orderNo = this.uocCommonRepository.getOrderNoSingle("ORDER_SHIP_NO_" + uocShipOrderDo.getOrderSource());
        uocShipOrderDo.setShipOrderNo(orderNo);
        return uocShipOrderDo;
    }

    @Override
    public void modifyShipOrderItemChngingCount(UocShipOrderDo uocShipOrderDo) {
        this.valDo(uocShipOrderDo);
        if (CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
            throw new BaseBusinessException("102001", "\u53d1\u8d27\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        uocShipOrderDo.getShipOrderItemBoList().forEach(uocShipOrderItem -> {
            if (null == uocShipOrderItem.getShipOrderItemId()) {
                throw new BaseBusinessException("102001", "\u53d1\u8d27\u660e\u7ec6ID\u4e3a\u7a7a");
            }
            if (null == uocShipOrderItem.getChngingCount()) {
                throw new BaseBusinessException("100001", "\u53d8\u66f4\u6570\u91cf\u5728\u9014\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        this.uocShipOrderRepository.modifyShipOrderItemChngingCount(uocShipOrderDo);
    }

    @Override
    public void modifyItemReturnCountConfirm(UocShipOrderDo uocShipOrderDo) {
        if (null == uocShipOrderDo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(uocShipOrderDo.getOrderIdList())) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u8ba2\u5355id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemIdList())) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u53d1\u8d27\u660e\u7ec6\u5355id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.uocShipOrderRepository.modifyItemReturnCountConfirm(uocShipOrderDo);
    }

    @Override
    public void modifyItemChngCountRefuse(UocShipOrderDo uocShipOrderDo) {
        if (null == uocShipOrderDo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemIdList())) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u53d1\u8d27\u660e\u7ec6id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(uocShipOrderDo.getOrderIdList())) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.uocShipOrderRepository.modifyItemChngCountRefuse(uocShipOrderDo);
    }

    @Override
    public void updateShipStatusAndProCode(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderQryBo qryBo = new UocShipOrderQryBo();
        qryBo.setOrderId(uocShipOrderDo.getOrderId());
        qryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        UocShipOrderDo shipOrderDo = this.getShipOrderById(qryBo);
        if (ObjectUtil.isEmpty((Object)shipOrderDo)) {
            throw new BaseBusinessException("102002", "\u8be5\u53d1\u8d27\u5355" + uocShipOrderDo.getShipOrderId() + "\u4e0d\u5b58\u5728");
        }
        UocOrderStateChgLog uocOrderStateChgLog = new UocOrderStateChgLog();
        uocOrderStateChgLog.setId(IdUtil.nextId());
        uocOrderStateChgLog.setObjId(uocShipOrderDo.getShipOrderId());
        uocOrderStateChgLog.setOrderId(uocShipOrderDo.getOrderId());
        uocOrderStateChgLog.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        uocOrderStateChgLog.setOldState(shipOrderDo.getShipOrderState());
        uocOrderStateChgLog.setNewState(uocShipOrderDo.getShipOrderState());
        uocOrderStateChgLog.setChgTime(new Date());
        uocOrderStateChgLog.setOperId(uocShipOrderDo.getUpdateOperId());
        this.uocCommonRepository.createOrderStateChangeLog(uocOrderStateChgLog);
        this.uocShipOrderRepository.updateShipStatusAndProCode(uocShipOrderDo);
    }

    @Override
    public void addShipOrderMap(UocShipOrderDo uocShipOrderDo) {
        this.valDo(uocShipOrderDo);
        this.uocShipOrderRepository.addShipOrderMap(uocShipOrderDo);
    }

    @Override
    public void updateBatchValue(UocShipOrderDo uocShipOrderDo) {
        this.valDo(uocShipOrderDo);
        this.uocShipOrderRepository.updateBatchValue(uocShipOrderDo);
    }

    @Override
    public void updateInvalid(UocShipOrderDo uocShipOrderDo) {
        this.valDo(uocShipOrderDo);
        this.uocShipOrderRepository.updateInvalid(uocShipOrderDo);
    }

    @Override
    public void modifyShipOrderItemInspCountEqualArrivalCount(UocShipOrderDo uocShipOrderDo) {
        this.uocShipOrderRepository.modifyShipOrderItemInspCountEqualArrivalCount(uocShipOrderDo);
    }

    private void valDo(UocShipOrderDo uocShipOrderDo) {
        if (null == uocShipOrderDo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocShipOrderDo.getOrderId()) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public void modifyItemArriveCountConfirm(UocShipOrderDo uocShipOrderDo) {
        this.uocShipOrderRepository.modifyItemArriveCountConfirm(uocShipOrderDo);
    }

    @Override
    public void modifyItemRefuseCountConfirm(UocShipOrderDo uocShipOrderDo) {
        this.uocShipOrderRepository.modifyItemRefuseCountConfirm(uocShipOrderDo);
    }

    @Override
    public void modifyShipArrivtime(UocShipOrderDo uocShipOrderDo) {
        this.uocShipOrderRepository.modifyShipArrivtime(uocShipOrderDo);
    }

    @Override
    public void modifyItemArriveCount(UocShipOrderDo uocShipOrderDo) {
        this.uocShipOrderRepository.modifyItemArriveCount(uocShipOrderDo);
    }

    @Override
    public void modifyShipOrderStatus(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderDo uocShipOrderDo1 = new UocShipOrderDo();
        uocShipOrderDo1.setOrderId(uocShipOrderDo.getOrderId());
        uocShipOrderDo1.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        uocShipOrderDo1.setShipOrderId(uocShipOrderDo.getShipOrderId());
        this.uocShipOrderRepository.modifyShipStatus(uocShipOrderDo1);
    }

    @Override
    public void modifyStatChngShipStatus(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderDo uocShipOrderDo1 = new UocShipOrderDo();
        uocShipOrderDo1.setOrderId(uocShipOrderDo.getOrderId());
        uocShipOrderDo1.setShipOrderId(uocShipOrderDo.getShipOrderId());
        this.uocShipOrderRepository.modifyStatChngShipStatus(uocShipOrderDo1);
    }

    @Override
    public void modifyShipOrderItemAfterServingCount(UocShipOrderItem uocShipOrderItem) {
        this.uocShipOrderRepository.modifyShipOrderItemAfterServingCount(uocShipOrderItem);
    }

    @Override
    public List<UocShipOrderItem> getShipOrderItemList(UocShipOrderItemQryBo uocShipOrderItemQryBo) {
        return this.uocShipOrderRepository.getShipOrderItem(uocShipOrderItemQryBo);
    }

    @Override
    public void modifyShipOrderItemReturningCount(UocShipOrderItem uocShipOrderItem) {
        this.uocShipOrderRepository.modifyShipOrderItemReturningCount(uocShipOrderItem);
    }
}

