/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.ordSourceProcessor.UocOrderSourceProcessor;
import com.tydic.dyc.oc.components.ordSourceProcessor.UocOrderSourceProcessorManager;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.service.domainservice.UocCreateOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqArgPayConfSupBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqPayConfBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspSaleOrderBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspSaleOrderItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSupplierInfoBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocCreateOrderService"})
public class UocCreateOrderServiceImpl
implements UocCreateOrderService {
    private static final Logger log = LoggerFactory.getLogger(UocCreateOrderServiceImpl.class);
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private UocOrderSourceProcessorManager uocOrderSourceProcessorManager;

    @PostMapping(value={"createOrder"})
    public UocCreateOrderServiceRspBo createOrder(@RequestBody UocCreateOrderServiceReqBo reqBo) {
        UocOrderDo createOrderDo = (UocOrderDo)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)reqBo), UocOrderDo.class));
        createOrderDo.setCreateOperId(String.valueOf(reqBo.getUserId()));
        createOrderDo.setCreateOperName(reqBo.getName());
        createOrderDo.setCreateTime(new Date());
        UocOrderDo orderResult = this.iUocOrderModel.createOrder(createOrderDo);
        List saleOrderItemList = JSONArray.parseArray((String)JSON.toJSONString((Object)reqBo.getOrderItems())).toJavaList(UocSaleOrderItem.class);
        List<UocSaleOrderDo> createSaleOrderList = this.splitSaleOrderNew(reqBo, orderResult, saleOrderItemList);
        ArrayList<UocCreateOrderServiceRspSaleOrderBo> saleOrderResultList = new ArrayList<UocCreateOrderServiceRspSaleOrderBo>();
        for (UocSaleOrderDo saleOrderDo : createSaleOrderList) {
            UocSaleOrderDo saleOrder = this.iUocSaleOrderModel.createSaleOrder(saleOrderDo);
            UocCreateOrderServiceRspSaleOrderBo orderItemRspData = new UocCreateOrderServiceRspSaleOrderBo();
            BeanUtils.copyProperties((Object)saleOrder, (Object)orderItemRspData);
            BeanUtils.copyProperties((Object)saleOrder.getStakeholder(), (Object)orderItemRspData);
            orderItemRspData.setSaleOrderId(saleOrder.getSaleOrderId());
            List<UocCreateOrderServiceRspSaleOrderItemBo> itemList = UocRu.jsl(saleOrder.getSaleOrderItems(), UocCreateOrderServiceRspSaleOrderItemBo.class);
            orderItemRspData.setItemBoList(itemList);
            orderItemRspData.setSaleOrderNo(saleOrder.getSaleOrderNo());
            orderItemRspData.setOrderSource(saleOrder.getOrderSource());
            orderItemRspData.setAgrId(saleOrder.getAgreementId());
            orderItemRspData.setPayType(saleOrder.getPayType() != null ? Integer.valueOf(saleOrder.getPayType()) : null);
            saleOrderResultList.add(orderItemRspData);
        }
        UocCreateOrderServiceRspBo rspBo = UocRu.success(UocCreateOrderServiceRspBo.class);
        rspBo.setTotalSaleFee(orderResult.getTotalSaleFee());
        rspBo.setTotalPurchaseFee(orderResult.getTotalPurchaseFee());
        rspBo.setOrderId(orderResult.getOrderId());
        rspBo.setOrderNo(orderResult.getOrderNo());
        rspBo.setSaleOrderList(saleOrderResultList);
        return rspBo;
    }

    private List<UocSaleOrderDo> splitSaleOrderNew(UocCreateOrderServiceReqBo reqBo, UocOrderDo orderInfo, List<UocSaleOrderItem> saleOrderItemList) {
        ArrayList<UocSaleOrderDo> saleOrderList = new ArrayList<UocSaleOrderDo>();
        ArrayList<List<UocSaleOrderItem>> splitSaleOrderResultList = new ArrayList<List<UocSaleOrderItem>>();
        Map<Integer, List<UocSaleOrderItem>> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getSkuSource));
        for (Map.Entry<Integer, List<UocSaleOrderItem>> entry : saleOrderItemMap.entrySet()) {
            UocOrderSourceProcessor instance = this.uocOrderSourceProcessorManager.getInstance(entry.getKey());
            splitSaleOrderResultList.addAll(instance.splitSaleOrder(entry.getValue()));
        }
        List supplierInfoList = reqBo.getSupplierBos();
        Map<Object, Object> supplierInfoMap = new HashMap();
        if (ObjectUtil.isNotEmpty((Object)supplierInfoList)) {
            supplierInfoMap = supplierInfoList.stream().collect(Collectors.toMap(UocSupplierInfoBo::getSupplierId, item -> item));
        }
        List agrPayConfigList = reqBo.getAgrPayConfigList();
        Map<Object, Object> agrPayConfigMap = new HashMap();
        if (ObjectUtil.isNotEmpty((Object)agrPayConfigList)) {
            agrPayConfigMap = agrPayConfigList.stream().collect(Collectors.toMap(UocCreateOrderServiceReqArgPayConfSupBo::getAgrId, item -> item));
        }
        UocOrderStakeholderQryBo uocOrderStakeholderQryBo = new UocOrderStakeholderQryBo();
        uocOrderStakeholderQryBo.setOrderId(orderInfo.getOrderId());
        List<UocOrderStakeholderQryBo> orderStakeholderList = this.iUocOrderModel.qryStakeholderList(uocOrderStakeholderQryBo);
        Map<String, List<UocOrderStakeholderQryBo>> orderStakeholderMap = orderStakeholderList.stream().collect(Collectors.groupingBy(UocOrderStakeholderQryBo::getSupId));
        for (List list : splitSaleOrderResultList) {
            List payConfigBos;
            UocSaleOrderDo createSaleOrderDo = new UocSaleOrderDo();
            BeanUtils.copyProperties((Object)((Object)orderInfo), (Object)createSaleOrderDo);
            createSaleOrderDo.setSaleOrderItems(list);
            createSaleOrderDo.setOrderSource(((UocSaleOrderItem)list.get(0)).getSkuSource());
            createSaleOrderDo.setStakeholderId(orderStakeholderMap.get(((UocSaleOrderItem)list.get(0)).getSupplierId()).get(0).getStakeholderId());
            createSaleOrderDo.setStakeholder(UocRu.js(orderStakeholderMap.get(((UocSaleOrderItem)list.get(0)).getSupplierId()).get(0), UocSaleStakeholder.class));
            createSaleOrderDo.setTotalSaleFee(this.computeSaleOrderTotalSaleFee(list));
            createSaleOrderDo.setTotalPurchaseFee(this.computeSaleOrderTotalPurchaseFee(list));
            createSaleOrderDo.setCreatedResult(UocConstant.CREATED_RESULT.SUCCESS);
            if ("1".equals(((UocSupplierInfoBo)supplierInfoMap.get(Long.valueOf(((UocSaleOrderItem)list.get(0)).getSupplierId()))).getMonthReceiveNode())) {
                createSaleOrderDo.setIsCreateServiceFee(true);
            }
            if (StringUtils.isNotEmpty((CharSequence)((UocSaleOrderItem)list.get(0)).getAgreementId())) {
                payConfigBos = JSONArray.parseArray((String)JSON.toJSONString((Object)((UocCreateOrderServiceReqArgPayConfSupBo)agrPayConfigMap.get(((UocSaleOrderItem)list.get(0)).getAgreementId())).getConfBos())).toJavaList(UocSaleOrderPayConf.class);
                for (UocSaleOrderPayConf payConf : payConfigBos) {
                    if (UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.equals(payConf.getPayType())) {
                        payConf.setPrePayFee(createSaleOrderDo.getTotalSaleFee());
                        continue;
                    }
                    if (!UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT.equals(payConf.getPayType())) continue;
                    if (ObjectUtil.isNotEmpty((Object)payConf.getPrePaySup())) {
                        payConf.setPrePayFee(createSaleOrderDo.getTotalSaleFee().multiply(payConf.getPrePaySup()));
                    }
                    if (ObjectUtil.isNotEmpty((Object)payConf.getVerPaySup())) {
                        payConf.setVerPayFee(createSaleOrderDo.getTotalSaleFee().multiply(payConf.getVerPaySup()));
                    }
                    if (ObjectUtil.isNotEmpty((Object)payConf.getPilPaySup())) {
                        payConf.setPilPayFee(createSaleOrderDo.getTotalSaleFee().multiply(payConf.getPilPaySup()));
                    }
                    if (!ObjectUtil.isNotEmpty((Object)payConf.getQuaPaySup())) continue;
                    payConf.setQuaPayFee(createSaleOrderDo.getTotalSaleFee().multiply(payConf.getQuaPaySup()));
                }
                createSaleOrderDo.setSaleOrderPayConfList(payConfigBos);
                createSaleOrderDo.setModelSettle(((UocCreateOrderServiceReqPayConfBo)((UocCreateOrderServiceReqArgPayConfSupBo)agrPayConfigMap.get(((UocSaleOrderItem)list.get(0)).getAgreementId())).getConfBos().get(0)).getModelSettle());
                createSaleOrderDo.setAdjustPrice(((UocCreateOrderServiceReqArgPayConfSupBo)agrPayConfigMap.get(((UocSaleOrderItem)list.get(0)).getAgreementId())).getAdjustPrice());
                createSaleOrderDo.setAgreementId(((UocSaleOrderItem)list.get(0)).getAgreementId());
                createSaleOrderDo.setAgreementNo(((UocSaleOrderItem)list.get(0)).getAgreementNo());
                createSaleOrderDo.setAgrDataId(((UocCreateOrderServiceReqArgPayConfSupBo)agrPayConfigMap.get(((UocSaleOrderItem)list.get(0)).getAgreementId())).getAgrDataId());
                createSaleOrderDo.setProDeliveryId(((UocCreateOrderServiceReqArgPayConfSupBo)agrPayConfigMap.get(((UocSaleOrderItem)list.get(0)).getAgreementId())).getProDeliveryId());
                createSaleOrderDo.setProDeliveryName(((UocCreateOrderServiceReqArgPayConfSupBo)agrPayConfigMap.get(((UocSaleOrderItem)list.get(0)).getAgreementId())).getProDeliveryName());
            } else {
                payConfigBos = JSONArray.parseArray((String)JSON.toJSONString((Object)((UocSupplierInfoBo)supplierInfoMap.get(Long.valueOf(((UocSaleOrderItem)list.get(0)).getSupplierId()))).getPayConfigBos())).toJavaList(UocSaleOrderPayConf.class);
                for (UocSaleOrderPayConf payConf : payConfigBos) {
                    if (UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.equals(payConf.getPayType())) {
                        payConf.setPrePayFee(createSaleOrderDo.getTotalSaleFee());
                        continue;
                    }
                    if (!UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT.equals(payConf.getPayType())) continue;
                    if (ObjectUtil.isNotEmpty((Object)payConf.getPrePaySup())) {
                        payConf.setPrePayFee(createSaleOrderDo.getTotalSaleFee().multiply(payConf.getPrePaySup()));
                    }
                    if (ObjectUtil.isNotEmpty((Object)payConf.getVerPaySup())) {
                        payConf.setVerPayFee(createSaleOrderDo.getTotalSaleFee().multiply(payConf.getVerPaySup()));
                    }
                    if (ObjectUtil.isNotEmpty((Object)payConf.getPilPaySup())) {
                        payConf.setPilPayFee(createSaleOrderDo.getTotalSaleFee().multiply(payConf.getPilPaySup()));
                    }
                    if (!ObjectUtil.isNotEmpty((Object)payConf.getQuaPaySup())) continue;
                    payConf.setQuaPayFee(createSaleOrderDo.getTotalSaleFee().multiply(payConf.getQuaPaySup()));
                }
                createSaleOrderDo.setSaleOrderPayConfList(payConfigBos);
                createSaleOrderDo.setModelSettle(((UocCreateOrderServiceReqPayConfBo)((UocSupplierInfoBo)supplierInfoMap.get(Long.valueOf(((UocSaleOrderItem)list.get(0)).getSupplierId()))).getPayConfigBos().get(0)).getModelSettle());
            }
            saleOrderList.add(createSaleOrderDo);
        }
        return saleOrderList;
    }

    private BigDecimal computeSaleOrderTotalPurchaseFee(List<UocSaleOrderItem> orderItem) {
        BigDecimal saleFee = new BigDecimal(0);
        for (UocSaleOrderItem uocOrderItem : orderItem) {
            saleFee = saleFee.add(uocOrderItem.getPurchaseCount().multiply(uocOrderItem.getPurchasePrice()));
        }
        return saleFee;
    }

    private BigDecimal computeSaleOrderTotalSaleFee(List<UocSaleOrderItem> orderItem) {
        BigDecimal totalSaleFee = new BigDecimal(0);
        for (UocSaleOrderItem uocOrderItem : orderItem) {
            totalSaleFee = totalSaleFee.add(uocOrderItem.getPurchaseCount().multiply(uocOrderItem.getSalePrice()));
        }
        return totalSaleFee;
    }
}

