package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.qrybo.*;
import com.tydic.dyc.oc.model.aforder.sub.*;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.*;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

/**
 * 标题:UocEsSyncAf
 * 说明:售后单
 * 时间:2022/3/1 14:08
 * 作者:tkl
 */
@Slf4j
@Component
public class UocEsSyncAf implements IUocEsSync {

    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Autowired
    private UocIndexConfig uocIndexConfig;
    
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @Override
    public String indexName() {
        return uocIndexConfig.getAfOrderIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        IUocEsSyncQryRspBo rspBo = new IUocEsSyncQryRspBo();
        rspBo.setObjId(reqBo.getObjId());
        //查询售后单主体
        UocAfOrder afOrderMain = getAfOrderMain(reqBo);
        if (ObjectUtil.isNull(afOrderMain)) {
            return rspBo;
        }
        if (ObjectUtil.isNull(afOrderMain.getFinishTime())) {
            afOrderMain.setFinishTime(afOrderMain.getCreateTime());
        }
        //查询售后单扩展
        List<UocAfOrderMap> afOrderMapList = getAfOrderMapList(reqBo);
        //查询售后单对象
        List<UocAfOrderObj> afOrderObjList = getAfOrderObjList(reqBo);
        //查询售后单明细
        List<UocAfOrderItem> afOrderItemList = getAfOrderItemList(reqBo);
        //查询售后单明细扩展
        List<UocAfItemMap> afOrderItemMapList = getAfOrderItemMapList(reqBo);
        ConcurrentMap<Long, List<UocAfItemMap>> afItemMap = new ConcurrentHashMap<>();
        if (ObjectUtil.isNotEmpty(afOrderItemMapList)) {
            afItemMap = afOrderItemMapList.stream().collect(Collectors.groupingByConcurrent(UocAfItemMap::getAfOrderItemId));
        }
        //查询附件
        List<UocOrderAccessory> orderAccessoryList = getOrderAccessoryList(reqBo);

        //封装出参信息
        //售后单主体
        UocAfOrderDo uocAfOderDo = UocRu.js(afOrderMain, UocAfOrderDo.class);

        //查询业务流程实例
        UocGetSaleOrderDetailServiceRspPorcBo procInst = getProcInst(uocAfOderDo, false);
        
       //查询审批流程实例
        UocGetSaleOrderDetailServiceRspPorcBo auditProcInst = getAuditProcInst(reqBo, UocDicConstant.OBJ_TYPE.ORDER);
        
        //主体翻译
        translateAfMain(uocAfOderDo);
        //售后单对象
        uocAfOderDo.setAfOrderObjList(afOrderObjList);
        //附件
        uocAfOderDo.setOrderAccessoryBoList(orderAccessoryList);
        //销售单主体
        UocSaleOrderDo saleOrderDo = getSaleOrderDo(uocAfOderDo);
        //销售单明细
        Map<Long, UocSaleOrderItem> saleItemMap = getSaleItem(uocAfOderDo);
        //发货单主体
        List<UocShipOrderDo> shipOrderDos = getShipOrderDo(uocAfOderDo);

        JSONObject afOrderObj = JSON.parseObject(JSON.toJSONString(uocAfOderDo));
        putShipOrderInfo(shipOrderDos, afOrderObj);
        putSaleOrderInfo(saleOrderDo, afOrderObj);

        //售后单扩展
        if (ObjectUtil.isNotEmpty(afOrderMapList)) {
            afOrderMapList.forEach(each -> afOrderObj.put(each.getFieldCode(), each.getFieldValue()));
        }
        //售后单明细
        JSONArray afItemArray = new JSONArray();
        if (ObjectUtil.isNotEmpty(afOrderItemList)) {
            //售后数量拉横
            afOrderObj.put(UocConstant.ES_MAIN_OTHER.RETURN_COUNT, (afOrderItemList.stream().map(UocAfOrderItem::getReturnCount).reduce((x, y) -> x.add(y)).get()).intValue());
            for (UocAfOrderItem item : afOrderItemList) {
                translateAfItem(item);
                JSONObject afItemObj = JSON.parseObject(JSON.toJSONString(item));
                if (ObjectUtil.isNotEmpty(afItemMap) && afItemMap.containsKey(item.getAfOrderItemId())) {
                    //售后单明细扩展
                    afItemMap.get(item.getAfOrderItemId()).forEach(each -> afItemObj.put(each.getFieldCode(), each.getFieldValue()));
                }
                //销售单明细信息
                if (ObjectUtil.isNotEmpty(saleItemMap) && saleItemMap.containsKey(item.getSaleItemId())) {
                    putSaleItemInfo(afItemObj, saleItemMap.get(item.getSaleItemId()));
                }
                afItemArray.add(afItemObj);
            }
        }
        afOrderObj.put(UocConstant.ES_MAIN_OTHER.UOC_AF_ORDER_ITEM, afItemArray);
        afOrderObj.put(UocConstant.ES_MAIN_OTHER.BUSI_TASK_INST, procInst.getTaskList());
        afOrderObj.put(UocConstant.ES_MAIN_OTHER.BUSI_PROC_INST, procInst.getProcInstId());
        // 审批流程信息
        afOrderObj.put(UocConstant.ES_MAIN_OTHER.AUDIT_PROC_INST, auditProcInst.getProcInstId());
        //服务单
        afOrderObj.put(UocConstant.ES_MAIN_OTHER.AFTER_FLAG, true);
        //推送已办
        putDoneTask(uocAfOderDo, afOrderObj);
        if (Integer.valueOf(1).equals(afOrderMain.getWaybillFlag())) {
            afOrderObj.put(UocConstant.ES_MAIN_OTHER.WAYBILLFLAGSTR, "是");
        } else {
            afOrderObj.put(UocConstant.ES_MAIN_OTHER.WAYBILLFLAGSTR, "否");
        }
        //查询收货人信息
        afOrderObj.put("contactShipName",getLogistics(afOrderMain));

        rspBo.setJsonObj(afOrderObj);
        log.info("售后单ES数据：{}", afOrderObj.toJSONString());
        return rspBo;
    }

    private void putDoneTask(UocAfOrderDo uocAfOderDo, JSONObject afOrderObj) {
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setObjId(uocAfOderDo.getAfOrderId());
        taskInstQryBo.setOrderId(uocAfOderDo.getOrderId());
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        List<Integer> finishTagList = new ArrayList<>();
        finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
        taskInstQryBo.setFinishTagList(finishTagList);
        List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        if (!CollectionUtils.isEmpty(uocOrderTaskInsts)) {
            List<String> procState = uocOrderTaskInsts.stream().map(UocOrderTaskInst::getProcState).collect(Collectors.toList());
            afOrderObj.put(UocConstant.ES_MAIN_OTHER.DONE_TASK_TACHE_CODE, procState);
        }
    }

    private void putShipOrderInfo(List<UocShipOrderDo> shipOrderDos, JSONObject afOrderObj) {
        if (ObjectUtil.isNotEmpty(shipOrderDos)) {
            afOrderObj.put(UocConstant.ES_MAIN_OTHER.SHIP_ORDER_NO, shipOrderDos.get(0).getShipOrderNo());
            afOrderObj.put(UocConstant.ES_MAIN_OTHER.SHIP_ORDER_STATE_STR, getDic().get(UocStateConstants.ShipOrder.P_CODE).get(shipOrderDos.get(0).getShipOrderState()));
        }
    }

    /**
     * 售后单主体信息拉横
     *
     * @param saleOrderDo
     * @param afOrderObj
     */
    private void putSaleOrderInfo(UocSaleOrderDo saleOrderDo, JSONObject afOrderObj) {
        if (ObjectUtil.isNotEmpty(saleOrderDo)) {
            afOrderObj.put(UocConstant.ES_MAIN_OTHER.ORD_SOURCE, saleOrderDo.getOrderSource().toString());
            afOrderObj.put(UocConstant.ES_MAIN_OTHER.ORDER_CREATE_OPER_NAME, saleOrderDo.getCreateOperName());
            afOrderObj.put(UocConstant.ES_MAIN_OTHER.ORDER_CREATE_TIME, saleOrderDo.getCreateTime());
            afOrderObj.put(UocConstant.ES_MAIN_OTHER.SALE_ORD_ID, saleOrderDo.getSaleOrderId());
            afOrderObj.put(UocConstant.ES_MAIN_OTHER.SALE_ORDER_NO, saleOrderDo.getSaleOrderNo());
            afOrderObj.put(UocConstant.ES_MAIN_OTHER.SALE_ORD_STATE, saleOrderDo.getSaleOrderState());
            afOrderObj.put(UocConstant.ES_MAIN_OTHER.SALE_ORD_STATE_STR, getDic().get(UocDicConstant.SALE_ORD_STATE.P_CODE).get(saleOrderDo.getSaleOrderState()));
            afOrderObj.put(UocConstant.ES_MAIN_OTHER.TRADE_MODE, saleOrderDo.getModelSettle());
            if (ObjectUtil.isNotEmpty(saleOrderDo.getStakeholder())) {
                afOrderObj.put(UocConstant.ES_MAIN_OTHER.SUP_ID, saleOrderDo.getStakeholder().getSupId());
                afOrderObj.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_ID, saleOrderDo.getStakeholder().getPurOrgId());
                afOrderObj.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_NAME, saleOrderDo.getStakeholder().getPurOrgName());
                afOrderObj.put(UocConstant.ES_MAIN_OTHER.SUP_NO, saleOrderDo.getStakeholder().getSupId());
                afOrderObj.put(UocConstant.ES_MAIN_OTHER.SUP_NAME, saleOrderDo.getStakeholder().getSupName());
                afOrderObj.put(UocConstant.ES_MAIN_OTHER.PUR_USER_ID, saleOrderDo.getStakeholder().getPurUserId());
                afOrderObj.put(UocConstant.ES_MAIN_OTHER.PRO_ID, saleOrderDo.getStakeholder().getProId());
            }
        }
    }

    /**
     * 售后单明细翻译
     *
     * @param item
     */
    private void translateAfItem(UocAfOrderItem item) {
        Map<String, Map<String, String>> dicMap = getDic();
        if (ObjectUtil.isNotNull(item.getIshaspackage())) {
            //是否有包装
            item.setIshaspackageStr(dicMap.get(UocDicConstant.IS_HAS_PACKAGE.P_CODE).get(item.getIshaspackage().toString()));
        }
        if (ObjectUtil.isNotNull(item.getPackageDesc())) {
            //包装描述
            item.setPackageDescStr(dicMap.get(UocDicConstant.PACKAGE_DECRIP.P_CODE).get(item.getPackageDesc().toString()));
        }
    }

    /**
     * 售后单主体翻译
     *
     * @param uocAfOderDo
     */
    private void translateAfMain(UocAfOrderDo uocAfOderDo) {
        Map<String, Map<String, String>> dicMap = getDic();
        if (ObjectUtil.isNotEmpty(dicMap)) {
            if (ObjectUtil.isNotNull(uocAfOderDo.getServType())) {
                //服务类型
                uocAfOderDo.setServTypeStr(dicMap.get(UocDicConstant.SERVICE_TYPE.P_CODE).get(uocAfOderDo.getServType().toString()));
            }
            if (ObjectUtil.isNotNull(uocAfOderDo.getServState())) {
                //服务单状态
                uocAfOderDo.setServStateStr(dicMap.get(UocDicConstant.SERVICE_STATE.P_CODE).get(uocAfOderDo.getServState().toString()));
            }
            if (ObjectUtil.isNotNull(uocAfOderDo.getIsCancel())) {
                //是否可取消
                uocAfOderDo.setIsCancelStr(dicMap.get(UocDicConstant.IS_CANCEL.P_CODE).get(uocAfOderDo.getIsCancel().toString()));
            }
            //支付方式
            uocAfOderDo.setPayTypeStr(dicMap.get(UocDicConstant.PAY_TYPE.P_CODE).get(uocAfOderDo.getPayType()));
            if (ObjectUtil.isNotNull(uocAfOderDo.getPayState())) {
                //退款状态
                uocAfOderDo.setPayStateStr(dicMap.get(UocDicConstant.PAY_AFTER_STATE.P_CODE).get(uocAfOderDo.getPayState().toString()));
            }
            if (ObjectUtil.isNotNull(uocAfOderDo.getPickwareType())) {
                //取货服务类型
                uocAfOderDo.setPickwareTypeStr(dicMap.get(UocDicConstant.PICKWARE_SERVE_TYPE.P_CODE).get(uocAfOderDo.getPickwareType().toString()));
            }
            if (ObjectUtil.isNotNull(uocAfOderDo.getCancelFlag())) {
                //撤单标志
                uocAfOderDo.setCancelFlagStr(dicMap.get(UocDicConstant.CANCEL_FLAG.P_CODE).get(uocAfOderDo.getCancelFlag().toString()));
            }
            if (ObjectUtil.isNotNull(uocAfOderDo.getCancelType())) {
                //取消类型
                uocAfOderDo.setCancelTypeStr(dicMap.get(UocDicConstant.CANCEL_TYPE.P_CODE).get(uocAfOderDo.getCancelType().toString()));
            }
            //供应商售后服务环节编码
            uocAfOderDo.setServiceStepStr(dicMap.get(UocDicConstant.SERVICE_STEP.P_CODE).get(uocAfOderDo.getServiceStep()));
        }
    }

    /**
     * 查询订单附件
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocOrderAccessory></>
     */
    private List<UocOrderAccessory> getOrderAccessoryList(IUocEsSyncQryReqBo reqBo) {
        UocOrderAccessoryQryBo uocOrderAccessoryQryBo = new UocOrderAccessoryQryBo();
        uocOrderAccessoryQryBo.setObjId(reqBo.getObjId());
        uocOrderAccessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        uocOrderAccessoryQryBo.setOrderId(reqBo.getOrderId());
        return iUocOrderModel.getOrderAccessoryList(uocOrderAccessoryQryBo);
    }

    /**
     * 收货人信息查询
     */
    private String getLogistics(UocAfOrder uocAfOrder) {
        UocOrdLogisticsRela logisticsRela = new UocOrdLogisticsRela();
        if (null != uocAfOrder) {
            UocOrdLogisticsRelaQryBo relaQryBo = new UocOrdLogisticsRelaQryBo();
            relaQryBo.setOrderId(uocAfOrder.getOrderId());
            UocOrderDo uocOrderDo = getUocOrderDo(uocAfOrder.getOrderId());
            relaQryBo.setContactId(uocOrderDo.getContactId());
            logisticsRela = iUocOrderModel.qryOrderLogisticsRela(relaQryBo);
        }
        return logisticsRela.getContactName();
    }
    /**
     * 查询订单主体
     */
    private UocOrderDo getUocOrderDo(Long orderId) {
        UocOrderDo qryBo = new UocOrderDo();
        qryBo.setOrderId(orderId);
        return iUocOrderModel.qryOrderBy(qryBo);
    }

    /**
     * 查询发货单主体
     *
     * @param uocAfOrderDo
     * @return com.tydic.dyc.oc.model.shiporder.UocShipOrderDo
     */
    private List<UocShipOrderDo> getShipOrderDo(UocAfOrderDo uocAfOrderDo) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(uocAfOrderDo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(uocAfOrderDo.getSaleOrderId());
        return iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
    }

    /**
     * 查询发货单明细列表
     *
     * @param reqBo
     * @return
     */
    private List<UocShipOrderItem> getListShipOrderItem(UocSaleOrderItem reqBo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderItemQryBo.setSaleOrderItemId(reqBo.getSaleOrderItemId());
        UocShipOrderDo uocShipOrderDo = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        return ObjectUtil.isNotNull(uocShipOrderDo) ? uocShipOrderDo.getShipOrderItemBoList() : new ArrayList<>();
    }

    /**
     * 查询字典
     */
    private Map<String, Map<String, String>> getDic() {
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocDicConstant.SERVICE_TYPE.P_CODE);
        pCodes.add(UocDicConstant.SERVICE_STATE.P_CODE);
        pCodes.add(UocDicConstant.IS_CANCEL.P_CODE);
        pCodes.add(UocDicConstant.PAY_TYPE.P_CODE);
        pCodes.add(UocDicConstant.PAY_STATE.P_CODE);
        pCodes.add(UocDicConstant.CANCEL_FLAG.P_CODE);
        pCodes.add(UocDicConstant.CANCEL_TYPE.P_CODE);
        pCodes.add(UocDicConstant.PICKWARE_SERVE_TYPE.P_CODE);
        pCodes.add(UocDicConstant.SERVICE_STEP.P_CODE);
        pCodes.add(UocDicConstant.IS_HAS_PACKAGE.P_CODE);
        pCodes.add(UocDicConstant.PACKAGE_DECRIP.P_CODE);
        pCodes.add(UocStateConstants.ShipOrder.P_CODE);
        pCodes.add(UocDicConstant.SALE_ORD_STATE.P_CODE);
        pCodes.add(UocDicConstant.PAY_AFTER_STATE.P_CODE);
        return iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }

    /**
     * 封装销售单明细信息
     */
    private void putSaleItemInfo(JSONObject afItemObj, UocSaleOrderItem uocSaleOrderItem) {
        afItemObj.put(UocConstant.ES_MAIN_OTHER.COMMODITY_ID, uocSaleOrderItem.getCommodityId());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.COMMODITY_NAME, uocSaleOrderItem.getCommodityName());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SKU_NAME, uocSaleOrderItem.getSkuName());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SKU_ID, uocSaleOrderItem.getSkuId());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SKU_CODE, uocSaleOrderItem.getSkuCode());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SKU_EXT_SKU_ID, uocSaleOrderItem.getSkuExtSkuId());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SKU_MATERIAL_ID, uocSaleOrderItem.getSkuMaterialId());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SKU_MAIN_PIC_URL, uocSaleOrderItem.getSkuMainPicUrl());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SKU_MATERIAL_NAME, uocSaleOrderItem.getSkuMaterialName());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SKU_MATERIAL_TYPE_ID, uocSaleOrderItem.getSkuMaterialTypeId());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SKU_MATERIAL_TYPE_NAME, uocSaleOrderItem.getSkuMaterialTypeName());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.UNIT_NAME, uocSaleOrderItem.getUnitName());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.MODEL, uocSaleOrderItem.getModel());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SPEC, uocSaleOrderItem.getSpec());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.TAX, uocSaleOrderItem.getTax());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.TAX_ID, uocSaleOrderItem.getTaxId());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.TAX_PRICE, uocSaleOrderItem.getTaxPrice());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SKU_BRAND_ID, uocSaleOrderItem.getSkuBrandId());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SKU_BRAND_NAME, uocSaleOrderItem.getSkuBrandName());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.L1_CATALOG, uocSaleOrderItem.getL1Catalog());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.L1_CATALOG_NAME, uocSaleOrderItem.getL1CatalogName());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.L2_CATALOG, uocSaleOrderItem.getL2Catalog());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.L2_CATALOG_NAME, uocSaleOrderItem.getL2CatalogName());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.L3_CATALOG, uocSaleOrderItem.getL3Catalog());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.L3_CATALOG_NAME, uocSaleOrderItem.getL3CatalogName());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SALE_PRICE, uocSaleOrderItem.getSalePrice());
        //发货单明细
        List<UocShipOrderItem> shipOrderItemList = getListShipOrderItem(uocSaleOrderItem);
        if (ObjectUtil.isNotEmpty(shipOrderItemList)) {
            afItemObj.put(UocConstant.ES_MAIN_OTHER.SALE_FEE, uocSaleOrderItem.getSalePrice().multiply(shipOrderItemList.get(0).getSendCount()));
            afItemObj.put(UocConstant.ES_MAIN_OTHER.PUR_FEE, uocSaleOrderItem.getPurchasePrice().multiply(shipOrderItemList.get(0).getSendCount()));
        }
        afItemObj.put(UocConstant.ES_MAIN_OTHER.PUR_PRICE, uocSaleOrderItem.getPurchasePrice());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.PUR_COUNT, uocSaleOrderItem.getPurchaseCount());
    }

    /**
     * 查询销售单明细
     *
     * @param uocAfOderDo
     * @return java.util.Map<java.lang.Long, com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem></>
     */
    private Map<Long, UocSaleOrderItem> getSaleItem(UocAfOrderDo uocAfOderDo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(uocAfOderDo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(uocAfOderDo.getOrderId());
        List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (ObjectUtil.isNotEmpty(saleOrderItemList)) {
            return saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o, (k1, k2) -> k2));
        }
        return new HashMap<>();
    }

    /**
     * 查询销售单主体
     *
     * @param uocAfOderDo
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     */
    private UocSaleOrderDo getSaleOrderDo(UocAfOrderDo uocAfOderDo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(uocAfOderDo.getSaleOrderId());
        uocSaleOrderDo.setOrderId(uocAfOderDo.getOrderId());
        List<UocSaleOrderDo> uocSaleOrderDos = iUocSaleOrderModel.qrySaleOrderList(uocSaleOrderDo);
        return ObjectUtil.isNotEmpty(uocSaleOrderDos) ? uocSaleOrderDos.get(0) : null;
    }

    /**
     * 查询售后单扩展
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfOrderObj></>
     */
    private List<UocAfOrderObj> getAfOrderObjList(IUocEsSyncQryReqBo reqBo) {
        UocAfOrderObjQryBo uocAfOrderObjQryBo = new UocAfOrderObjQryBo();
        uocAfOrderObjQryBo.setAfOrderId(reqBo.getObjId());
        uocAfOrderObjQryBo.setOrderId(reqBo.getOrderId());
        return iUocAfOrderModel.getAfOrderObjList(uocAfOrderObjQryBo);
    }

    /**
     * 查询售后单明细
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem></>
     */
    private List<UocAfOrderItem> getAfOrderItemList(IUocEsSyncQryReqBo reqBo) {
        UocAfOrderItemQryBo uocAfOrderItemQryBo = new UocAfOrderItemQryBo();
        uocAfOrderItemQryBo.setAfOrderId(reqBo.getObjId());
        uocAfOrderItemQryBo.setOrderId(reqBo.getOrderId());
        return iUocAfOrderModel.getAfOrderItemList(uocAfOrderItemQryBo);
    }

    /**
     * 查询售后单明细扩展
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfItemMap></>
     */
    private List<UocAfItemMap> getAfOrderItemMapList(IUocEsSyncQryReqBo reqBo) {
        UocAfItemMapQryBo uocAfItemMapQryBo = new UocAfItemMapQryBo();
        uocAfItemMapQryBo.setAfOrderId(reqBo.getObjId());
        uocAfItemMapQryBo.setOrderId(reqBo.getOrderId());
        return iUocAfOrderModel.getAfOrderItemMapList(uocAfItemMapQryBo);
    }

    /**
     * 查询售后单扩展
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfOrderMap></>
     */
    private List<UocAfOrderMap> getAfOrderMapList(IUocEsSyncQryReqBo reqBo) {
        UocAfOrderMapQryBo uocAfOrderMapQryBo = new UocAfOrderMapQryBo();
        uocAfOrderMapQryBo.setAfOrderId(reqBo.getObjId());
        uocAfOrderMapQryBo.setOrderId(reqBo.getOrderId());
        return iUocAfOrderModel.getAfOrderMapList(uocAfOrderMapQryBo);
    }

    /**
     * 查询售后单主体
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.aforder.sub.UocAfOrder
     */
    private UocAfOrder getAfOrderMain(IUocEsSyncQryReqBo reqBo) {
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setAfOrderId(reqBo.getObjId());
        uocAfOrderQryBo.setOrderId(reqBo.getOrderId());
        return iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
    }

    /**
     * 查询流程任务实例
     *
     * @param reqBo
     * @param isAudit
     * @return UocGetSaleOrderDetailServiceRspPorcBo
     */
    private UocGetSaleOrderDetailServiceRspPorcBo getProcInst(UocAfOrderDo reqBo, Boolean isAudit) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        if (isAudit) {
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        } else {
            procInstQryBo.setObjId(reqBo.getAfOrderId());
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        }
        procInstQryBo.setOrderId(reqBo.getOrderId());
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderProcInst> uocOrderProcInsts = iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            procInst = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class).get(0);
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setObjId(procInst.getObjId());
            taskInstQryBo.setObjType(procInst.getObjType());
            List<Integer> finishTagList = new ArrayList<>();
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
            taskInstQryBo.setFinishTagList(finishTagList);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<>();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setObjId(each.getObjId());
                    taskDealQryBo.setObjType(each.getObjType());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList<>());
                });
            }
            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }
    
    /**
     * 查询流程任务实例
     *
     * @param reqBo
     * @param objType
     * @return UocGetSaleOrderDetailServiceRspPorcBo
     */
    private UocGetSaleOrderDetailServiceRspPorcBo getAuditProcInst(IUocEsSyncQryReqBo reqBo, Integer objType) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        //查询订单对应的审批单id
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        uocApprovalObjQryBo.setObjId(reqBo.getOrderId() + "");
        uocApprovalObjQryBo.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
        List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        if (CollectionUtil.isNotEmpty(uocApprovalObjs)) {
            List<Long> auditOrderIds = uocApprovalObjs.stream().map(UocApprovalObj::getAuditOrderId).collect(Collectors.toList());
            //查询审批单对应的任务
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setOrderId(reqBo.getOrderId());
            taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
            taskInstQryBo.setObjIdList(auditOrderIds);
            //taskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<>();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocApprovalObjQryBo uocApprovalObjQryBo1 = new UocApprovalObjQryBo();
                    uocApprovalObjQryBo1.setAuditOrderId(each.getObjId());
                    List<UocApprovalObj> uocApprovalObjs1 = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo1);
                    Integer objBusiType = uocApprovalObjs1.get(0).getObjBusiType();
                    each.setObjBusiType(objBusiType);
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    if (CollectionUtil.isNotEmpty(uocOrderTaskDeals)) {
                        UocOrderTaskDeal uocOrderTaskDeal = uocOrderTaskDeals.get(0);
                        String dealId = uocOrderTaskDeal.getDealId();
                        String dealName = uocOrderTaskDeal.getDealName();
                        each.setDealId(dealId);
                        each.setDealName(dealName);
                    }
                    String auditDealResultQryKey = each.getDealId()+"_"+each.getObjBusiType();
                    if(each.getDealResult()!=null){
                        auditDealResultQryKey = auditDealResultQryKey+"_"+each.getDealResult();
                    }
                    each.setAuditDealResultQryKey(auditDealResultQryKey);
                    each.setTaskDealBo(CollectionUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList<>());
                    Date finishTime = each.getFinishTime();
                    String dealId = each.getDealId();
                    
                    if (ObjectUtil.isNotEmpty(finishTime) && ObjectUtil.isNotEmpty(dealId)) {
                        each.setFinishTimeStr(dealId + objBusiType + finishTime.getTime());
                    }
                    
                });
                procInst.setTaskList(taskBoList);
                procInst.setProcInstId(uocOrderTaskInsts.get(0).getProcInstId());
            }
            
        }
        return procInst;
    }
}
