package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderRefuseReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderRefuseRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 描述: 〈领域服务-销售单接单/拒单实现〉
 * @author : yuhao
 * @date : 2022/7/27 15:47
 */
@HTServiceImpl
public class UocSaleOrderRefuseServiceImpl implements UocSaleOrderRefuseService {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Override
    public UocSaleOrderRefuseRspBo dealSaleOrderRefuse(UocSaleOrderRefuseReqBo reqBo) {
        //参数校验
        this.verifyParam(reqBo);
        //更新销售单主体信息,供应商确认/拒单人，确认/拒单时间，拒单原因
        UocSaleOrderDo updateUocSaleOrderDo = new UocSaleOrderDo();
        updateUocSaleOrderDo.setOrderId(reqBo.getOrderId());
        updateUocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        updateUocSaleOrderDo.setRejectOperId(String.valueOf(reqBo.getUserId()));
        updateUocSaleOrderDo.setRejectOperName(reqBo.getName());
        updateUocSaleOrderDo.setRejectTime(new Date());
        if(UocConstant.CONFIRM_RESULT.REFUSE.equals(reqBo.getConfirmResult())){
            updateUocSaleOrderDo.setRejectReason(reqBo.getRefuseReason());
        }
        this.iUocSaleOrderModel.modifySaleOrderMain(updateUocSaleOrderDo);
        //如果有附件，保存附件
        if(!CollectionUtils.isEmpty(reqBo.getOrderAccessoryBoList())){
            this.saveAccessoryInfo(reqBo);
        }
        //提交任务
        this.commitTask(reqBo);

        UocSaleOrderRefuseRspBo rspBo = new UocSaleOrderRefuseRspBo();
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBo;
    }

    /**
     * 保存附件
     * @param reqBo
     */
    private void saveAccessoryInfo(UocSaleOrderRefuseReqBo reqBo){
        List<UocOrderAccessory> uocOrderAccessoryList = new ArrayList<>();
        for(UocBaseOrderAccessoryAddBo uocBaseOrderAccessoryAddBo:reqBo.getOrderAccessoryBoList()){
            UocOrderAccessory uocOrderAccessory = new UocOrderAccessory();
            BeanUtils.copyProperties(uocBaseOrderAccessoryAddBo,uocOrderAccessory);
            uocOrderAccessory.setId(IdUtil.nextId());
            uocOrderAccessory.setObjId(reqBo.getSaleOrderId());
            uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            uocOrderAccessory.setOrderId(reqBo.getOrderId());
            uocOrderAccessory.setCreateTime(new Date());
            uocOrderAccessory.setCreateOperId(String.valueOf(reqBo.getUserId()));
            uocOrderAccessoryList.add(uocOrderAccessory);
        }
        this.iUocOrderModel.createOrderAccessory(uocOrderAccessoryList);
    }

    /**
     * 提交订单任务
     * @param reqBo
     */
    private void commitTask(UocSaleOrderRefuseReqBo reqBo) {
        UocCommonDo uocCommonDo = new UocCommonDo();
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskInfos = new ArrayList<>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo task = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        task.setTaskId(reqBo.getTaskId());
        taskInfos.add(task);
        uocCommonDo.setCompleteTaskInfos(taskInfos);
        uocCommonDo.setUserId(reqBo.getUserId());
        uocCommonDo.setOrderId(reqBo.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
    }


    /**
     * 参数校验
     * @param reqBo
     */
    private void verifyParam(UocSaleOrderRefuseReqBo reqBo){
        if(null == reqBo){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if(null == reqBo.getUserId()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "当前登录人Id不能为空");
        }
        if(StringUtils.isEmpty(reqBo.getName())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "当前登录人名称不能为空");
        }
        if(null == reqBo.getOrderId()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单Id不能为空");
        }
        if(null == reqBo.getSaleOrderId()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售订单Id不能为空");
        }
        if(StringUtils.isEmpty(reqBo.getTaskId())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "任务id不能为空");
        }
        if(null == reqBo.getConfirmResult()){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "确认结果不能为空");
        }
    }

}
