/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import com.tydic.dyc.oc.service.domainservice.UocCancelSaleOrderAndStopProcessService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderAndStopProcessServiceReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderAndStopProcessServiceRspBO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocCancelSaleOrderAndStopProcessService"})
public class UocCancelSaleOrderAndStopProcessServiceImpl
implements UocCancelSaleOrderAndStopProcessService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @PostMapping(value={"cancelSaleOrderAndStopProcess"})
    public UocCancelSaleOrderAndStopProcessServiceRspBO cancelSaleOrderAndStopProcess(@RequestBody UocCancelSaleOrderAndStopProcessServiceReqBO reqBO) {
        this.verifyParam(reqBO);
        this.updateSaleOrderStatus(reqBO);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderAccessoryBoList())) {
            this.saveCancelAccessoryInfo(reqBO);
        }
        this.updateSaleOrderProcessInfo(reqBO);
        return UocRu.success(UocCancelSaleOrderAndStopProcessServiceRspBO.class);
    }

    private void verifyParam(UocCancelSaleOrderAndStopProcessServiceReqBO reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getUserId()) {
            throw new BaseBusinessException("102001", "\u5f53\u524d\u64cd\u4f5c\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)reqBO.getName())) {
            throw new BaseBusinessException("102001", "\u5f53\u524d\u64cd\u4f5c\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new BaseBusinessException("102001", "\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSaleOrderId()) {
            throw new BaseBusinessException("102001", "\u9500\u552e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void updateSaleOrderStatus(UocCancelSaleOrderAndStopProcessServiceReqBO reqBO) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setUpdateTime(new Date());
        uocSaleOrderDo.setUpdateOperId(String.valueOf(reqBO.getUserId()));
        uocSaleOrderDo.setUpdateOperName(reqBO.getName());
        uocSaleOrderDo.setCancelTime(new Date());
        uocSaleOrderDo.setCancelReason(reqBO.getCancelReason());
        uocSaleOrderDo.setCancelOperName(reqBO.getName());
        uocSaleOrderDo.setCancelOperId(String.valueOf(reqBO.getUserId()));
        uocSaleOrderDo.setSaleOrderState("XS_QX_QX");
        uocSaleOrderDo.setOrderId(reqBO.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBO.getSaleOrderId());
        this.iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
    }

    private void saveCancelAccessoryInfo(UocCancelSaleOrderAndStopProcessServiceReqBO reqBO) {
        ArrayList<UocOrderAccessory> uocOrderAccessoryList = new ArrayList<UocOrderAccessory>();
        for (UocBaseOrderAccessoryAddBo uocBaseOrderAccessoryAddBo : reqBO.getOrderAccessoryBoList()) {
            UocOrderAccessory uocOrderAccessory = new UocOrderAccessory();
            uocOrderAccessory.setId(IdUtil.nextId());
            uocOrderAccessory.setAccessoryId(uocBaseOrderAccessoryAddBo.getAccessoryId());
            uocOrderAccessory.setAccessoryName(uocBaseOrderAccessoryAddBo.getAccessoryName());
            uocOrderAccessory.setAccessoryUrl(uocBaseOrderAccessoryAddBo.getAccessoryUrl());
            uocOrderAccessory.setAttachmentType(uocBaseOrderAccessoryAddBo.getAttachmentType());
            uocOrderAccessory.setObjId(reqBO.getSaleOrderId());
            uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            uocOrderAccessory.setOrderId(reqBO.getOrderId());
            uocOrderAccessory.setCreateTime(new Date());
            uocOrderAccessory.setCreateOperId(String.valueOf(reqBO.getUserId()));
            uocOrderAccessoryList.add(uocOrderAccessory);
        }
        this.iUocOrderModel.createOrderAccessory(uocOrderAccessoryList);
    }

    private void updateSaleOrderProcessInfo(UocCancelSaleOrderAndStopProcessServiceReqBO reqBO) {
        UocOrderProcInst uocOrderProcInst = new UocOrderProcInst();
        uocOrderProcInst.setOrderId(reqBO.getOrderId());
        uocOrderProcInst.setObjId(reqBO.getSaleOrderId());
        uocOrderProcInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
        uocOrderProcInst.setFinishTime(new Date());
        this.iUocSaleOrderModel.updateProcInst(uocOrderProcInst);
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setObjId(reqBO.getSaleOrderId());
        uocOrderTaskInst.setOrderId(reqBO.getOrderId());
        uocOrderTaskInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
        uocOrderTaskInst.setDealOperId(reqBO.getUserId().toString());
        uocOrderTaskInst.setDealOperName(reqBO.getName());
        uocOrderTaskInst.setDealRemark("\u6d41\u7a0b\u7ec8\u6b62");
        this.iUocSaleOrderModel.updateTaskInst(uocOrderTaskInst);
    }
}

