/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocConfEvaluate;
import com.tydic.dyc.oc.service.order.UocProOrderEvaluateDealService;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEvaluateDealReqBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEvaluateDealRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.order.UocProOrderEvaluateDealService"})
public class UocProOrderEvaluateDealServiceImpl
implements UocProOrderEvaluateDealService {
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @PostMapping(value={"dealOrderEvaluate"})
    public UocProOrderEvaluateDealRspBo dealOrderEvaluate(@RequestBody UocProOrderEvaluateDealReqBo reqBo) {
        this.validateArgs(reqBo);
        if (null != reqBo.getIsDelete() && reqBo.getIsDelete().booleanValue()) {
            this.deleteOrderEvaluate(reqBo);
        }
        if (null == reqBo.getEvaluateId() || 0L == reqBo.getEvaluateId()) {
            this.addConfEvaluate(reqBo);
        } else {
            this.modifyConfEvaluate(reqBo);
        }
        return UocRu.success(UocProOrderEvaluateDealRspBo.class);
    }

    private void modifyConfEvaluate(UocProOrderEvaluateDealReqBo reqBo) {
        UocConfEvaluate uocConfEvaluate = new UocConfEvaluate();
        uocConfEvaluate.setEvaluationDeadline(reqBo.getEvaluationDeadline());
        uocConfEvaluate.setSystemAutomaticPraise(reqBo.getSystemAutomaticPraise());
        uocConfEvaluate.setWhetherReview(reqBo.getWhetherReview());
        uocConfEvaluate.setReviewDeadline(reqBo.getReviewDeadline());
        uocConfEvaluate.setOperatingTime(new Date());
        uocConfEvaluate.setOperatorId(String.valueOf(reqBo.getUserId()));
        uocConfEvaluate.setOperatorName(reqBo.getUsername());
        uocConfEvaluate.setEvaluateId(reqBo.getEvaluateId());
        this.iUocOrderModel.modifyConfEvaluate(uocConfEvaluate);
    }

    private void addConfEvaluate(UocProOrderEvaluateDealReqBo reqBo) {
        UocConfEvaluate checkConfEvaluate = new UocConfEvaluate();
        checkConfEvaluate.setApplicationUnitNo(reqBo.getApplicationUnitNo());
        int checkBy = this.iUocOrderModel.getCheckConfEvaluate(checkConfEvaluate);
        if (0 != checkBy) {
            throw new BaseBusinessException("101017", "\u5df2\u5b58\u5728\u8be5\u5e94\u7528\u5355\u4f4d\u7684\u914d\u7f6e\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002");
        }
        UocConfEvaluate uocConfEvaluate = new UocConfEvaluate();
        uocConfEvaluate.setApplicationUnitNo(reqBo.getApplicationUnitNo());
        uocConfEvaluate.setEvaluateId(IdUtil.nextId());
        uocConfEvaluate.setApplicationUnitName(reqBo.getApplicationUnitName());
        uocConfEvaluate.setEvaluationDeadline(reqBo.getEvaluationDeadline());
        uocConfEvaluate.setSystemAutomaticPraise(reqBo.getSystemAutomaticPraise());
        uocConfEvaluate.setWhetherReview(reqBo.getWhetherReview());
        uocConfEvaluate.setReviewDeadline(reqBo.getReviewDeadline());
        uocConfEvaluate.setOperatingTime(new Date());
        uocConfEvaluate.setOperatorId(String.valueOf(reqBo.getUserId()));
        uocConfEvaluate.setOperatorName(reqBo.getUsername());
        this.iUocOrderModel.addConfEvaluate(uocConfEvaluate);
    }

    private void deleteOrderEvaluate(UocProOrderEvaluateDealReqBo reqBo) {
        UocConfEvaluate uocConfEvaluate = this.iUocOrderModel.getConfEvaluateById(reqBo.getEvaluateId());
        if (null == uocConfEvaluate) {
            throw new BaseBusinessException("101017", "\u5165\u53c2[effectiveId]\u67e5\u8be2\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        if ("0".equals(uocConfEvaluate.getApplicationUnitNo())) {
            throw new BaseBusinessException("101017", "\u8be5\u6570\u636e\u4e3a\u7cfb\u7edf\u9884\u8bbe\u503c\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.iUocOrderModel.deleteConfEvaluate(uocConfEvaluate);
    }

    private void validateArgs(UocProOrderEvaluateDealReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null != reqBo.getIsDelete() && reqBo.getIsDelete().booleanValue()) {
            if (null == reqBo.getEvaluateId() || 0L == reqBo.getEvaluateId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u5220\u9664[evaluateId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return;
        }
        if (null == reqBo.getEvaluateId() || 0L == reqBo.getEvaluateId()) {
            if (!StringUtils.hasText((String)reqBo.getApplicationUnitNo())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u65b0\u589e[applicationUnitNo]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)reqBo.getApplicationUnitName())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u65b0\u589e[applicationUnitName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (null == reqBo.getEvaluationDeadline() || 0L > reqBo.getEvaluationDeadline()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2[evaluationDeadline]\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e14\u5927\u4e8e\u7b49\u4e8e0");
        }
        if (null == reqBo.getSystemAutomaticPraise() || 0 != reqBo.getSystemAutomaticPraise() && 1 != reqBo.getSystemAutomaticPraise()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u65b0\u589e[systemAutomaticPraise]\u4e0d\u5408\u6cd5");
        }
        if (null == reqBo.getWhetherReview()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u65b0\u589e[whetherReview]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (0 == reqBo.getWhetherReview()) {
            reqBo.setReviewDeadline(null);
        } else if (1 == reqBo.getWhetherReview()) {
            if (null == reqBo.getReviewDeadline() || 0L > reqBo.getReviewDeadline()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2[reviewDeadline]\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e14\u5927\u4e8e\u7b49\u4e8e0");
            }
        } else {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u65b0\u589e[whetherReview]\u4e0d\u5408\u6cd5");
        }
    }
}

