/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.domainservice.UocCancelSaleOrderBatchConfirmOrRefuseService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderBatchConfirmOrRefuseReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderBatchConfirmOrRefuseRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderInfoBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocCancelSaleOrderBatchConfirmOrRefuseService"})
public class UocCancelSaleOrderBatchConfirmOrRefuseServiceImpl
implements UocCancelSaleOrderBatchConfirmOrRefuseService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    @PostMapping(value={"cancelSaleOrderBatchConfirmOrRefuse"})
    public UocCancelSaleOrderBatchConfirmOrRefuseRspBo cancelSaleOrderBatchConfirmOrRefuse(@RequestBody UocCancelSaleOrderBatchConfirmOrRefuseReqBo reqBo) {
        this.verifyParam(reqBo);
        this.batchUpdateCancelApplyChangeOrderInfo(reqBo);
        this.batchUpdateSaleOrderInfo(reqBo);
        if (UocConstant.CONFIRM_RESULT.ACCEPT.equals(reqBo.getConfirmResult())) {
            this.batchSubmitTask(reqBo);
        }
        UocCancelSaleOrderBatchConfirmOrRefuseRspBo rspBo = new UocCancelSaleOrderBatchConfirmOrRefuseRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void batchSubmitTask(UocCancelSaleOrderBatchConfirmOrRefuseReqBo reqBo) {
        for (UocCancelSaleOrderInfoBo uocCancelSaleOrderInfoBo : reqBo.getCancelApplyChangeOrderInfos()) {
            UocCommonDo uocCommonDo = new UocCommonDo();
            ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskInfos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo task = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            task.setTaskId(uocCancelSaleOrderInfoBo.getTaskId());
            taskInfos.add(task);
            uocCommonDo.setCompleteTaskInfos(taskInfos);
            uocCommonDo.setUserId(reqBo.getUserId());
            uocCommonDo.setOrderId(uocCancelSaleOrderInfoBo.getOrderId());
            this.iUocCommonModel.dealTask(uocCommonDo);
        }
    }

    private void batchUpdateSaleOrderInfo(UocCancelSaleOrderBatchConfirmOrRefuseReqBo reqBo) {
        for (UocCancelSaleOrderInfoBo uocCancelSaleOrderInfoBo : reqBo.getCancelApplyChangeOrderInfos()) {
            UocSaleOrderDo updateSaleOrderDo = new UocSaleOrderDo();
            updateSaleOrderDo.setOrderId(uocCancelSaleOrderInfoBo.getOrderId());
            updateSaleOrderDo.setSaleOrderId(uocCancelSaleOrderInfoBo.getSaleOrderId());
            updateSaleOrderDo.setCancelReplyContent(reqBo.getCancelReplyContent());
            updateSaleOrderDo.setCancelReplyTime(new Date());
            updateSaleOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
            updateSaleOrderDo.setUpdateOperName(reqBo.getName());
            updateSaleOrderDo.setUpdateTime(new Date());
            if (UocConstant.CONFIRM_RESULT.ACCEPT.equals(reqBo.getConfirmResult())) {
                updateSaleOrderDo.setSaleOrderState("XS_QX_QX");
            } else {
                updateSaleOrderDo.setSaleOrderState(uocCancelSaleOrderInfoBo.getOriginalSaleOrderStatus());
            }
            this.iUocSaleOrderModel.modifySaleOrderMain(updateSaleOrderDo);
        }
    }

    private void batchUpdateCancelApplyChangeOrderInfo(UocCancelSaleOrderBatchConfirmOrRefuseReqBo reqBo) {
        for (UocCancelSaleOrderInfoBo uocCancelSaleOrderInfoBo : reqBo.getCancelApplyChangeOrderInfos()) {
            UocChngOrderDo updateChngOrderDo = new UocChngOrderDo();
            updateChngOrderDo.setChngOrderId(uocCancelSaleOrderInfoBo.getChngOrderId());
            updateChngOrderDo.setOrderId(uocCancelSaleOrderInfoBo.getOrderId());
            if (UocConstant.CONFIRM_RESULT.ACCEPT.equals(reqBo.getConfirmResult())) {
                updateChngOrderDo.setChngOrderState("CHNG_XS_YQR");
            } else {
                updateChngOrderDo.setChngOrderState("CHNG_XS_YJJ");
            }
            updateChngOrderDo.setRejectReason(reqBo.getCancelReplyContent());
            updateChngOrderDo.setRejectTime(new Date());
            updateChngOrderDo.setUpdateOperName(reqBo.getName());
            updateChngOrderDo.setUpdateTime(new Date());
            updateChngOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
            this.iUocChngOrderModel.updateChngOrderMain(updateChngOrderDo);
        }
    }

    private void verifyParam(UocCancelSaleOrderBatchConfirmOrRefuseReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getConfirmResult()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getCancelApplyChangeOrderInfos())) {
            throw new BaseBusinessException("100001", "\u53d6\u6d88\u7533\u8bf7\u53d8\u66f4\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

