package com.tydic.dyc.oc.components;

import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.EventConsumerManger;
import com.tydic.dyc.oc.components.notice.UocNoticeProcessor;
import com.tydic.dyc.oc.components.notice.UocNoticeProcessorManager;
import com.tydic.dyc.oc.components.ordSourceProcessor.UocOrderSourceProcessor;
import com.tydic.dyc.oc.components.ordSourceProcessor.UocOrderSourceProcessorManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;

/**
 * 标题:UocEsSyncBeanPostProcessor
 * 说明:IUocEsSync后置处理器
 * 时间:2022/3/1 12:40
 * 作者:田桂银
 */
@Component
public class UocBeanPostProcessor implements BeanPostProcessor {

	@Autowired
	private UocEsSyncManager manager;

	@Autowired
	private EventConsumerManger eventConsumerManger;

	@Autowired
	private UocOrderSourceProcessorManager uocOrderSourceProcessorManager;

	@Autowired
	private UocNoticeProcessorManager uocNoticeProcessorManager;


	@Override
	public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
		if (bean instanceof IUocEsSync) {
			manager.register((IUocEsSync) bean);
		} else if (bean instanceof EventConsumer) {
			eventConsumerManger.register((EventConsumer) bean);
		} else if (bean instanceof UocOrderSourceProcessor) {
			uocOrderSourceProcessorManager.register((UocOrderSourceProcessor) bean);
		} else if (bean instanceof UocNoticeProcessor) {
			uocNoticeProcessorManager.register((UocNoticeProcessor) bean);
		}
        return bean;
    }

}


