package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateSaleOrderPayStateServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateSaleOrderPayStateServiceRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Objects;

/**
 * 描述: 〈领域服务-更新销售单支付状态服务 实现〉
 * @author : 王钟游
 * @date : 2022-09-08 16:47
 */
@HTServiceImpl
public class UocUpdateSaleOrderPayStateServiceImpl implements UocUpdateSaleOrderPayStateService {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocUpdateSaleOrderPayStateServiceRspBo updatePayState(UocUpdateSaleOrderPayStateServiceReqBo reqBo) {
        //参数校验
        this.verifyParam(reqBo);
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo saleOrderMain = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if(Objects.nonNull(saleOrderMain)) {
            uocSaleOrderDo.setOrderId(saleOrderMain.getOrderId());
            uocSaleOrderDo.setPayState(reqBo.getPayState());
            iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
        }
        UocUpdateSaleOrderPayStateServiceRspBo rspBo = new UocUpdateSaleOrderPayStateServiceRspBo();
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBo;
    }

    private void verifyParam(UocUpdateSaleOrderPayStateServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == (reqBo.getPayState())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[payState]属性不能为空");
        }
        if (null == (reqBo.getSaleOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[saleVoucherId]属性不能为空");
        }
    }
}
