package com.tydic.dyc.oc.components.event.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocEventConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 标题:EventConsumerSaleCommit
 * 说明:销售单提交
 * 时间:2022/3/11 18:49
 * 作者:田桂银
 */
@Component
@Slf4j

public class EventConsumerSaleCommit implements EventConsumer {
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerSaleCommit->{}", JSON.toJSONString(map));

        Long orderId = Long.valueOf((String) map.get("orderId"));
        Long saleOrderId = Long.valueOf((String) map.get("saleOrderId"));
        List<IUocEsSyncQryEventReqBo> retList = new ArrayList<>();

        IUocEsSyncQryEventReqBo saleEvent = new IUocEsSyncQryEventReqBo();
        retList.add(saleEvent);
        saleEvent.setIndexName(uocIndexConfig.getSaleOrderIndex());

        List<IUocEsSyncQryReqBo> saleList = new ArrayList<>();
        saleEvent.setDataList(saleList);

        IUocEsSyncQryReqBo sale = new IUocEsSyncQryReqBo();
        sale.setOrderId(orderId);
        sale.setObjId(saleOrderId);

        saleList.add(sale);

        return retList;
    }

    @Override
    public String getEvent() {
        return UocEventConstant.UOC_SALE_COMMIT_SYNC;
    }
}


