/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.UocUpdateSaleOrderPayStateService;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateSaleOrderPayStateServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateSaleOrderPayStateServiceRspBo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocUpdateSaleOrderPayStateService"})
public class UocUpdateSaleOrderPayStateServiceImpl
implements UocUpdateSaleOrderPayStateService {
    private static final Logger log = LoggerFactory.getLogger(UocUpdateSaleOrderPayStateServiceImpl.class);
    public static final List<String> pCodeList = ListUtil.list((boolean)false);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private UocEsSyncManager uocEsSyncManager;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @PostMapping(value={"updatePayState"})
    public UocUpdateSaleOrderPayStateServiceRspBo updatePayState(@RequestBody UocUpdateSaleOrderPayStateServiceReqBo reqBo) {
        this.verifyParam(reqBo);
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (Objects.nonNull(saleOrderMain)) {
            uocSaleOrderDo.setOrderId(saleOrderMain.getOrderId());
            uocSaleOrderDo.setPayState(reqBo.getPayState());
            this.iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
        }
        Map<String, Map<String, String>> dictionaryMap = this.iUocSysDictionaryModel.getDictionaryMap(pCodeList);
        String payStateStr = null;
        if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_PAY_STATE")) && ObjectUtil.isNotEmpty((Object)reqBo.getPayState())) {
            payStateStr = dictionaryMap.get("UOC_SALE_ORDER_PAY_STATE").get(reqBo.getPayState().toString());
        }
        this.syncEs(saleOrderMain.getSaleOrderId(), reqBo.getPayState(), payStateStr);
        UocUpdateSaleOrderPayStateServiceRspBo rspBo = new UocUpdateSaleOrderPayStateServiceRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void verifyParam(UocUpdateSaleOrderPayStateServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getPayState()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[payState]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[saleVoucherId]\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void syncEs(Long objId, Integer payState, String payStateStr) {
        UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
        uocEsSyncManagerSaveDataReqBo.setObjId(objId);
        uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("payState", (Object)payState);
        jsonObj.put("payStateStr", (Object)payStateStr);
        uocEsSyncManagerSaveDataReqBo.setJsonObj(jsonObj);
        log.info("\u66f4\u65b0\u9500\u552e\u5355\u652f\u4ed8\u72b6\u6001uocEsSyncManagerSaveDataReqBo\u4e3a{}", (Object)JSONObject.toJSONString((Object)uocEsSyncManagerSaveDataReqBo));
        this.uocEsSyncManager.updateData(uocEsSyncManagerSaveDataReqBo);
    }

    private static void initialize() {
        pCodeList.add("UOC_SALE_ORDER_PAY_STATE");
    }

    static {
        UocUpdateSaleOrderPayStateServiceImpl.initialize();
    }
}

