/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderObjQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderObj;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.audit.sub.UocAuditOrder;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocDMsgPoolQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocEvaluateQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderMapQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocEvaluate;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.order.sub.UocOrderMap;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.sub.UocOrderShouldPay;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleItemMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspVerifyInfoBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UocEsSyncSale
implements IUocEsSync {
    private static final Logger log = LoggerFactory.getLogger(UocEsSyncSale.class);
    public static final List<String> pCodeList = ListUtil.list((boolean)false);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private static final String LINE = "_";

    @Override
    public String indexName() {
        return this.uocIndexConfig.getSaleOrderIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        List<UocOrderAgreement> agreementOrderList;
        List priceChngList;
        log.info("syncSaleOrderReq,{}", (Object)JSON.toJSONString((Object)reqBo));
        IUocEsSyncQryRspBo rspBo = new IUocEsSyncQryRspBo();
        rspBo.setObjId(reqBo.getObjId());
        UocSaleOrderDo saleOrderSubject = this.getSaleOrderSubject(reqBo);
        if (Objects.isNull(saleOrderSubject)) {
            return rspBo;
        }
        Map<String, Map<String, String>> dictionaryMap = this.iUocSysDictionaryModel.getDictionaryMap(pCodeList);
        UocGetSaleOrderDetailServiceRspPorcBo busiProcInst = this.getProcInst(reqBo, false, UocDicConstant.OBJ_TYPE.SALE);
        UocGetSaleOrderDetailServiceRspPorcBo auditProcInst = this.getAuditProcInst(reqBo, UocDicConstant.OBJ_TYPE.SALE);
        List<UocAuditOrderDo> auditOrderList = this.getAuditOrderList(reqBo.getOrderId(), reqBo.getObjId(), UocDicConstant.OBJ_TYPE.SALE);
        List<UocAuditOrderDo> wholeAuditOrderList = this.getAuditOrderList(reqBo.getOrderId(), reqBo.getOrderId(), UocDicConstant.OBJ_TYPE.ORDER);
        List<UocSaleOrderMap> saleOrderMapList = this.getSaleOrderMapList(reqBo, "");
        List<UocOrderAccessory> saleOrderAccessoryList = this.getSaleOrderAccessoryList(reqBo);
        List<UocSaleOrderPayConf> saleOrderPayConfList = this.getSaleOrderPayConfList(reqBo);
        List<UocSaleOrderItem> saleOrderItemList = this.getSaleOrderItemList(reqBo);
        List<UocSaleItemMap> saleOrderItemMapList = this.getSaleOrderItemMapList(reqBo);
        List<UocOrderMap> orderMapList = this.getOrderMapList(reqBo.getOrderId());
        List<UocEvaluate> evaluates = this.getEvaluates(reqBo);
        UocOrderDo uocOrderDo = this.getUocOrderDo(reqBo);
        List<UocOrderShouldPay> shouldPayList = this.getShouldPayList(reqBo);
        List<UocAfOrderObj> uocAfOrderObjList = this.getAfOrderObjList(reqBo);
        List<UocAfOrder> uocAfOrderList = this.getAfOrderDoList(reqBo);
        List<UocChngOrderObj> uocChngOrderObjList = this.getChngOrderObjList(reqBo);
        UocOrdLogisticsRela logistics = this.getLogistics(reqBo, uocOrderDo);
        List<UocChngOrderDo> chngOrderList = this.getChngOrderList(reqBo);
        Map<Object, Object> saleItemMaps = new HashMap();
        if (ObjectUtil.isNotEmpty(saleOrderItemMapList)) {
            saleItemMaps = saleOrderItemMapList.stream().collect(Collectors.groupingBy(UocSaleItemMap::getSaleOrderItemId));
        }
        saleOrderSubject.setSaleOrderPayConfList(saleOrderPayConfList);
        saleOrderSubject.setSaleOrderAccessoryList(saleOrderAccessoryList);
        JSONObject saleOrderObj = JSON.parseObject((String)JSON.toJSONString((Object)saleOrderSubject));
        if (null != saleOrderSubject.getOrderSource()) {
            saleOrderObj.put("orderSource", (Object)saleOrderSubject.getOrderSource().toString());
        }
        if (null != saleOrderSubject.getJdCz()) {
            saleOrderObj.put("jdczFlag", (Object)saleOrderSubject.getJdCz());
        }
        if (ObjectUtil.isNotEmpty(saleOrderMapList)) {
            saleOrderMapList.forEach(each -> saleOrderObj.put(each.getFieldCode(), (Object)each.getFieldValue()));
        }
        if (ObjectUtil.isNotEmpty((Object)saleOrderSubject.getStakeholder())) {
            saleOrderObj.putAll(BeanUtil.beanToMap((Object)saleOrderSubject.getStakeholder(), (boolean)false, (boolean)true));
        }
        this.dealAfOrderFlag(saleOrderObj, uocAfOrderObjList);
        List afIds = (List)saleOrderObj.get((Object)"afOrderId");
        BigDecimal returnFee = new BigDecimal("0");
        if (ObjectUtil.isNotEmpty((Object)afIds)) {
            for (String afId : afIds) {
                UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
                uocAfOrderQryBo.setAfOrderId(Long.valueOf(afId));
                UocAfOrder uocAfOrder = this.iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
                if (!UocDicConstant.SERVICE_TYPE.RETURN_GOODS.equals(uocAfOrder.getServType())) continue;
                returnFee = returnFee.add(uocAfOrder.getRealReturnFee());
            }
        }
        if (null != saleOrderSubject.getTotalPurchaseFee() && saleOrderSubject.getTotalPurchaseFee().compareTo(returnFee) == 0) {
            saleOrderObj.put("isAllReturn", (Object)"1");
        }
        this.dealAfOrderFlagDetail(saleOrderObj, uocAfOrderList);
        this.dealChngOrder(saleOrderObj, uocChngOrderObjList);
        if (ObjectUtil.isNotEmpty(saleOrderItemList)) {
            JSONArray saleOrdeItemArray = new JSONArray();
            ArrayList<String> skuIdList = new ArrayList<String>();
            ArrayList<String> skuNameList = new ArrayList<String>();
            ArrayList<String> commodityIdList = new ArrayList<String>();
            ArrayList<String> commodityNameList = new ArrayList<String>();
            Integer isReturnFlag = UocDicConstant.IS_RETURN_FLAG.NO;
            for (UocSaleOrderItem item : saleOrderItemList) {
                List uocSaleItemMapList;
                if (null == item.getSaleFee() && null != item.getSalePrice() && null != item.getPurchaseCount()) {
                    item.setSaleFee(item.getSalePrice().multiply(item.getPurchaseCount()));
                }
                JSONObject saleItemObj = JSON.parseObject((String)JSON.toJSONString((Object)item, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                if (ObjectUtil.isNotEmpty(saleItemMaps) && saleItemMaps.containsKey(item.getSaleOrderItemId()) && ObjectUtil.isNotEmpty((Object)(uocSaleItemMapList = (List)saleItemMaps.get(item.getSaleOrderItemId())))) {
                    uocSaleItemMapList.forEach(each -> saleItemObj.put(each.getFieldCode(), (Object)each.getFieldValue()));
                }
                saleOrdeItemArray.add((Object)saleItemObj);
                if (ObjectUtil.isNotEmpty((Object)item.getSkuId())) {
                    skuIdList.add(item.getSkuId());
                }
                if (ObjectUtil.isNotEmpty((Object)item.getSkuName())) {
                    skuNameList.add(item.getSkuName());
                }
                if (ObjectUtil.isNotEmpty((Object)item.getCommodityId())) {
                    commodityIdList.add(item.getCommodityId());
                }
                if (ObjectUtil.isNotEmpty((Object)item.getCommodityName())) {
                    commodityNameList.add(item.getCommodityName());
                }
                if (item.getReturnCount().compareTo(BigDecimal.ZERO) <= 0) continue;
                isReturnFlag = UocDicConstant.IS_RETURN_FLAG.YES;
            }
            saleOrderObj.put("saleOrderItems", (Object)saleOrdeItemArray);
            saleOrderObj.put("isReturnFlag", (Object)isReturnFlag);
            saleOrderObj.put("skuName", skuNameList);
            saleOrderObj.put("skuId", skuIdList);
            saleOrderObj.put("commodityId", commodityIdList);
            saleOrderObj.put("commodityName", commodityNameList);
            saleOrderObj.put("auditOrderBoList", auditOrderList);
            saleOrderObj.put("wholeAuditOrderBoList", wholeAuditOrderList);
            saleOrderObj.put("busiProcInstId", (Object)busiProcInst.getProcInstId());
            saleOrderObj.put("auditProcInstId", (Object)auditProcInst.getProcInstId());
            saleOrderObj.put("priceAuditProcInstId", (Object)auditProcInst.getPriceProcInstId());
            saleOrderObj.put("auditTaskList", (Object)auditProcInst.getTaskList());
            saleOrderObj.put("auditProcDefId", (Object)auditProcInst.getProcDefId());
            saleOrderObj.put("busiTaskList", (Object)busiProcInst.getTaskList());
            saleOrderObj.put("busiProcStateList", ObjectUtil.isNotEmpty((Object)busiProcInst.getTaskList()) ? busiProcInst.getTaskList().stream().map(UocGetSaleOrderDetailServiceRspTaskBo::getProcState).collect(Collectors.toList()) : new ArrayList());
            saleOrderObj.put("auditProcStateList", ObjectUtil.isNotEmpty((Object)auditProcInst.getTaskList()) ? auditProcInst.getTaskList().stream().map(UocGetSaleOrderDetailServiceRspTaskBo::getProcState).collect(Collectors.toList()) : new ArrayList());
        }
        if (ObjectUtil.isNotEmpty(orderMapList)) {
            orderMapList.forEach(each -> saleOrderObj.put(each.getFieldCode(), (Object)each.getFieldValue()));
        }
        if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(saleOrderSubject.getOrderSource())) {
            List<UocOrderQueryIndex> orderQueryIndexList = this.getOrderQueryIndexList(reqBo);
            List<UocDMsgPoolQryBo> dMsgList = this.getDMsgList(reqBo);
            if (ObjectUtil.isNotEmpty(orderQueryIndexList)) {
                saleOrderObj.put("outOrderId", (Object)orderQueryIndexList.get(0).getOutObjId());
            }
            if (ObjectUtil.isNotEmpty(dMsgList)) {
                saleOrderObj.put("vendorOrderType", (Object)dMsgList.get(0).getOrderType());
                if (null != dMsgList.get(0).getOrderType()) {
                    saleOrderObj.put("vendorOrderTypeStr", (Object)dictionaryMap.get("VENDOR_ORDER_TYPE").get(dMsgList.get(0).getOrderType().toString()));
                }
            }
        }
        if (null != uocOrderDo) {
            saleOrderObj.put("orderSystem", (Object)uocOrderDo.getOrderSystem());
            saleOrderObj.put("orderNoAndSaleOrderNo", (Object)(uocOrderDo.getOrderNo() + "-" + saleOrderSubject.getSaleOrderNo()));
        }
        if (null != logistics) {
            saleOrderObj.put("orderLogisticsRela", (Object)logistics);
        }
        UocGetSaleOrderDetailServiceRspVerifyInfoBo verifyInfoBo = null;
        if (ObjectUtil.isNotEmpty(chngOrderList)) {
            verifyInfoBo = new UocGetSaleOrderDetailServiceRspVerifyInfoBo();
            verifyInfoBo.setAdjustName(chngOrderList.get(0).getCreateOperName());
            verifyInfoBo.setAdjustTime(chngOrderList.get(0).getCreateTime());
            verifyInfoBo.setRemark(chngOrderList.get(0).getRemark());
        } else {
            List<UocSaleOrderMap> saleOrderExpandList = this.getSaleOrderMapList(reqBo, "SKIP_ADJUST_PRICE_MEN");
            if (ObjectUtil.isNotEmpty(saleOrderExpandList)) {
                verifyInfoBo = new UocGetSaleOrderDetailServiceRspVerifyInfoBo();
                verifyInfoBo.setAdjustName(saleOrderExpandList.get(0).getFieldValue());
                verifyInfoBo.setAdjustTime(saleOrderExpandList.get(0).getCreateTime());
                verifyInfoBo.setRemark(saleOrderExpandList.get(0).getRemark());
            }
        }
        Boolean isAdjustPrice = false;
        if (ObjectUtil.isNotEmpty(uocChngOrderObjList) && ObjectUtil.isNotEmpty(priceChngList = uocChngOrderObjList.stream().filter(each -> ObjectUtil.equal((Object)each.getChngType(), (Object)UocConstant.BUSI_TYPE.PRICE_CHG)).collect(Collectors.toList()))) {
            isAdjustPrice = true;
        }
        saleOrderObj.put("isAdjustPrice", (Object)isAdjustPrice);
        if (null != uocOrderDo) {
            saleOrderObj.put("orderNo", (Object)uocOrderDo.getOrderNo());
        }
        if (ObjectUtil.isNotEmpty(evaluates)) {
            saleOrderObj.put("evaluateState", (Object)evaluates.get(0).getEvaluateState());
        } else {
            saleOrderObj.put("evaluateState", (Object)UocDicConstant.EVA_ACT.NOT_RATED);
        }
        if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderSubject.getOrderSource()) && ObjectUtil.isNotEmpty(agreementOrderList = this.getAgreementOrderList(saleOrderSubject))) {
            this.putAgreementInfo(agreementOrderList, saleOrderObj);
        }
        this.putShouldPayInfo(saleOrderObj, shouldPayList, dictionaryMap);
        this.putShipInfo(saleOrderObj, reqBo);
        this.putInspInfo(saleOrderObj, reqBo);
        this.putDoneTask(saleOrderObj, reqBo);
        this.putEnableStateChngFlag(saleOrderObj, reqBo);
        this.putVerifyInfo(verifyInfoBo, saleOrderObj);
        rspBo.setJsonObj(saleOrderObj);
        this.putState(busiProcInst, saleOrderSubject.getOrderSource(), saleOrderSubject.getSaleOrderState(), rspBo, dictionaryMap);
        this.translateProperties(rspBo, dictionaryMap);
        this.judgeSupplierConfirm(rspBo);
        log.info("\u9500\u552e\u5355es\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)rspBo));
        return rspBo;
    }

    private void judgeSupplierConfirm(IUocEsSyncQryRspBo rspBo) {
        JSONObject jsonObj = rspBo.getJsonObj();
        Boolean isSupConfirm = false;
        String saleOrderStateStr = jsonObj.getString("saleOrderStateStr");
        if (ObjectUtil.notEqual((Object)saleOrderStateStr, (Object)"\u5206\u914d\u4e2d") && ObjectUtil.notEqual((Object)saleOrderStateStr, (Object)"\u6838\u5b9e\u4e2d") && ObjectUtil.notEqual((Object)saleOrderStateStr, (Object)"\u590d\u6838\u4e2d") && ObjectUtil.notEqual((Object)saleOrderStateStr, (Object)"\u5f85\u786e\u8ba4")) {
            isSupConfirm = true;
        }
        jsonObj.put("isSupplierConfirmFlag", (Object)isSupConfirm);
    }

    private List<UocChngOrderDo> getChngOrderList(IUocEsSyncQryReqBo reqBo) {
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setOrderId(reqBo.getOrderId());
        uocChngOrderQryBo.setBusiTypeList(Arrays.asList(UocConstant.BUSI_TYPE.PRICE_CHG));
        return this.iUocChngOrderModel.getListChngOrder(uocChngOrderQryBo);
    }

    private UocOrdLogisticsRela getLogistics(IUocEsSyncQryReqBo reqBo, UocOrderDo uocOrderDo) {
        UocOrdLogisticsRela logisticsRela = new UocOrdLogisticsRela();
        if (null != uocOrderDo) {
            UocOrdLogisticsRelaQryBo relaQryBo = new UocOrdLogisticsRelaQryBo();
            relaQryBo.setOrderId(reqBo.getOrderId());
            relaQryBo.setContactId(uocOrderDo.getContactId());
            logisticsRela = this.iUocOrderModel.qryOrderLogisticsRela(relaQryBo);
        }
        return logisticsRela;
    }

    private void putEnableStateChngFlag(JSONObject saleOrderObj, IUocEsSyncQryReqBo reqBo) {
        List<UocShipOrderDo> shipOrderList = this.getShipOrderList(reqBo);
        if (CollectionUtil.isNotEmpty(shipOrderList)) {
            Boolean flag = false;
            for (UocShipOrderDo uocShipOrderDo : shipOrderList) {
                UocAfOrderObjQryBo uocAfOrderObjQryBo = new UocAfOrderObjQryBo();
                uocAfOrderObjQryBo.setOrderId(uocShipOrderDo.getOrderId());
                uocAfOrderObjQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
                List<UocAfOrderObj> afOrderObjList = this.iUocAfOrderModel.getAfOrderObjList(uocAfOrderObjQryBo);
                if (CollectionUtil.isNotEmpty(afOrderObjList)) {
                    UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
                    uocAfOrderQryBo.setOrderId(uocShipOrderDo.getOrderId());
                    uocAfOrderQryBo.setAfOrderId(afOrderObjList.get(0).getAfOrderId());
                    UocAfOrder afOrderById = this.iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
                    Integer servState = afOrderById.getServState();
                    if (!UocDicConstant.SERVICE_STATE.CANCEL.equals(servState)) {
                        flag = flag.booleanValue();
                        continue;
                    }
                    if (!flag.booleanValue()) {
                        // empty if block
                    }
                    flag = true;
                    break;
                }
                if (!flag.booleanValue()) {
                    // empty if block
                }
                flag = true;
                break;
            }
            saleOrderObj.put("enableStatChng", (Object)flag);
        }
    }

    private void dealAfOrderFlagDetail(JSONObject saleOrderObj, List<UocAfOrder> uocAfOrderList) {
        if (CollectionUtil.isNotEmpty(uocAfOrderList)) {
            List uocAfOrdersDone = uocAfOrderList.stream().filter(x -> UocDicConstant.SERVICE_STATE.APPROVAL_NOT_PASS.equals(x.getServState()) || UocDicConstant.SERVICE_STATE.COMPLATE.equals(x.getServState())).collect(Collectors.toList());
            List uocAfOrdersing = uocAfOrderList.stream().filter(x -> !UocDicConstant.SERVICE_STATE.COMPLATE.equals(x.getServState()) && !UocDicConstant.SERVICE_STATE.CANCEL.equals(x.getServState())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(uocAfOrdersDone)) {
                saleOrderObj.put("afterOrderFlag", (Object)UocConstant.SALEORDER_SYN_AFTERORDER.DONE);
                return;
            }
            if (CollectionUtil.isNotEmpty(uocAfOrdersing)) {
                saleOrderObj.put("afterOrderFlag", (Object)UocConstant.SALEORDER_SYN_AFTERORDER.ING);
                return;
            }
        }
    }

    private void dealChngOrder(JSONObject saleOrderObj, List<UocChngOrderObj> uocChngOrderObjList) {
        Long chngOrderId = null;
        BigDecimal chngFee = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty(uocChngOrderObjList)) {
            saleOrderObj.put("changeFlag", (Object)false);
            saleOrderObj.put("cancelApplyFlag", (Object)false);
        } else {
            saleOrderObj.put("changeFlag", (Object)true);
            saleOrderObj.put("uocChngOrderObjList", uocChngOrderObjList);
            saleOrderObj.put("chngOrderId", uocChngOrderObjList.stream().map(e -> String.valueOf(e.getChngOrderId())).collect(Collectors.toList()));
            Map<Integer, List<UocChngOrderObj>> chngOrderObjMap = uocChngOrderObjList.stream().collect(Collectors.groupingBy(UocChngOrderObj::getChngType));
            Long adjustCOunt = uocChngOrderObjList.stream().filter(bo -> UocConstant.BUSI_TYPE.PRICE_CHG.equals(bo.getChngType())).count();
            if (adjustCOunt.intValue() == uocChngOrderObjList.size()) {
                saleOrderObj.put("changeFlag", (Object)false);
            }
            List uocChngOrderObjs = chngOrderObjMap.get(UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL).stream().sorted(Comparator.comparing(UocChngOrderObj::getCreateTime).reversed()).collect(Collectors.toList());
            List<UocChngOrderObj> uocChngOrderNums = chngOrderObjMap.get(UocConstant.BUSI_TYPE.NUM);
            List<UocChngOrderObj> uocChngOrderStates = chngOrderObjMap.get(UocConstant.BUSI_TYPE.STATE);
            if (CollectionUtils.isEmpty(uocChngOrderObjs)) {
                saleOrderObj.put("cancelApplyFlag", (Object)false);
            } else {
                saleOrderObj.put("cancelApplyFlag", (Object)true);
                saleOrderObj.put("cancelApplyChngOrderId", (Object)((UocChngOrderObj)uocChngOrderObjs.get(0)).getChngOrderId());
                if (CollectionUtils.isEmpty(uocChngOrderNums) && CollectionUtils.isEmpty(uocChngOrderStates)) {
                    saleOrderObj.put("changeFlag", (Object)false);
                }
            }
            if (ObjectUtil.isNotEmpty(chngOrderObjMap.get(UocConstant.BUSI_TYPE.PRICE_CHG))) {
                List priceChngList = chngOrderObjMap.get(UocConstant.BUSI_TYPE.PRICE_CHG).stream().sorted(Comparator.comparing(UocChngOrderObj::getCreateTime).reversed()).collect(Collectors.toList());
                chngOrderId = ((UocChngOrderObj)priceChngList.get(0)).getChngOrderId();
                if (null != ((UocChngOrderObj)priceChngList.get(0)).getChngFee()) {
                    chngFee = ((UocChngOrderObj)priceChngList.get(0)).getChngFee();
                }
            }
        }
        saleOrderObj.put("priceChngOrderId", chngOrderId == null ? "" : chngOrderId);
        saleOrderObj.put("adjustAlreadyFlag", (Object)(chngOrderId == null ? "false" : "true"));
        saleOrderObj.put("priceChngFee", (Object)chngFee);
    }

    private void dealAfOrderFlag(JSONObject saleOrderObj, List<UocAfOrderObj> uocAfOrderObjList) {
        saleOrderObj.put("afterDetailFlag", (Object)false);
        if (CollectionUtils.isEmpty(uocAfOrderObjList)) {
            saleOrderObj.put("afterFlag", (Object)false);
        } else {
            saleOrderObj.put("afterFlag", (Object)true);
            saleOrderObj.put("afOrderId", uocAfOrderObjList.stream().map(e -> String.valueOf(e.getAfOrderId())).collect(Collectors.toList()));
        }
    }

    private List<UocChngOrderObj> getChngOrderObjList(IUocEsSyncQryReqBo reqBo) {
        UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
        uocChngOrderObjQryBo.setOrderId(reqBo.getOrderId());
        uocChngOrderObjQryBo.setSaleOrderId(reqBo.getObjId());
        return this.iUocChngOrderModel.getChngOrderObjList(uocChngOrderObjQryBo);
    }

    private List<UocAfOrderObj> getAfOrderObjList(IUocEsSyncQryReqBo reqBo) {
        UocAfOrderObjQryBo uocAfOrderObjQryBo = new UocAfOrderObjQryBo();
        uocAfOrderObjQryBo.setOrderId(reqBo.getOrderId());
        uocAfOrderObjQryBo.setSaleOrderId(reqBo.getObjId());
        return this.iUocAfOrderModel.getAfOrderObjList(uocAfOrderObjQryBo);
    }

    private List<UocAfOrder> getAfOrderDoList(IUocEsSyncQryReqBo reqBo) {
        UocAfOrderQryBo uocAfOrderObjQryBo = new UocAfOrderQryBo();
        uocAfOrderObjQryBo.setOrderId(reqBo.getOrderId());
        uocAfOrderObjQryBo.setSaleOrderId(reqBo.getObjId());
        return this.iUocAfOrderModel.getAfOrderList(uocAfOrderObjQryBo);
    }

    private void putDoneTask(JSONObject saleOrderObj, IUocEsSyncQryReqBo reqBo) {
        List<String> doneTask = this.getDoneTask(reqBo);
        saleOrderObj.put("doneTaskTacheCode", doneTask);
    }

    private void putState(UocGetSaleOrderDetailServiceRspPorcBo busiProcInst, Integer orderSource, String saleOrderState, IUocEsSyncQryRspBo rspBo, Map<String, Map<String, String>> dictionaryMap) {
        log.debug("busiProcInst:" + JSON.toJSONString((Object)busiProcInst));
        ArrayList<String> stateList = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)saleOrderState) && StringUtils.isNotBlank((CharSequence)busiProcInst.getProcState())) {
            if ("XS_FH_FHWC".equals(saleOrderState) || "XS_FH_FHZ".equals(saleOrderState)) {
                stateList.add(busiProcInst.getProcState() + LINE + "XS_FH_FHZ");
                stateList.add(busiProcInst.getProcState() + LINE + "XS_FH_FHWC");
            } else if ("XS_FH_DFH".equals(saleOrderState) && "E0009".equals(busiProcInst.getProcState())) {
                stateList.add("E0005");
                stateList.add("E0006");
                stateList.add("E0009_XS_FH_DFH");
            } else if ("XS_YS_BFYS".equals(saleOrderState) || "XS_YS_YS".equals(saleOrderState) || "XS_DH_JS".equals(saleOrderState)) {
                stateList.add(saleOrderState);
            } else {
                stateList.add(busiProcInst.getProcState() + LINE + saleOrderState);
            }
        } else if (StringUtils.isNotBlank((CharSequence)saleOrderState)) {
            stateList.add(saleOrderState);
        } else if (StringUtils.isNotBlank((CharSequence)busiProcInst.getProcState())) {
            if ("E0005".equals(busiProcInst.getProcState()) || "E0006".equals(busiProcInst.getProcState())) {
                stateList.add("E0005");
                stateList.add("E0006");
                stateList.add("E0009_XS_FH_DFH");
            } else {
                stateList.add(busiProcInst.getProcState());
            }
        }
        log.debug("stateList:" + JSON.toJSONString(stateList));
        Integer orderStage = UocDicConstant.ORDER_STAPE.IN_PROGRESS;
        if (!CollectionUtils.isEmpty(stateList)) {
            if (stateList.contains("XS_YS_YS") || stateList.contains("XS_YS_BFYS")) {
                orderStage = UocDicConstant.ORDER_STAPE.TRADE_SUCCESS;
            } else if (stateList.contains("XS_QX_QX") || stateList.contains("XS_XD_SB") || stateList.contains("XS_SP_BH")) {
                orderStage = UocDicConstant.ORDER_STAPE.TRADE_CLOSE;
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_NOARGEE_TACHE_CODE")) && UocConstant.SkuSource.SELF.equals(orderSource)) {
                rspBo.getJsonObj().put("saleOrderStateStr", (Object)dictionaryMap.get("UOC_SALE_ORDER_NOARGEE_TACHE_CODE").get(stateList.get(0)));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_ECOM_TACHE_CODE")) && UocConstant.SkuSource.ELC.equals(orderSource)) {
                rspBo.getJsonObj().put("saleOrderStateStr", (Object)dictionaryMap.get("UOC_SALE_ORDER_ECOM_TACHE_CODE").get(stateList.get(0)));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_ARGEE_TACHE_CODE")) && UocConstant.SkuSource.AGR.equals(orderSource)) {
                rspBo.getJsonObj().put("saleOrderStateStr", (Object)dictionaryMap.get("UOC_SALE_ORDER_ARGEE_TACHE_CODE").get(stateList.get(0)));
            }
        } else {
            rspBo.getJsonObj().put("saleOrderStateStr", (Object)"");
        }
        rspBo.getJsonObj().put("saleOrdTacheState", stateList);
        rspBo.getJsonObj().put("orderStage", (Object)orderStage);
    }

    private List<UocDMsgPoolQryBo> getDMsgList(IUocEsSyncQryReqBo reqBo) {
        UocDMsgPoolQryBo dMsgPoolQryBo = new UocDMsgPoolQryBo();
        dMsgPoolQryBo.setOrderId(reqBo.getOrderId());
        dMsgPoolQryBo.setObjId(reqBo.getObjId());
        dMsgPoolQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        return this.iUocOrderModel.getMsgList(dMsgPoolQryBo);
    }

    private List<UocOrderQueryIndex> getOrderQueryIndexList(IUocEsSyncQryReqBo reqBo) {
        UocOrderQueryIndexQryBo queryIndexQryBo = new UocOrderQueryIndexQryBo();
        queryIndexQryBo.setOrderId(reqBo.getOrderId());
        queryIndexQryBo.setObjId(reqBo.getObjId());
        queryIndexQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        return this.iUocOrderModel.qryOrderQueryIndexList(queryIndexQryBo);
    }

    private void putShouldPayInfo(JSONObject saleOrderObj, List<UocOrderShouldPay> shouldPayList, Map<String, Map<String, String>> dictionaryMap) {
        if (ObjectUtil.isNotEmpty(shouldPayList)) {
            JSONArray shouldPayArray = new JSONArray();
            for (UocOrderShouldPay shouldPay : shouldPayList) {
                JSONObject shouldPayObj = new JSONObject();
                shouldPayObj.put("fscShouldPayId", (Object)shouldPay.getFscShouldPayId());
                shouldPayObj.put("shouldPayAmount", (Object)shouldPay.getShouldPayAmount());
                shouldPayObj.put("paidAmount", (Object)shouldPay.getPaidAmount());
                shouldPayObj.put("shouldPayType", (Object)shouldPay.getShouldPayType());
                shouldPayObj.put("payerId", (Object)shouldPay.getPayerId());
                shouldPayObj.put("payeeId", (Object)shouldPay.getPayeeId());
                shouldPayObj.put("shouldPayCreateTime", (Object)shouldPay.getCreateTime());
                if (null != shouldPay.getShouldPayType()) {
                    shouldPayObj.put("shouldPayTypeStr", (Object)dictionaryMap.get("SHOULD_PAY_TYPE").get(String.valueOf(shouldPay.getShouldPayType())));
                }
                shouldPayArray.add((Object)shouldPayObj);
            }
            saleOrderObj.put("orderShouldPayList", (Object)shouldPayArray);
        }
    }

    private List<UocOrderShouldPay> getShouldPayList(IUocEsSyncQryReqBo reqBo) {
        UocOrderShouldPay shouldPay = new UocOrderShouldPay();
        shouldPay.setObjectId(reqBo.getObjId());
        shouldPay.setOrderId(reqBo.getOrderId());
        shouldPay.setObjectType(UocDicConstant.OBJ_TYPE.SALE);
        shouldPay.setIsPayCompleted(UocDicConstant.FINISH_FLAG.UN_FINISHED);
        return this.iUocPayOrderModel.getListOrderShouldPay(shouldPay);
    }

    private UocOrderDo getUocOrderDo(IUocEsSyncQryReqBo reqBo) {
        UocOrderDo qryBo = new UocOrderDo();
        qryBo.setOrderId(reqBo.getOrderId());
        return this.iUocOrderModel.qryOrderBy(qryBo);
    }

    private List<UocEvaluate> getEvaluates(IUocEsSyncQryReqBo reqBo) {
        UocEvaluateQryBo uocEvaluateQryBo = new UocEvaluateQryBo();
        uocEvaluateQryBo.setOrderId(reqBo.getOrderId());
        uocEvaluateQryBo.setObjId(reqBo.getObjId());
        uocEvaluateQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        return this.iUocOrderModel.qryOrderEvaluateList(uocEvaluateQryBo);
    }

    private void putAgreementInfo(List<UocOrderAgreement> agreementOrderList, JSONObject saleOrderObj) {
        UocOrderAgreement agreement = agreementOrderList.get(0);
        saleOrderObj.put("agreementCode", (Object)agreement.getAgreementCode());
        saleOrderObj.put("plaAgreementCode", (Object)agreement.getPlaAgreementCode());
        saleOrderObj.put("agreementName", (Object)agreement.getAgreementName());
    }

    private void putVerifyInfo(UocGetSaleOrderDetailServiceRspVerifyInfoBo verifyInfoBo, JSONObject saleOrderObj) {
        if (null != verifyInfoBo) {
            saleOrderObj.put("verifyInfo", (Object)verifyInfoBo);
        }
    }

    private List<UocOrderAgreement> getAgreementOrderList(UocSaleOrderDo saleOrderSubject) {
        UocOrderAgreementQryBo uocOrderAgreementQryBo = new UocOrderAgreementQryBo();
        uocOrderAgreementQryBo.setOrderId(saleOrderSubject.getOrderId());
        uocOrderAgreementQryBo.setId(saleOrderSubject.getAgrDataId());
        return this.iUocSaleOrderModel.getAgreementOrderList(uocOrderAgreementQryBo);
    }

    private static void initialize() {
        pCodeList.add("UOC_SALE_ORDER_STATE");
        pCodeList.add("UOC_SALE_ORDER_ARGEE_TACHE_CODE");
        pCodeList.add("UOC_SALE_ORDER_NOARGEE_TACHE_CODE");
        pCodeList.add("UOC_SALE_ORDER_ECOM_TACHE_CODE");
        pCodeList.add("UOC_SALE_ORDER_SOURCE");
        pCodeList.add("UOC_SALE_ORDER_PAY_TYPE");
        pCodeList.add("UOC_SALE_ORDER_PAY_STATE");
        pCodeList.add("UOC_COMMON_FINISH_FLAG");
        pCodeList.add("UOC_COMMON_CANCEL_FLAG");
        pCodeList.add("UOC_COMMON_MODEL_SETTLE");
        pCodeList.add("UOC_COMMON_PURCHASE_TYPE");
        pCodeList.add("UOC_COMMON_PURCHASE_MODE");
        pCodeList.add("UOC_COMMON_ITEM_TYPE");
        pCodeList.add("UOC_ORD_AGREEMENT_MODE");
        pCodeList.add("ORDER_STAPE");
        pCodeList.add("IS_RETURN_FLAG");
        pCodeList.add("EVALUATE_STATE");
        pCodeList.add("SHOULD_PAY_TYPE");
        pCodeList.add("VENDOR_ORDER_TYPE");
    }

    private void translateProperties(IUocEsSyncQryRspBo rspBo, Map<String, Map<String, String>> dictionaryMap) {
        JSONObject jsonObj = rspBo.getJsonObj();
        if (ObjectUtil.isNotEmpty(dictionaryMap)) {
            List<UocSaleOrderItem> saleOrderItems;
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_SOURCE")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"orderSource"))) {
                String ordSourceCode = jsonObj.getString("orderSource");
                jsonObj.put("orderSourceStr", (Object)dictionaryMap.get("UOC_SALE_ORDER_SOURCE").get(ordSourceCode));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_PAY_STATE")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"payState"))) {
                String payStateCode = jsonObj.getString("payState");
                jsonObj.put("payStateStr", (Object)dictionaryMap.get("UOC_SALE_ORDER_PAY_STATE").get(payStateCode));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_FINISH_FLAG")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"finishFlag"))) {
                String finishFlagCode = jsonObj.getString("finishFlag");
                jsonObj.put("finishFlagStr", (Object)dictionaryMap.get("UOC_COMMON_FINISH_FLAG").get(finishFlagCode));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_CANCEL_FLAG")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"cancelFlag"))) {
                String cancelFlagCode = jsonObj.getString("cancelFlag");
                jsonObj.put("cancelFlagStr", (Object)dictionaryMap.get("UOC_COMMON_CANCEL_FLAG").get(cancelFlagCode));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_MODEL_SETTLE")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"modelSettle"))) {
                String modelSettleCode = jsonObj.getString("modelSettle");
                jsonObj.put("modelSettleStr", (Object)dictionaryMap.get("UOC_COMMON_MODEL_SETTLE").get(modelSettleCode));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_PURCHASE_TYPE")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"purchaseType"))) {
                String purchaseTypeCode = jsonObj.getString("purchaseType");
                jsonObj.put("purchaseTypeStr", (Object)dictionaryMap.get("UOC_COMMON_PURCHASE_TYPE").get(purchaseTypeCode));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_PURCHASE_MODE")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"purchaseMode"))) {
                String purchaseModeCode = jsonObj.getString("purchaseMode");
                jsonObj.put("purchaseModeStr", (Object)dictionaryMap.get("UOC_COMMON_PURCHASE_MODE").get(purchaseModeCode));
            }
            List<Object> payConfList = new ArrayList();
            if (ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"saleOrderPayConfList")) && ObjectUtil.isNotEmpty(payConfList = UocRu.jsl(jsonObj.get((Object)"saleOrderPayConfList"), UocSaleOrderPayConf.class))) {
                payConfList.forEach(each -> {
                    if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_PAY_TYPE")) && ObjectUtil.isNotEmpty((Object)each.getPayType())) {
                        each.setPayTypeStr((String)((Map)dictionaryMap.get("UOC_SALE_ORDER_PAY_TYPE")).get(each.getPayType().toString()));
                    }
                });
            }
            jsonObj.put("saleOrderPayConfList", (Object)JSON.parseArray((String)JSON.toJSONString(payConfList)));
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_PAY_TYPE")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"payType"))) {
                String payType = jsonObj.getString("payType");
                jsonObj.put("payTypeStr", (Object)dictionaryMap.get("UOC_SALE_ORDER_PAY_TYPE").get(payType));
            }
            if (ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"saleOrderItems")) && ObjectUtil.isNotEmpty(saleOrderItems = UocRu.jsl(jsonObj.get((Object)"saleOrderItems"), UocSaleOrderItem.class))) {
                saleOrderItems.forEach(each -> {
                    if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_ITEM_TYPE")) && ObjectUtil.isNotEmpty((Object)each.getItemType())) {
                        each.setItemTypeStr((String)((Map)dictionaryMap.get("UOC_COMMON_ITEM_TYPE")).get(each.getItemType().toString()));
                    }
                });
                jsonObj.put("saleOrderItems", (Object)JSON.parseArray((String)JSON.toJSONString(saleOrderItems)));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_PURCHASE_TYPE")) && ObjectUtil.isNotNull((Object)jsonObj.get((Object)"isArrivalRegist"))) {
                boolean isArrivalRegist = jsonObj.getBooleanValue("isArrivalRegist");
                jsonObj.put("isArrivalRegistStr", (Object)(isArrivalRegist ? "\u662f" : "\u5426"));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORD_AGREEMENT_MODE")) && ObjectUtil.isNotNull((Object)jsonObj.get((Object)"agreementCode"))) {
                String agreementCode = jsonObj.getString("agreementCode");
                jsonObj.put("agreementCodeStr", (Object)dictionaryMap.get("UOC_ORD_AGREEMENT_MODE").get(agreementCode));
            }
            if (null != dictionaryMap.get("EVALUATE_STATE") && null != jsonObj.get((Object)"evaluateState")) {
                jsonObj.put("evaluateStateStr", (Object)dictionaryMap.get("EVALUATE_STATE").get(jsonObj.getString("evaluateState")));
            }
            if (null != dictionaryMap.get("IS_RETURN_FLAG") && null != jsonObj.get((Object)"isReturnFlag")) {
                jsonObj.put("isReturnFlagStr", (Object)dictionaryMap.get("IS_RETURN_FLAG").get(jsonObj.getString("isReturnFlag")));
            }
            if (null != dictionaryMap.get("ORDER_STAPE") && null != jsonObj.get((Object)"orderStage")) {
                jsonObj.put("orderStageStr", (Object)dictionaryMap.get("ORDER_STAPE").get(jsonObj.getString("orderStage")));
            }
        }
    }

    private UocGetSaleOrderDetailServiceRspPorcBo getProcInst(IUocEsSyncQryReqBo reqBo, Boolean isAudit, Integer objType) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        if (isAudit.booleanValue()) {
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        } else {
            procInstQryBo.setObjId(reqBo.getObjId());
            procInstQryBo.setObjType(objType);
        }
        procInstQryBo.setOrderId(reqBo.getOrderId());
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderProcInst> uocOrderProcInsts = this.iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            procInst = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class).get(0);
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setObjId(procInst.getObjId());
            taskInstQryBo.setObjType(procInst.getObjType());
            ArrayList<Integer> finishTagList = new ArrayList<Integer>();
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            taskInstQryBo.setFinishTagList(finishTagList);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<Object> taskBoList = new ArrayList();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setObjId(each.getObjId());
                    taskDealQryBo.setObjType(each.getObjType());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = this.iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList());
                });
                procInst.setProcState(uocOrderTaskInsts.get(0).getProcState());
                procInst.setTaskId(uocOrderTaskInsts.get(0).getTaskInstId());
            }
            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }

    private UocGetSaleOrderDetailServiceRspPorcBo getAuditProcInst(IUocEsSyncQryReqBo reqBo, Integer objType) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
        if (UocDicConstant.OBJ_TYPE.SALE.equals(objType)) {
            uocApprovalObjQryBo.setObjId(reqBo.getObjId() + "");
            uocApprovalObjQryBo.setObjType(objType);
        } else {
            uocApprovalObjQryBo.setObjId(reqBo.getOrderId() + "");
            uocApprovalObjQryBo.setObjType(objType);
        }
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        if (CollectionUtil.isNotEmpty(uocApprovalObjs)) {
            List<Long> auditOrderIds = uocApprovalObjs.stream().map(UocApprovalObj::getAuditOrderId).collect(Collectors.toList());
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setOrderId(reqBo.getOrderId());
            taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
            taskInstQryBo.setObjIdList(auditOrderIds);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<Object> taskBoList = new ArrayList();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                List priceTaskList;
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocApprovalObjQryBo uocApprovalObjQryBo1 = new UocApprovalObjQryBo();
                    uocApprovalObjQryBo1.setAuditOrderId(each.getObjId());
                    List<UocApprovalObj> uocApprovalObjs1 = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo1);
                    Integer objBusiType = uocApprovalObjs1.get(0).getObjBusiType();
                    each.setObjBusiType(objBusiType);
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = this.iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    if (CollectionUtil.isNotEmpty(uocOrderTaskDeals)) {
                        UocOrderTaskDeal uocOrderTaskDeal = uocOrderTaskDeals.get(0);
                        String dealId = uocOrderTaskDeal.getDealId();
                        String dealName = uocOrderTaskDeal.getDealName();
                        each.setDealId(dealId);
                        each.setDealName(dealName);
                    }
                    String auditDealResultQryKey = each.getDealId() + LINE + each.getObjBusiType();
                    if (each.getDealResult() != null) {
                        auditDealResultQryKey = auditDealResultQryKey + LINE + each.getDealResult();
                    }
                    each.setAuditDealResultQryKey(auditDealResultQryKey);
                    each.setTaskDealBo(CollectionUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList());
                });
                procInst.setTaskList(taskBoList);
                List orderTaskList = procInst.getTaskList().stream().filter(bo -> UocConstant.OBJ_BUSI_TYPE.ORDER.equals(bo.getObjBusiType())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(orderTaskList)) {
                    String procInstId = "";
                    if (orderTaskList.size() == 1) {
                        procInstId = ((UocGetSaleOrderDetailServiceRspTaskBo)orderTaskList.get(0)).getProcInstId();
                    } else {
                        log.debug("\u6392\u5e8f\u524d\uff1a" + JSON.toJSONString(orderTaskList));
                        orderTaskList.sort((m1, m2) -> m2.getCreateTime().compareTo(m1.getCreateTime()));
                        log.debug("\u6392\u5e8f\u540e\uff1a" + JSON.toJSONString(orderTaskList));
                        procInstId = ((UocGetSaleOrderDetailServiceRspTaskBo)orderTaskList.get(0)).getProcInstId();
                    }
                    if (StringUtils.isNotBlank((CharSequence)procInstId)) {
                        procInst.setProcInstId(procInstId);
                    }
                }
                if (!CollectionUtils.isEmpty(priceTaskList = procInst.getTaskList().stream().filter(bo -> UocConstant.OBJ_BUSI_TYPE.PRICE.equals(bo.getObjBusiType())).collect(Collectors.toList()))) {
                    String priceProcInstId = "";
                    if (priceTaskList.size() == 1) {
                        priceProcInstId = ((UocGetSaleOrderDetailServiceRspTaskBo)priceTaskList.get(0)).getProcInstId();
                    } else {
                        log.debug("\u8c03\u4ef7\u6392\u5e8f\u524d\uff1a" + JSON.toJSONString(priceTaskList));
                        priceTaskList.sort((m1, m2) -> m2.getCreateTime().compareTo(m1.getCreateTime()));
                        log.debug("\u8c03\u4ef7\u6392\u5e8f\u540e\uff1a" + JSON.toJSONString(priceTaskList));
                        priceProcInstId = ((UocGetSaleOrderDetailServiceRspTaskBo)priceTaskList.get(0)).getProcInstId();
                    }
                    if (StringUtils.isNotBlank((CharSequence)priceProcInstId)) {
                        procInst.setPriceProcInstId(priceProcInstId);
                    }
                }
            }
        }
        return procInst;
    }

    private List<String> getDoneTask(IUocEsSyncQryReqBo reqBo) {
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setObjId(reqBo.getObjId());
        taskInstQryBo.setOrderId(reqBo.getOrderId());
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        ArrayList<Integer> finishTagList = new ArrayList<Integer>();
        finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
        taskInstQryBo.setFinishTagList(finishTagList);
        List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        if (CollectionUtils.isEmpty(uocOrderTaskInsts)) {
            return new ArrayList<String>();
        }
        return uocOrderTaskInsts.stream().map(UocOrderTaskInst::getProcState).collect(Collectors.toList());
    }

    private void putInspInfo(JSONObject saleOrderObj, IUocEsSyncQryReqBo reqBo) {
        List<UocInspOrderDo> inspOrderList = this.getInspOrderList(reqBo);
        ArrayList inspOrderIdList = new ArrayList();
        ArrayList inspOrderNoList = new ArrayList();
        ArrayList inspOperNameList = new ArrayList();
        ArrayList inspTimeList = new ArrayList();
        inspOrderList.forEach(uocInspOrderDo -> {
            if (null != uocInspOrderDo.getInspOrderId()) {
                inspOrderIdList.add(uocInspOrderDo.getInspOrderId().toString());
            }
            if (StringUtils.isNotBlank((CharSequence)uocInspOrderDo.getInspOper())) {
                inspOperNameList.add(uocInspOrderDo.getInspOper());
            }
            inspOrderNoList.add(uocInspOrderDo.getInspOrderNo());
            inspTimeList.add(uocInspOrderDo.getCreateTime());
        });
        saleOrderObj.put("inspTimeList", inspTimeList);
        saleOrderObj.put("inspoperNameList", inspOperNameList);
        saleOrderObj.put("inspOrderId", inspOrderIdList);
        saleOrderObj.put("inspOrderNo", inspOrderNoList);
        saleOrderObj.put("inspOrderIdQry", (Object)StringUtils.join(inspOrderIdList, (String)"|"));
        saleOrderObj.put("inspOrderNoQry", (Object)StringUtils.join(inspOrderNoList, (String)"|"));
    }

    private void putShipInfo(JSONObject saleOrderObj, IUocEsSyncQryReqBo reqBo) {
        List<UocShipOrderItem> shipOrderItemList;
        List<UocShipOrderDo> shipOrderList = this.getShipOrderList(reqBo);
        if (!CollectionUtils.isEmpty(shipOrderList)) {
            ArrayList shipOrderIdList = new ArrayList();
            ArrayList shipOrderNoList = new ArrayList();
            ArrayList shipOrderStateList = new ArrayList();
            shipOrderList.forEach(uocShipOrderDo -> {
                if (null != uocShipOrderDo.getShipOrderId()) {
                    shipOrderIdList.add(uocShipOrderDo.getShipOrderId().toString());
                }
                shipOrderNoList.add(uocShipOrderDo.getShipOrderNo());
                shipOrderStateList.add(uocShipOrderDo.getShipOrderState());
            });
            boolean isArrivalRegist = false;
            for (UocShipOrderDo uocShipOrderDo2 : shipOrderList) {
                if (!"FH_FH_FH".equals(uocShipOrderDo2.getShipOrderState())) continue;
                isArrivalRegist = true;
                break;
            }
            try {
                if (shipOrderList.stream().allMatch(shipOrder -> null == shipOrder.getInspTime())) {
                    Date lastArriveTime = ((UocShipOrderDo)shipOrderList.stream().sorted(Comparator.comparing(UocShipOrderDo::getArriveTime).reversed()).collect(Collectors.toList()).get(0)).getArriveTime();
                    saleOrderObj.put("lastArriveTime", (Object)lastArriveTime);
                }
            }
            catch (Exception lastArriveTime) {
                // empty catch block
            }
            saleOrderObj.put("shipOrderId", shipOrderIdList);
            saleOrderObj.put("shipOrderNo", shipOrderNoList);
            saleOrderObj.put("shipOrderIdQry", (Object)StringUtils.join(shipOrderIdList, (String)"|"));
            saleOrderObj.put("shipOrderNoQry", (Object)StringUtils.join(shipOrderNoList, (String)"|"));
            saleOrderObj.put("isArrivalRegist", (Object)isArrivalRegist);
            saleOrderObj.put("shipOrderState", shipOrderStateList);
            List<UocOrderTaskInst> taskInst = this.getTaskInst(reqBo.getOrderId(), shipOrderIdList.stream().mapToLong(Long::parseLong).boxed().collect(Collectors.toList()));
            List<Object> procStateList = new ArrayList();
            if (!CollectionUtils.isEmpty(taskInst)) {
                procStateList = taskInst.stream().map(UocOrderTaskInst::getProcState).collect(Collectors.toList());
            }
            saleOrderObj.put("shipOrderTacheCode", procStateList);
        }
        if (ObjectUtil.isNotEmpty(shipOrderItemList = this.getListShipOrderItem(reqBo))) {
            saleOrderObj.put("sendCount", (Object)shipOrderItemList.get(0).getSendCount());
            saleOrderObj.put("refuseCount", (Object)shipOrderItemList.get(0).getRefuseCount());
        }
    }

    private List<UocAuditOrderDo> getAuditOrderList(Long orderId, Long objId, Integer objType) {
        UocApprovalObjQryBo obj = new UocApprovalObjQryBo();
        obj.setOrderId(orderId);
        obj.setObjId(Convert.toStr((Object)objId));
        obj.setObjType(objType);
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(obj);
        if (CollectionUtils.isEmpty(uocApprovalObjs)) {
            return new ArrayList<UocAuditOrderDo>();
        }
        ArrayList<Long> auditOrderIdList = new ArrayList<Long>();
        uocApprovalObjs.forEach(uocApprovalObj -> auditOrderIdList.add(uocApprovalObj.getAuditOrderId()));
        List<UocAuditOrderDo> uocAuditOrderDoList = new ArrayList<UocAuditOrderDo>();
        UocAuditOrderQryBo auditOrderQryBo = new UocAuditOrderQryBo();
        auditOrderQryBo.setOrderId(orderId);
        auditOrderQryBo.setAuditOrderIdList(auditOrderIdList);
        List<UocAuditOrder> uocAuditOrders = this.iUocAuditOrderModel.qryAuditOrderList(auditOrderQryBo);
        if (ObjectUtil.isNotEmpty(uocAuditOrders)) {
            uocAuditOrders.forEach(uocAuditOrder -> {
                UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
                procInstQryBo.setObjId(uocAuditOrder.getAuditOrderId());
                procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
                procInstQryBo.setOrderId(orderId);
                List<UocOrderProcInst> uocOrderProcInsts = this.iUocOrderModel.qryOrderProcInstList(procInstQryBo);
                if (!CollectionUtils.isEmpty(uocOrderProcInsts)) {
                    uocAuditOrder.setProcInstId(uocOrderProcInsts.get(0).getProcInstId());
                }
            });
            uocAuditOrderDoList = UocRu.jsl(uocAuditOrders, UocAuditOrderDo.class);
            Map approvalObjMap = uocApprovalObjs.stream().collect(Collectors.groupingByConcurrent(UocApprovalObj::getAuditOrderId));
            uocAuditOrderDoList.forEach(each -> each.setApprovalObjs((List)approvalObjMap.get(each.getAuditOrderId())));
        }
        return uocAuditOrderDoList;
    }

    private UocSaleOrderDo getSaleOrderSubject(IUocEsSyncQryReqBo reqBo) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(reqBo.getObjId());
        return this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    private List<UocSaleOrderMap> getSaleOrderMapList(IUocEsSyncQryReqBo reqBo, String fieldCode) {
        UocSaleOrderMapQryBo uocSaleOrderMapQryBo = new UocSaleOrderMapQryBo();
        uocSaleOrderMapQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderMapQryBo.setSaleOrderId(reqBo.getObjId());
        if (StringUtils.isNotBlank((CharSequence)fieldCode)) {
            uocSaleOrderMapQryBo.setFieldCode(fieldCode);
        }
        return this.iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
    }

    private List<UocOrderAccessory> getSaleOrderAccessoryList(IUocEsSyncQryReqBo reqBo) {
        UocOrderAccessoryQryBo uocOrderAccessoryQryBo = UocRu.js(reqBo, UocOrderAccessoryQryBo.class);
        uocOrderAccessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        return this.iUocSaleOrderModel.getSaleOrderAccessoryList(uocOrderAccessoryQryBo).getSaleOrderAccessoryList();
    }

    private List<UocSaleOrderPayConf> getSaleOrderPayConfList(IUocEsSyncQryReqBo reqBo) {
        UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
        uocSaleOrderPayConfQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderPayConfQryBo.setSaleOrderId(reqBo.getObjId());
        return this.iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
    }

    private List<UocSaleOrderItem> getSaleOrderItemList(IUocEsSyncQryReqBo reqBo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getObjId());
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    private List<UocSaleItemMap> getSaleOrderItemMapList(IUocEsSyncQryReqBo reqBo) {
        UocSaleItemMapQryBo uocSaleItemMapQryBo = new UocSaleItemMapQryBo();
        uocSaleItemMapQryBo.setSaleOrderId(reqBo.getObjId());
        uocSaleItemMapQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocSaleOrderModel.getSaleOrderItemMapList(uocSaleItemMapQryBo);
    }

    private List<UocShipOrderDo> getShipOrderList(IUocEsSyncQryReqBo reqBo) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getObjId());
        return this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
    }

    private List<UocShipOrderItem> getListShipOrderItem(IUocEsSyncQryReqBo reqBo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getObjId());
        UocShipOrderDo uocShipOrderDo = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        return uocShipOrderDo.getShipOrderItemBoList();
    }

    private List<UocInspOrderDo> getInspOrderList(IUocEsSyncQryReqBo reqBo) {
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setOrderId(reqBo.getOrderId());
        uocInspOrderQryBo.setSaleOrderId(reqBo.getObjId());
        return this.iUocInspOrderModel.getListInspOrder(uocInspOrderQryBo);
    }

    private List<UocOrderTaskInst> getTaskInst(Long orderId, List<Long> objIdList) {
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setObjIdList(objIdList);
        taskInstQryBo.setOrderId(orderId);
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        ArrayList<Integer> finishTagList = new ArrayList<Integer>();
        finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
        taskInstQryBo.setFinishTagList(finishTagList);
        return this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
    }

    private List<UocOrderMap> getOrderMapList(Long orderId) {
        UocOrderMapQryBo uocOrderMapQryBo = new UocOrderMapQryBo();
        uocOrderMapQryBo.setOrderId(orderId);
        return this.iUocOrderModel.qryOrderMapList(uocOrderMapQryBo);
    }

    static {
        UocEsSyncSale.initialize();
    }
}

