/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocShipOrderPrintAbilityService;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrdShipItemPrintRspBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrdShipPrintRspBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderPrintReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocShipOrderPrintRspBO;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.domainservice.UocShipOrderPrintAbilityService"})
public class UocShipOrderPrintAbilityServiceImpl
implements UocShipOrderPrintAbilityService {
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @PostMapping(value={"printShipOrder"})
    public UocShipOrderPrintRspBO printShipOrder(@RequestBody UocShipOrderPrintReqBO reqBO) {
        this.validateArg(reqBO);
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBO.getOrderId());
        uocShipOrderQryBo.setShipOrderId(reqBO.getShipOrderId());
        UocShipOrderDo uocShipOrderDo = this.iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBO.getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderId(reqBO.getShipOrderId());
        UocShipOrderDo uocShipOrderItem = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        List<UocShipOrderItem> shipOrderItemBoList = uocShipOrderItem.getShipOrderItemBoList();
        List<Long> saleOrderItemIds = shipOrderItemBoList.stream().map(UocShipOrderItem::getSaleOrderItemId).collect(Collectors.toList());
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIds);
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        Map<Long, UocSaleOrderItem> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        UocOrdShipPrintRspBO uocOrdShipPrintRspBO = new UocOrdShipPrintRspBO();
        uocOrdShipPrintRspBO.setSaleOrderNo(uocSaleOrderDo.getSaleOrderNo());
        uocOrdShipPrintRspBO.setSaleOrderNoExt(uocSaleOrderDo.getSaleOrderNoExt());
        uocOrdShipPrintRspBO.setSupName(uocSaleOrderDo.getStakeholder().getSupName());
        uocOrdShipPrintRspBO.setPurName(uocSaleOrderDo.getStakeholder().getPurName());
        uocOrdShipPrintRspBO.setShipCompanyNo(uocShipOrderDo.getShipCompanyNo());
        uocOrdShipPrintRspBO.setShipTime(uocShipOrderDo.getShipTime());
        uocOrdShipPrintRspBO.setShipName(uocShipOrderDo.getShipName());
        uocOrdShipPrintRspBO.setShipPhone(uocShipOrderDo.getShipPhone());
        AtomicInteger index = new AtomicInteger(1);
        List uocOrdShipItemPrintRspBOS = shipOrderItemBoList.stream().map(shipOrderItem -> {
            UocSaleOrderItem uocSaleOrderItem = (UocSaleOrderItem)saleOrderItemMap.get(shipOrderItem.getSaleOrderItemId());
            UocOrdShipItemPrintRspBO uocOrdShipItemPrintRspBO = new UocOrdShipItemPrintRspBO();
            uocOrdShipItemPrintRspBO.setIndex(index.getAndIncrement());
            uocOrdShipItemPrintRspBO.setSkuName(uocSaleOrderItem.getSkuName());
            uocOrdShipItemPrintRspBO.setSkuMaterialId(uocSaleOrderItem.getSkuMaterialId());
            uocOrdShipItemPrintRspBO.setSkuMaterialTypeName(uocSaleOrderItem.getSkuMaterialTypeName());
            uocOrdShipItemPrintRspBO.setSkuMaterialName(uocSaleOrderItem.getSkuMaterialName());
            uocOrdShipItemPrintRspBO.setSpec(uocSaleOrderItem.getSpec());
            uocOrdShipItemPrintRspBO.setModel(uocSaleOrderItem.getModel());
            uocOrdShipItemPrintRspBO.setPurchaseCount(uocSaleOrderItem.getPurchaseCount());
            uocOrdShipItemPrintRspBO.setUnitName(uocSaleOrderItem.getUnitName());
            uocOrdShipItemPrintRspBO.setSendCount(shipOrderItem.getSendCount());
            uocOrdShipItemPrintRspBO.setArriveCount(shipOrderItem.getArriveCount());
            uocOrdShipItemPrintRspBO.setEstimateArrivalTime(uocShipOrderDo.getEstimateArrivalTime());
            return uocOrdShipItemPrintRspBO;
        }).collect(Collectors.toList());
        UocShipOrderPrintRspBO uocShipOrderPrintRspBO = UocRu.success(UocShipOrderPrintRspBO.class);
        uocShipOrderPrintRspBO.setOrdShipPrint(uocOrdShipPrintRspBO);
        uocShipOrderPrintRspBO.setOrdShipItemPrintList(uocOrdShipItemPrintRspBOS);
        return uocShipOrderPrintRspBO;
    }

    private void validateArg(UocShipOrderPrintReqBO reqBO) {
        if (null == reqBO) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new BaseBusinessException("100001", "orderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getShipOrderId()) {
            throw new BaseBusinessException("100001", "shipOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

