/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.event.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventConsumerShipArrivaRegist
implements EventConsumer {
    private static final Logger log = LoggerFactory.getLogger(EventConsumerShipArrivaRegist.class);
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerShipArrivaRegist->{}", (Object)JSON.toJSONString(map));
        ArrayList<IUocEsSyncQryEventReqBo> retList = new ArrayList<IUocEsSyncQryEventReqBo>();
        Long orderId = UocRu.parseLong(map.get("orderId"));
        Object shipOrderIdObj = map.get("shipOrderIdList");
        Long saleOrderId = UocRu.parseLong(map.get("saleOrderId"));
        List<Long> shipOrderIdList = UocRu.castList(shipOrderIdObj, Long.class);
        ArrayList<IUocEsSyncQryReqBo> shipList = new ArrayList<IUocEsSyncQryReqBo>();
        shipOrderIdList.forEach(shipOrderId -> {
            IUocEsSyncQryReqBo syncQryReqBo = new IUocEsSyncQryReqBo();
            syncQryReqBo.setOrderId(orderId);
            syncQryReqBo.setObjId((Long)shipOrderId);
            shipList.add(syncQryReqBo);
        });
        IUocEsSyncQryEventReqBo eventReqBo = new IUocEsSyncQryEventReqBo();
        eventReqBo.setIndexName(this.uocIndexConfig.getShipOrderIndex());
        eventReqBo.setDataList(shipList);
        retList.add(eventReqBo);
        ArrayList<IUocEsSyncQryReqBo> saleList = new ArrayList<IUocEsSyncQryReqBo>();
        IUocEsSyncQryReqBo sale = new IUocEsSyncQryReqBo();
        sale.setOrderId(orderId);
        sale.setObjId(saleOrderId);
        saleList.add(sale);
        IUocEsSyncQryEventReqBo saleEventReqBo = new IUocEsSyncQryEventReqBo();
        saleEventReqBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        saleEventReqBo.setDataList(saleList);
        retList.add(saleEventReqBo);
        return retList;
    }

    @Override
    public String getEvent() {
        return "UOCE_SHIP_ARRIVA_REGIST";
    }
}

