package com.tydic.dyc.oc.components.event.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocEventConstant;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateInspOrderReqShipBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/****
 * 批量修改验收单
 */
@Component
@Slf4j

public class EventConsumerInspsUpdate implements EventConsumer {

    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public List<IUocEsSyncQryEventReqBo> parseMap(Map<String, Object> map) {
        log.info("event-EventConsumerInspsUpdate->{}", JSON.toJSONString(map));

        List<IUocEsSyncQryEventReqBo> retList = new ArrayList<>();
        Long orderId = UocRu.parseLong(map.get("orderId"));
        Long saleOrderId = UocRu.parseLong(map.get("saleOrderId"));
        Object objList = map.get("inspOrderIdList");
        if (ObjectUtil.isNotNull(objList)) {
            List<Long> inspOrderIdList = UocRu.jsl(objList, Long.class);
            List<IUocEsSyncQryReqBo> shipList = new ArrayList<>();
            if (CollectionUtil.isNotEmpty(inspOrderIdList)) {
                inspOrderIdList.forEach(x -> {
                    IUocEsSyncQryReqBo ship = new IUocEsSyncQryReqBo();
                    ship.setOrderId(orderId);
                    ship.setObjId(x);
                    shipList.add(ship);
                });
                IUocEsSyncQryEventReqBo shipEvent = new IUocEsSyncQryEventReqBo();
                shipEvent.setIndexName(uocIndexConfig.getInspOrderIndex());
                shipEvent.setDataList(shipList);
                retList.add(shipEvent);
            }
        }

        List<IUocEsSyncQryReqBo> saleList = new ArrayList<>();
        IUocEsSyncQryReqBo sale = new IUocEsSyncQryReqBo();
        sale.setOrderId(orderId);
        sale.setObjId(saleOrderId);
        saleList.add(sale);
        IUocEsSyncQryEventReqBo saleEvent = new IUocEsSyncQryEventReqBo();
        saleEvent.setIndexName(uocIndexConfig.getSaleOrderIndex());
        saleEvent.setDataList(saleList);
        retList.add(saleEvent);

        return retList;
    }

    @Override
    public String getEvent() {
        return UocEventConstant.UOC_INSP_ORDERS_SYNC;
    }
}


