package com.tydic.dyc.oc.service.checkorder;

import com.tydic.dyc.oc.model.checkorder.UocOutCheckOrderDo;
import com.tydic.dyc.oc.model.checkorder.UocOutCheckOrderModel;
import com.tydic.dyc.oc.service.checkorder.bo.UocCheckOrderBo;
import com.tydic.dyc.oc.service.checkorder.bo.UocCreateCheckOrderServiceReqBo;
import com.tydic.dyc.oc.service.checkorder.bo.UocCreateCheckOrderServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

@Slf4j
@HTServiceImpl
public class UocCreateCheckOrderServiceImpl implements UocCreateCheckOrderService{
    
    @Autowired
    private UocOutCheckOrderModel uocOutCheckOrderModel;
    
    @Override
    public UocCreateCheckOrderServiceRspBo createCheckOrder(UocCreateCheckOrderServiceReqBo reqBo) {
        UocCreateCheckOrderServiceRspBo rspBo = UocRu.success(UocCreateCheckOrderServiceRspBo.class);
        for(UocCheckOrderBo uocCheckOrderBo: reqBo.getOrderBos()){
            UocOutCheckOrderDo uocOutCheckOrderDo = UocRu.js(uocCheckOrderBo, UocOutCheckOrderDo.class);
            uocOutCheckOrderModel.createCheckOrder(uocOutCheckOrderDo);
        }
        return rspBo;
    }
}
