package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.date.DateUtil;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetCheckSaleOrdersReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocGetCheckSaleOrdersRspBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleOrderBO;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

@HTServiceImpl
public class DycGetCheckSaleOrdersServiceImpl implements DycGetCheckSaleOrdersService {
    
    @Autowired
    private IUocSaleOrderModel saleOrderModel;
    
    @Override
    public UocGetCheckSaleOrdersRspBO getCheckOrders(UocGetCheckSaleOrdersReqBO reqBO) {
        UocGetCheckSaleOrdersRspBO rspBO = new UocGetCheckSaleOrdersRspBO();
        
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSupId(Long.valueOf(reqBO.getSupId()));
        uocSaleOrderQryBo.setCreateTimeStart(DateUtil.parse(reqBO.getCreateTimeStart()));
        uocSaleOrderQryBo.setCreateTimeEnd(DateUtil.parse(reqBO.getCreateTimeEnd()));
        List<UocSaleOrderDo> saleOrderDoList = saleOrderModel.getSaleOrders(uocSaleOrderQryBo);
        List<UocSaleOrderBO> saleOrderBOS = UocRu.jsl(saleOrderDoList, UocSaleOrderBO.class);
        rspBO.setSaleOrders(saleOrderBOS);
        return rspBO;
    }
}
