package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.impl.UocAfOrderModelImpl;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderItemQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.repository.UocAfOrderRepository;
import com.tydic.dyc.oc.repository.UocSaleOrderRepository;
import com.tydic.dyc.oc.repository.UocShipOrderRepository;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderFinishConfirmReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderFinishConfirmRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderSupplierConfirmReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;

/**
 * 标题:UocAfterOrderFinishConfirmServiceImpl
 * 说明:售后完成确认
 * 时间:2022-05-13 13:54:43
 * 作者:luoyou
 */

@HTServiceImpl
public class UocAfterOrderFinishConfirmServiceImpl implements UocAfterOrderFinishConfirmService {
    @Autowired
    private IUocAfOrderModel afOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    @Autowired
    private UocAfOrderModelImpl uocAfOrderModel;
    @Autowired
    private IUocSaleOrderModel saleOrderModel;
    @Autowired
    private IUocShipOrderModel shipOrderModel;

    @Override
    public UocAfterOrderFinishConfirmRspBo finishConfirmAfterOrder(UocAfterOrderFinishConfirmReqBo reqBo) {
        val(reqBo);
        UocAfOrderDo uocAfOrderDo = new UocAfOrderDo();
        uocAfOrderDo.setAfOrderId(reqBo.getAfOrderId());
        uocAfOrderDo.setOrderId(reqBo.getOrderId());
        uocAfOrderDo.setServState(UocDicConstant.SERVICE_STATE.COMPLATE);
        //查询发货id、销售单id
        List<UocAfOrderObj> afOrderObjList = uocAfOrderModel.getAfOrderObjList(reqBo);

        //如果是供应商确认 就把servState设置为 供应商标记售后完成
        //如果是采购方确认 直接不会走这一串逻辑
        if (null!=reqBo.getFlag()&&reqBo.getFlag()==1) uocAfOrderDo.setServState(UocDicConstant.SERVICE_STATE.REMARK_COMPLATE);
        uocAfOrderDo.setFinishTime(new Date());
        //判断售后单付款状态
        //uocAfOrderDo.setPayState(payStateRevise(afOrderObjList.get(0)));
        afOrderModel.modifyAfOrderState(uocAfOrderDo);

        //修改在途数量
        if (null!=reqBo.getFlag()&&reqBo.getFlag()==1) updateAfteringCount(reqBo);
        // 提交任务
        UocCommonDo uocCommonDo = new UocCommonDo();
        List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        taskBo.setTaskId(reqBo.getTaskId());
        taskBos.add(taskBo);
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(11111l);
        uocCommonDo.setOrderId(reqBo.getOrderId());
        iUocCommonModel.dealTask(uocCommonDo);

        UocAfterOrderFinishConfirmRspBo rspBo = UocRu.success(UocAfterOrderFinishConfirmRspBo.class);
        rspBo.setShipOrderId(afOrderObjList.get(0).getShipOrderId());
        rspBo.setSaleOrderId(afOrderObjList.get(0).getSaleOrderId());
        return rspBo;
    }

    private void val(UocAfterOrderFinishConfirmReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID为空");
        }
        if (null == reqBo.getAfOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参售后单ID为空");
        }
    }


    private void updateAfteringCount(UocAfterOrderFinishConfirmReqBo reqBo) {

        uocAfOrderModel.modifyAfterOrderCount(reqBo);
    }

    private Integer payStateRevise(UocAfOrderObj afOrderObj){

        //获取销售单支付信息
        UocSaleOrderDo querySaleOrderDo = new UocSaleOrderDo();
        querySaleOrderDo.setOrderId(afOrderObj.getOrderId());
        querySaleOrderDo.setSaleOrderId(afOrderObj.getSaleOrderId());
        UocSaleOrderDo saleOrderMain = this.saleOrderModel.getSaleOrderMain(querySaleOrderDo);

        //查询该售后单所属发货单明细
        UocShipOrderItemQryBo shipOrderItemQryBo = new UocShipOrderItemQryBo();
        shipOrderItemQryBo.setShipOrderId(afOrderObj.getShipOrderId());
        shipOrderItemQryBo.setOrderId(afOrderObj.getOrderId());
        List<UocShipOrderItem> shipOrderItemList = shipOrderModel.getShipOrderItemList(shipOrderItemQryBo);
        //发货数量
        BigDecimal shipCount = shipOrderItemList.stream().map(UocShipOrderItem::getSendCount).reduce(BigDecimal.ZERO, BigDecimal::add);

        //查询售后明细
        UocAfOrderItemQryBo afOrderItemQryBo = new UocAfOrderItemQryBo();
        afOrderItemQryBo.setOrderId(afOrderObj.getOrderId());
        afOrderItemQryBo.setAfOrderId(afOrderObj.getAfOrderId());
        List<UocAfOrderItem> afOrderItemList = afOrderModel.getAfOrderItemList(afOrderItemQryBo);
        //售后数量
        BigDecimal afCount = afOrderItemList.stream().map(UocAfOrderItem::getReturnCount).reduce(BigDecimal.ZERO, BigDecimal::add);
        //售后数量等于发货单数量 则全部退款，否则部分退款
        Boolean payFlag = shipCount.compareTo(afCount) == 0 ? true:false;

        Integer patState = null;
        if(null != saleOrderMain){
            //如果支付方式为：预付款按比例支付，设置服务单支付状态为：已退款（全部售后）、部分退款（部分售后）
            if (String.valueOf(UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED).equals(saleOrderMain.getPayType())){
                if(payFlag){
                    patState = UocDicConstant.PAY_AFTER_STATE.ALL_REFUNDED;
                }else {
                    patState = UocDicConstant.PAY_AFTER_STATE.PART_REFUNDED;
                }
            }

            //如果支付方式未：按账期支付
            if (String.valueOf(UocDicConstant.PAY_TYPE.PAY_BY_PERIOD).equals(saleOrderMain.getPayType())){
                //如果销售单待支付，设置设置服务单支付状态为：已更新应付金额
                if (UocDicConstant.PAY_STATE.WAIT_PAY.equals(saleOrderMain.getPayState())) {
                    patState = UocDicConstant.PAY_AFTER_STATE.AMOUNT__DUE_UPDATED;
                }
                //如果销售单已支付，设置设置服务单支付状态为：已退款（全部售后）、部分退款（部分售后）
                if (UocDicConstant.PAY_STATE.PAYED.equals(saleOrderMain.getPayState())) {
                    if(payFlag){
                        patState = UocDicConstant.PAY_AFTER_STATE.ALL_REFUNDED;
                    }else {
                        patState = UocDicConstant.PAY_AFTER_STATE.PART_REFUNDED;
                    }
                }
            }

        }
      return patState;
    }
}
