package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.sub.UocOrderShouldPay;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateSaleOrderReturnPayResultReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateSaleOrderReturnPayResultRspBO;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @description 销售单退款结果回调服务实现类
 * @author Luokan
 * @date 2022-09-29 3:38 PM
 **/
@Slf4j
@HTServiceImpl
public class UocUpdateSaleOrderReturnPayResultServiceImpl implements UocUpdateSaleOrderReturnPayResultService {

    protected static final List<String> pCodeList = ListUtil.list(false);

    static {
        initialize();
    }

    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Autowired
    private UocEsSyncManager uocEsSyncManager;

    @Autowired
    private UocIndexConfig uocIndexConfig;

    /**
     * 销售单退款结果回调
     * @param reqBO
     * @return
     */
    @Override
    public UocUpdateSaleOrderReturnPayResultRspBO updateReturnPayResult(UocUpdateSaleOrderReturnPayResultReqBO reqBO) {
        //定义出参
        UocUpdateSaleOrderReturnPayResultRspBO rsp = UocRu.success(UocUpdateSaleOrderReturnPayResultRspBO.class);

        if (reqBO.getReturnPayResult()) {
            //查询应付单
            UocOrderShouldPay uocOrderShouldPay = new UocOrderShouldPay();
            uocOrderShouldPay.setFscShouldPayId(reqBO.getFscShouldPayId());
            UocOrderShouldPay result = this.iUocPayOrderModel.getOrderShouldPay(uocOrderShouldPay);
            if (null == result) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "未查询到该应付单");
            }
            //获取字典集合
            Map<String, Map<String, String>> dictionaryMap = iUocSysDictionaryModel.getDictionaryMap(pCodeList);
            //判断是全部退款还是部分退款
            Integer payState = null;
            String payStateStr = null;
            if (reqBO.getPayBackAmount().add(result.getPaidAmount()).compareTo(result.getPaidAmount()) == 0) {
                payState = UocDicConstant.PAY_STATE.REFUSED;
            }else {
                payState = UocDicConstant.PAY_STATE.PART_REFUSED;
            }
            //支付状态翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PAY_STATE.P_CODE)) && ObjectUtil.isNotEmpty(payState)) {
                payStateStr = dictionaryMap.get(UocDicConstant.PAY_STATE.P_CODE).get(payState.toString());
            }
            //1)、修改应付单(退款金额)
            UocOrderShouldPay set = new UocOrderShouldPay();
            //支付状态->已完成
            set.setIsPayCompleted(UocDicConstant.SHOULD_PAY_ORDER_PAY_STATE.PAY_COMPLETED);
            //已付金额
            set.setBackAmount(reqBO.getPayBackAmount().add(result.getPaidAmount()));
            set.setUpdateTime(new Date());
            UocOrderShouldPay where = new UocOrderShouldPay();
            where.setFscShouldPayId(reqBO.getFscShouldPayId());
            iUocPayOrderModel.modifyOrderShouldPayMain(set,where);
            //同步es
            syncEs(reqBO.getSaleOrderId(), payState, payStateStr);

        }else {
            //支付失败暂不处理
            //todo
        }

        return rsp;
    }

    /**
     * 同步ES
     */
    private void syncEs(Long objId, Integer payState, String payStateStr) {
        UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
        //objId
        uocEsSyncManagerSaveDataReqBo.setObjId(objId);
        //indexName
        uocEsSyncManagerSaveDataReqBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
        JSONObject jsonObj = new JSONObject();
        jsonObj.put(UocConstant.ES_MAIN_OTHER.PAY_STATE, payState);
        jsonObj.put(UocConstant.ES_MAIN_OTHER.PAY_STATE_STR, payStateStr);
        //jsonObj
        uocEsSyncManagerSaveDataReqBo.setJsonObj(jsonObj);
        log.info("更新销售单支付状态uocEsSyncManagerSaveDataReqBo为{}", JSONObject.toJSONString(uocEsSyncManagerSaveDataReqBo));
        uocEsSyncManager.updateData(uocEsSyncManagerSaveDataReqBo);
    }

    /**
     * 初始化pCode集合
     */
    private static void initialize() {
        //支付状态字典
        pCodeList.add(UocDicConstant.PAY_STATE.P_CODE);
    }
}
