package com.tydic.dyc.oc.model.common;

import com.tydic.dyc.oc.model.common.qrybo.UocConfSupplierBo;
import com.tydic.dyc.oc.model.common.sub.UocConfSupplierDO;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.order.sub.UocTodo;

import java.util.List;

import java.util.List;

/**
 * 标题:IUocCommonModel
 * 说明:公共model
 * 时间:2022/4/1 10:21
 * 作者:罗有
 */

public interface IUocCommonModel {
    /*
     * @Author lsl
     * @Description //TODO 根据供应商编码查询对应的供应商配置信息
     * @Date 18:02 2022/4/7
     * @Param [goodsSupplierNo]
     * @return
     */
    UocConfSupplierBo qryConfSupplier(String goodsSupplierNo);

    List<UocConfSupplierDO> qryConfSupplierList(UocConfSupplierDO uocConfSupplierDO);

    /**
     * 上传服务
     * @param uocCommonDo
     * @return
     */
    UocCommonDo uploadFile(UocCommonDo uocCommonDo);

    /**
     * 描述:保存外部关联数据
     * @param index 入参
     * @return int
     * @author tgy
     * @date 2022/4/13 10:35
     */
    int saveOrderQueryIndex(UocOrderQueryIndex index);

    UocCommonDo dealTask(UocCommonDo uocCommonDo);

    List<UocOrderTaskInst> qryTaskInst(UocOrderTaskInst uocOrderTaskInst);

    /**
     * 保存待办信息
     * @param uocTodo
     * @return
     */
    int saveTodoInfo(UocTodo uocTodo);

    /**
     * 根据主键id更新待办信息
     * @param uocTodo
     * @return
     */
    int updateTodoById(UocTodo uocTodo);

    /**
     * 查询单条待办信息
     * @param uocTodo
     * @return
     */
    UocTodo getTodoInfo(UocTodo uocTodo);

    /**
     * 查询多条待办信息
     * @param uocTodo
     * @return
     */
    List<UocTodo> getTodoListInfo(UocTodo uocTodo);

    /**
     * 批量插入待办信息
     * @param list
     */
    void insertBatchTodo(List<UocTodo> list);
}
