package com.tydic.dyc.oc.service.common;

import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.service.common.bo.UocQryTaskDealReqBo;
import com.tydic.dyc.oc.service.common.bo.UocQryTaskDealRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * @author yinletian
 * @date 2022/10/28
 */
@HTServiceImpl
public class UocQryTaskDealServiceImpl implements UocQryTaskDealService{

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public UocQryTaskDealRspBo qryTaskDeal(UocQryTaskDealReqBo reqBo) {
        UocQryTaskDealRspBo rspBo = new UocQryTaskDealRspBo();
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);

        //查询最新任务实例
        UocOrderTaskInstQryBo instQryBo = new UocOrderTaskInstQryBo();
        instQryBo.setOrderId(reqBo.getOrderId());
        instQryBo.setDelTag(0);
        instQryBo.setFinishTag(0);
        List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(instQryBo);
        UocOrderTaskInst uocOrderTaskInst = uocOrderTaskInsts.get(0);
        //查询订单任务处理实例
        UocOrderTaskDealQryBo dealQryBo = new UocOrderTaskDealQryBo();
        dealQryBo.setOrderId(reqBo.getOrderId());
        dealQryBo.setTaskInstId(uocOrderTaskInst.getTaskInstId());
        List<UocOrderTaskDeal> uocOrderTaskDeals = iUocOrderModel.qryOrderTaskDealList(dealQryBo);
        rspBo.setCandidateOperId(uocOrderTaskDeals.get(0).getDealId());
        rspBo.setCandidateOperName(uocOrderTaskDeals.get(0).getDealName());

        return rspBo;
    }
}
