/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.sub.UocOrderShouldPay;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.UocUpdateSaleOrderReturnPayResultService;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateSaleOrderReturnPayResultReqBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocUpdateSaleOrderReturnPayResultRspBO;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/3.0.0/com.tydic.dyc.oc.service.saleorder.UocUpdateSaleOrderReturnPayResultService"})
public class UocUpdateSaleOrderReturnPayResultServiceImpl
implements UocUpdateSaleOrderReturnPayResultService {
    private static final Logger log = LoggerFactory.getLogger(UocUpdateSaleOrderReturnPayResultServiceImpl.class);
    protected static final List<String> pCodeList = ListUtil.list((boolean)false);
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private UocEsSyncManager uocEsSyncManager;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"updateReturnPayResult"})
    public UocUpdateSaleOrderReturnPayResultRspBO updateReturnPayResult(@RequestBody UocUpdateSaleOrderReturnPayResultReqBO reqBO) {
        UocUpdateSaleOrderReturnPayResultRspBO rsp = UocRu.success(UocUpdateSaleOrderReturnPayResultRspBO.class);
        if (reqBO.getReturnPayResult().booleanValue()) {
            UocOrderShouldPay uocOrderShouldPay = new UocOrderShouldPay();
            uocOrderShouldPay.setFscShouldPayId(reqBO.getFscShouldPayId());
            UocOrderShouldPay result = this.iUocPayOrderModel.getOrderShouldPay(uocOrderShouldPay);
            if (null == result) {
                throw new BaseBusinessException("100001", "\u672a\u67e5\u8be2\u5230\u8be5\u5e94\u4ed8\u5355");
            }
            Map<String, Map<String, String>> dictionaryMap = this.iUocSysDictionaryModel.getDictionaryMap(pCodeList);
            Integer payState = null;
            String payStateStr = null;
            payState = reqBO.getPayBackAmount().add(result.getPaidAmount()).compareTo(result.getPaidAmount()) == 0 ? UocDicConstant.PAY_STATE.REFUSED : UocDicConstant.PAY_STATE.PART_REFUSED;
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_PAY_STATE")) && ObjectUtil.isNotEmpty((Object)payState)) {
                payStateStr = dictionaryMap.get("UOC_SALE_ORDER_PAY_STATE").get(payState.toString());
            }
            UocOrderShouldPay set = new UocOrderShouldPay();
            set.setIsPayCompleted(UocDicConstant.SHOULD_PAY_ORDER_PAY_STATE.PAY_COMPLETED);
            set.setBackAmount(reqBO.getPayBackAmount().add(result.getPaidAmount()));
            set.setUpdateTime(new Date());
            UocOrderShouldPay where = new UocOrderShouldPay();
            where.setFscShouldPayId(reqBO.getFscShouldPayId());
            this.iUocPayOrderModel.modifyOrderShouldPayMain(set, where);
            this.syncEs(reqBO.getSaleOrderId(), payState, payStateStr);
        }
        return rsp;
    }

    private void syncEs(Long objId, Integer payState, String payStateStr) {
        UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
        uocEsSyncManagerSaveDataReqBo.setObjId(objId);
        uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getSaleOrderIndex());
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("payState", (Object)payState);
        jsonObj.put("payStateStr", (Object)payStateStr);
        uocEsSyncManagerSaveDataReqBo.setJsonObj(jsonObj);
        log.info("\u66f4\u65b0\u9500\u552e\u5355\u652f\u4ed8\u72b6\u6001uocEsSyncManagerSaveDataReqBo\u4e3a{}", (Object)JSONObject.toJSONString((Object)uocEsSyncManagerSaveDataReqBo));
        this.uocEsSyncManager.updateData(uocEsSyncManagerSaveDataReqBo);
    }

    private static void initialize() {
        pCodeList.add("UOC_SALE_ORDER_PAY_STATE");
    }

    static {
        UocUpdateSaleOrderReturnPayResultServiceImpl.initialize();
    }
}

