package com.tydic.dyc.oc.service.common;

import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.common.bo.UocQryTaskDealReqBo;
import com.tydic.dyc.oc.service.common.bo.UocQryTaskDealRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import java.util.List;

/**
 * @author yinletian
 * @date 2022/10/28
 */
@HTServiceImpl
public class UocQryTaskDealServiceImpl implements UocQryTaskDealService{

    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;

    @Override
    public UocQryTaskDealRspBo qryTaskDeal(UocQryTaskDealReqBo reqBo) {
        UocQryTaskDealRspBo rspBo = new UocQryTaskDealRspBo();
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);

        //待办查询
        if("1".equals(reqBo.getType())) {
            //待办查询对应类型的单据编号
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(UocRu.js(reqBo, UocOrderTaskInstQryBo.class));
            UocOrderTaskInst uocOrderTaskInst = uocOrderTaskInsts.get(0);
            reqBo.setType(uocOrderTaskInst.getObjType() + "");
            reqBo.setAuditOrderId(uocOrderTaskInst.getObjId()+"");
            rspBo.setBusiId(getOrderNo(uocOrderTaskInst));
        }
        if(UocDicConstant.OBJ_TYPE.APPROVE.equals(reqBo.getType())) {
                //查询审批单，订单id+审批单id
                UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
                uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
                uocApprovalObjQryBo.setAuditOrderId(Long.parseLong(reqBo.getAuditOrderId()));
                List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
                rspBo.setBusiType(uocApprovalObjs.get(0).getObjBusiType() + "");

                UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
                //订单id
                uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
                //销售单id
                uocSaleOrderQryBo.setSaleOrderId(Long.parseLong(uocApprovalObjs.get(0).getObjId()));
                UocSaleOrderDo saleOrderMainInfo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
                rspBo.setOrderSource(saleOrderMainInfo.getOrderSource());
                rspBo.setBusiId(saleOrderMainInfo.getSaleOrderNo());
        }

        return rspBo;
    }


    private String getOrderNo(UocOrderTaskInst uocOrderTaskInst) {
        if (UocDicConstant.OBJ_TYPE.SALE.equals(uocOrderTaskInst.getObjType())) {
            UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
            uocSaleOrderQryBo.setOrderId(uocOrderTaskInst.getOrderId());
            uocSaleOrderQryBo.setSaleOrderId(uocOrderTaskInst.getObjId());
            UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
            if (null != uocSaleOrderDo) {
                return uocSaleOrderDo.getSaleOrderNo();
            }
        }
        if (UocDicConstant.OBJ_TYPE.SHIP.equals(uocOrderTaskInst.getObjType())) {
            UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
            uocShipOrderQryBo.setOrderId(uocOrderTaskInst.getOrderId());
            uocShipOrderQryBo.setShipOrderId(uocOrderTaskInst.getObjId());
            UocShipOrderDo uocShipOrderDo = iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
            if (null != uocShipOrderDo) {
                return uocShipOrderDo.getShipOrderNo();
            }
        }
        if (UocDicConstant.OBJ_TYPE.CHNG.equals(uocOrderTaskInst.getObjType())) {
            UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
            uocChngOrderQryBo.setOrderId(uocOrderTaskInst.getOrderId());
            uocChngOrderQryBo.setChngOrderId(uocOrderTaskInst.getObjId());
            UocChngOrderDo chngOrder = iUocChngOrderModel.getChngOrder(uocChngOrderQryBo);
            if (null != chngOrder) {
                return chngOrder.getChngOrderNo();
            }
        }
        if (UocDicConstant.OBJ_TYPE.AFTER.equals(uocOrderTaskInst.getObjType())) {
            UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
            uocAfOrderQryBo.setOrderId(uocOrderTaskInst.getOrderId());
            uocAfOrderQryBo.setAfOrderId(uocOrderTaskInst.getObjId());
            UocAfOrder afOrderById = iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
            if (null != afOrderById) {
                return afOrderById.getAfServCode();
            }
        }
        return null;
    }
}
