package com.tydic.dyc.oc.service.common;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.common.bo.UocQryTaskDealReqBo;
import com.tydic.dyc.oc.service.common.bo.UocQryTaskDealRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import java.util.List;

/**
 * @author yinletian
 * @date 2022/10/28
 */
@Slf4j
@HTServiceImpl
public class UocQryTaskDealServiceImpl implements UocQryTaskDealService{

    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;

    @Override
    public UocQryTaskDealRspBo qryTaskDeal(UocQryTaskDealReqBo reqBo) {
        UocQryTaskDealRspBo rspBo = new UocQryTaskDealRspBo();
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);

        //待办查询
        if("1".equals(reqBo.getType())) {
            rspBo.setBusiId(getOrderNo(reqBo));
        }
        if("9".equals(reqBo.getType())) {
                //查询审批单，订单id+审批单id
                UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
                uocApprovalObjQryBo.setOrderId(reqBo.getOrderId());
                uocApprovalObjQryBo.setAuditOrderId(Long.parseLong(reqBo.getAuditOrderId()));
                List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
                rspBo.setBusiType(uocApprovalObjs.get(0).getObjBusiType() + "");

                UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
                //订单id
                uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
                //销售单id
                uocSaleOrderQryBo.setSaleOrderId(Long.parseLong(uocApprovalObjs.get(0).getObjId()));
                UocSaleOrderDo saleOrderMainInfo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
                rspBo.setOrderSource(saleOrderMainInfo.getOrderSource());
                rspBo.setSaleOrderId(saleOrderMainInfo.getSaleOrderId());
        }
        log.info("待办查询出参："+JSON.toJSONString(rspBo));
        return rspBo;
    }


    private String getOrderNo(UocQryTaskDealReqBo dealReqBo) {
        //变更单
        if (null != dealReqBo.getChngOrderId()) {
            UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
            uocChngOrderQryBo.setOrderId(dealReqBo.getOrderId());
            uocChngOrderQryBo.setChngOrderId(dealReqBo.getChngOrderId());
            UocChngOrderDo chngOrder = iUocChngOrderModel.getChngOrder(uocChngOrderQryBo);
            if (null != chngOrder) {
                return chngOrder.getChngOrderNo();
            }
        } else if (null != dealReqBo.getAfOrderId()) {
            //售后单
            UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
            uocAfOrderQryBo.setOrderId(dealReqBo.getOrderId());
            uocAfOrderQryBo.setAfOrderId(dealReqBo.getAfOrderId());
            UocAfOrder afOrderById = iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
            if (null != afOrderById) {
                return afOrderById.getAfServCode();
            }
        }else {
            UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
            uocSaleOrderQryBo.setOrderId(dealReqBo.getOrderId());
            uocSaleOrderQryBo.setSaleOrderId(dealReqBo.getSaleOrderId());
            UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
            if (null != uocSaleOrderDo) {
                return uocSaleOrderDo.getSaleOrderNo();
            }
        }
        return null;
    }
}
