package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderWaybill;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderWaybillUpholdReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderWaybillUpholdRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题：类名称:UocAfterOrderWaybillUpholdServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/4/11 16:49
 * 作者 @author 尹栋梁
 */
@HTServiceImpl
public class UocAfterOrderWaybillUpholdServiceImpl implements UocAfterOrderWaybillUpholdService{
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;

    @Autowired
    private IUocOrderModel orderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;


    @Autowired
    private IUocCommonModel iUocCommonModel;

    @Override
    public UocAfterOrderWaybillUpholdRspBo dealWaybillUphold(UocAfterOrderWaybillUpholdReqBo reqBo) {
        UocAfterOrderWaybillUpholdRspBo rspBo = UocRu.success(UocAfterOrderWaybillUpholdRspBo.class);
        //参数校验
        validateArg(reqBo);
        UocAfOrderWaybill uocAfOrderWaybill = UocRu.js(reqBo, UocAfOrderWaybill.class);
        try {
            uocAfOrderWaybill.setFreight(Long.parseLong(reqBo.getFreight()));
        } catch (NumberFormatException e) {
            throw new ZTBusinessException("转换运费失败,"+e.getMessage());
        }
        uocAfOrderWaybill.setToPay(Long.parseLong(reqBo.getToPay().toString()));
        uocAfOrderWaybill.setCreateTime(new Date());
        uocAfOrderWaybill.setCreateOperId(String.valueOf(reqBo.getUserId()));
        iUocAfOrderModel.addWayBill(uocAfOrderWaybill);


        //查询任务信息
        //UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        //uocOrderTaskInst.setOrderId(reqBo.getOrderId());
        //uocOrderTaskInst.setObjId(reqBo.getAfOrderId());
        //uocOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        //uocOrderTaskInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        //List<UocOrderTaskInst> uocOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
        //
        //if (CollectionUtil.isEmpty(uocOrderTaskInsts)) {
        //    throw new ZTBusinessException("查询售后单任务信息失败,销售单id:"+reqBo.getAfOrderId());
        //}
        //UocOrderTaskInst uocOrderTaskInst1 = uocOrderTaskInsts.get(0);
        //rspBo.setTaskId(uocOrderTaskInst1.getTaskInstId());
        //rspBo.setStepId(uocOrderTaskInst1.getProcState());
        //查询三方信息
        UocOrderStakeholderQryBo uocOrderStakeholderQryBo = new UocOrderStakeholderQryBo();
        uocOrderStakeholderQryBo.setOrderId(reqBo.getOrderId());
        List<UocOrderStakeholderQryBo> uocOrderStakeholderQryBos = orderModel.qryStakeholderList(uocOrderStakeholderQryBo);
        if (CollectionUtil.isNotEmpty(uocOrderStakeholderQryBos)) {
            String supId = uocOrderStakeholderQryBos.get(0).getSupId();
            rspBo.setSupId(supId);
        }

        //查询外部售后单号
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setOrderId(reqBo.getOrderId());
        uocAfOrderQryBo.setAfOrderId(reqBo.getAfOrderId());
        UocAfOrder afOrderById = iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
        String extAfId = afOrderById.getExtAfId();
        rspBo.setExtAfId(extAfId);

        //修改维护标识
        UocAfOrderDo uocAfOrderDo = new UocAfOrderDo();
        uocAfOrderDo.setAfOrderId(reqBo.getAfOrderId());
        uocAfOrderDo.setWaybillFlag(0);
        iUocAfOrderModel.updateAfOrderMain(uocAfOrderDo);

        //to do
//        rspBo.setSaleOrderId(afOrderById.getSaleOrderId());
//        rspBo.setThirdApplyId(afOrderById.getThirdApplyId());

        // 提交任务
        //UocCommonDo uocCommonDo = new UocCommonDo();
        //List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
        //UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        //taskBo.setTaskId(rspBo.getTaskId());
        //taskBos.add(taskBo);
        //uocCommonDo.setCompleteTaskInfos(taskBos);
        //uocCommonDo.setUserId(reqBo.getUserId());
        //uocCommonDo.setOrderId(reqBo.getOrderId());
        //iUocCommonModel.dealTask(uocCommonDo);
        return rspBo;
    }

    private void validateArg(UocAfterOrderWaybillUpholdReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocAfterOrderCancelReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单ID]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getAfOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[售后单ID]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getFreight())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[运费]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getToPay())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[是否到付]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getForwardCompany())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[发运公司]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getForwardDate())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[发运日期]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getForwardOrderNo())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[运单号]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSendCount())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[本次发货数量]不能为空");
        }
    }
}
