package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocEvaluateQryBo;
import com.tydic.dyc.oc.model.order.sub.UocEvaluate;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEvaluateDealServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEvaluateDealServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 描述: 〈领域服务-销售单评价回调实现〉
 * @author : yuhao
 * @date : 2022/9/9 14:48
 */
@Slf4j
@HTServiceImpl
public class UocEvaluateDealServiceImpl implements UocEvaluateDealService {

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocEvaluateDealServiceRspBo dealEvaluate(UocEvaluateDealServiceReqBo reqBo) {
        //入参校验
        this.verifyParam(reqBo);

        Long saleOrderId = null;
        Long orderId = null;
        if(null != reqBo.getSaleOrderId() && null != reqBo.getOrderId()){
            //如果入参有订单id和销售单id
            saleOrderId = reqBo.getSaleOrderId();
            orderId = reqBo.getOrderId();
        }else{
            //根据销售单编号去查询获取订单id和销售单id
            UocSaleOrderDo querySaleOrderDo = new UocSaleOrderDo();
            querySaleOrderDo.setSaleOrderNo(reqBo.getSaleOrderNo());
            UocSaleOrderDo saleOrderMainInfo = this.iUocSaleOrderModel.getSaleOrderMain(querySaleOrderDo);
            if(null != saleOrderMainInfo){
                saleOrderId = saleOrderMainInfo.getSaleOrderId();
                orderId = saleOrderMainInfo.getOrderId();
            }else{
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "根据销售单编号查询销售单信息失败");
            }
        }

        //查询销售单评价信息
        List<UocEvaluate> saleOrderEvaluateInfo = this.querySaleOrderEvaluateInfo(saleOrderId,orderId);

        if (CollectionUtils.isNotEmpty(saleOrderEvaluateInfo)) {
            //如果销售单评价信息存在就修改状态
            for (UocEvaluate uocEvaluate : saleOrderEvaluateInfo) {
                UocEvaluate updateEva = new UocEvaluate();
                //设置评价数据ID
                updateEva.setId(uocEvaluate.getId());
                //设置评价状态
                updateEva.setEvaluateState(reqBo.getEvaluateState());
                this.iUocOrderModel.updateOrderEvaluate(updateEva);
            }
        }else{
            UocEvaluate addEvaluate = new UocEvaluate();
            //设置单据类型
            addEvaluate.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            //设置评价数据ID
            addEvaluate.setId(IdUtil.nextId());
            //设置订单id
            addEvaluate.setOrderId(orderId);
            //设置创建工号
            addEvaluate.setCreateOperId(String.valueOf(reqBo.getUserId()));
            //设置评价状态
            addEvaluate.setEvaluateState(reqBo.getEvaluateState());
            //设置单据id
            addEvaluate.setObjId(saleOrderId);
            this.iUocOrderModel.insertOrderEvaluate(addEvaluate);
        }

        UocEvaluateDealServiceRspBo rspBo = new UocEvaluateDealServiceRspBo();
        rspBo.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        rspBo.setOrderId(orderId);
        rspBo.setSaleOrderId(saleOrderId);
        return rspBo;
    }


    /**
     * 查询销售单评价信息
     */
    private List<UocEvaluate> querySaleOrderEvaluateInfo(Long saleOrderId,Long orderId){
        //查询销售单评价信息
        UocEvaluateQryBo uocEvaluateQryBo = new UocEvaluateQryBo();
        uocEvaluateQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocEvaluateQryBo.setObjId(saleOrderId);
        uocEvaluateQryBo.setOrderId(orderId);
        List<UocEvaluate> uocEvaluates = this.iUocOrderModel.qryOrderEvaluateList(uocEvaluateQryBo);
        return uocEvaluates;
    }

    /**
     * 参数校验
     * @param reqBo
     */
    private void verifyParam(UocEvaluateDealServiceReqBo reqBo){
        if (ObjectUtil.isNull(reqBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参不能为空");
        }
        if (StringUtils.isBlank(reqBo.getSaleOrderNo())) {
            if (reqBo.getOrderId() == null) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单ID不能为空");
            }
            if (reqBo.getSaleOrderId() == null) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单ID不能为空");
            }
        }
        if (reqBo.getEvaluateState() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "评价状态不能为空");
        }
    }
}
