package com.tydic.dyc.oc.service.domainservice;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

@HTServiceImpl
public class UocGetCheckAfOrdersServiceImpl implements UocGetCheckAfOrdersService{
    
    @Autowired
    private IUocAfOrderModel uocAfOrderModel;
    
    @Override
    public UocGetCheckAfOrdersRspBO getCheckAfOrders(UocGetCheckAfOrdersReqBO reqBO) {
        UocGetCheckAfOrdersRspBO rspBO = new UocGetCheckAfOrdersRspBO();
        UocAfOrderDo uocAfOrderDo = new UocAfOrderDo();
        uocAfOrderDo.setSupNo(reqBO.getSupId());
        uocAfOrderDo.setConfirmTimeStart(DateUtils.strToDate(reqBO.getConfirmTimeStart(),"yyyy-MM-dd HH:mm:ss"));
        uocAfOrderDo.setConfirmTimeEnd(DateUtils.strToDate(reqBO.getConfirmTimeEnd(),"yyyy-MM-dd HH:mm:ss"));
    
        List<UocAfOrderDo> uocAfOrderDos = uocAfOrderModel.getCheckAfOrders(uocAfOrderDo);
        List<UocAfOrderBO> uocAfOrderBOS = UocRu.jsl(uocAfOrderDos, UocAfOrderBO.class);
        rspBO.setUocAfOrderBOS(uocAfOrderBOS);
        return rspBO;
    }
}
